/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.OrgListDTO;
import org.lamsfoundation.lams.admin.web.OrgManageBean;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class OrgManageAction
extends Action {
    private static final Logger log = Logger.getLogger(OrgManageAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"org", (boolean)true);
        if (orgId == null) {
            orgId = (Integer)request.getAttribute("org");
        }
        if (orgId == null || orgId <= 0) {
            request.setAttribute("errorName", (Object)"OrgManageAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.org.invalid"));
            return mapping.findForward("error");
        }
        OrgListDTO orgManageForm = new OrgListDTO();
        Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        log.debug((Object)("orgId:" + orgId));
        if (org == null) {
            request.setAttribute("errorName", (Object)"OrgManageAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.org.invalid"));
            return mapping.findForward("error");
        }
        if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
            request.setAttribute("errorName", (Object)"OrgManageAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.orgtype.invalid"));
            return mapping.findForward("error");
        }
        orgManageForm.setParentId(orgId);
        orgManageForm.setParentName(org.getName());
        orgManageForm.setType(org.getOrganisationType().getOrganisationTypeId());
        log.debug((Object)("orgType:" + orgManageForm.getType()));
        ArrayList<OrgManageBean> orgManageBeans = new ArrayList<OrgManageBean>();
        Integer userId = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        if (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER")) {
            Integer type = orgManageForm.getType().equals(OrganisationType.ROOT_TYPE) ? OrganisationType.COURSE_TYPE : OrganisationType.CLASS_TYPE;
            List organisations = service.findByProperty(Organisation.class, "organisationType.organisationTypeId", (Object)type);
            log.debug((Object)"user is an admin or manager");
            log.debug((Object)("Got " + organisations.size() + " organisations"));
            log.debug((Object)("organisationType is " + type));
            for (int i = 0; i < organisations.size(); ++i) {
                Organisation parentOrg;
                Organisation organisation = (Organisation)organisations.get(i);
                Organisation organisation2 = parentOrg = type.equals(OrganisationType.CLASS_TYPE) ? organisation.getParentOrganisation() : organisation;
                if (!request.isUserInRole("SYSADMIN") && !service.isUserInRole(userId, parentOrg.getOrganisationId(), "GROUP ADMIN") && !service.isUserInRole(userId, parentOrg.getOrganisationId(), "GROUP MANAGER") && !service.isUserGlobalGroupAdmin() || type.equals(OrganisationType.CLASS_TYPE) && !parentOrg.getOrganisationId().equals(orgId)) continue;
                OrgManageBean orgManageBean = new OrgManageBean();
                BeanUtils.copyProperties((Object)orgManageBean, (Object)organisation);
                orgManageBean.setStatus(organisation.getOrganisationState().getDescription());
                orgManageBean.setEditable(true);
                orgManageBeans.add(orgManageBean);
            }
        }
        Collections.sort(orgManageBeans);
        orgManageForm.setOrgManageBeans(orgManageBeans);
        request.setAttribute("OrgManageForm", (Object)orgManageForm);
        request.setAttribute("createOrEditGroup", (Object)(request.isUserInRole("SYSADMIN") || service.isUserGlobalGroupAdmin() ? 1 : 0));
        request.setAttribute("manageGlobalRoles", (Object)request.isUserInRole("SYSADMIN"));
        return mapping.findForward("orglist");
    }
}

