/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolContentListAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!request.isUserInRole("SYSADMIN") && !request.isUserInRole("AUTHOR ADMIN")) {
            request.setAttribute("errorName", (Object)"ToolContentListAction");
            request.setAttribute("errorMessage", (Object)AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        ILearningDesignService learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignServiceTarget");
        ArrayList learningLibraryDTOs = learningDesignService.getAllLearningLibraryDetails();
        ArrayList<LibraryActivityDTO> activeTools = this.filterActiveTools(learningLibraryDTOs);
        request.setAttribute("activeTools", activeTools);
        return mapping.findForward("toolcontentlist");
    }

    private ArrayList<LibraryActivityDTO> filterActiveTools(List learningLibraryDTOs) {
        ArrayList<LibraryActivityDTO> activeTools = new ArrayList<LibraryActivityDTO>();
        for (int i = 0; i < learningLibraryDTOs.size(); ++i) {
            LearningLibraryDTO dto = (LearningLibraryDTO)learningLibraryDTOs.get(i);
            if (!dto.getValidFlag().booleanValue()) continue;
            Vector templateActivities = dto.getTemplateActivities();
            for (int j = 0; j < templateActivities.size(); ++j) {
                LibraryActivityDTO template = (LibraryActivityDTO)templateActivities.get(j);
                if (template.getToolContentID() == null || this.toolExists(template, activeTools)) continue;
                activeTools.add(template);
            }
        }
        return activeTools;
    }

    private boolean toolExists(LibraryActivityDTO item, ArrayList<LibraryActivityDTO> list) {
        for (LibraryActivityDTO l : list) {
            if (!StringUtils.equals((String)item.getToolSignature(), (String)l.getToolSignature())) continue;
            return true;
        }
        return false;
    }
}

