/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.UserBean;
import org.lamsfoundation.lams.admin.web.UserOrgRoleForm;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class UserOrgRoleAction
extends Action {
    private static Logger log = Logger.getLogger(UserOrgRoleAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        UserOrgRoleForm userOrgRoleForm = (UserOrgRoleForm)form;
        userOrgRoleForm.setUserBeans(new ArrayList());
        List roles = (List)request.getAttribute("roles");
        request.setAttribute("numroles", (Object)roles.size());
        Collections.sort(roles);
        request.setAttribute("roles", (Object)roles);
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)((Integer)request.getAttribute("orgId")));
        userOrgRoleForm.setOrgId(organisation.getOrganisationId());
        request.setAttribute("orgName", (Object)organisation.getName());
        Organisation parentOrg = organisation.getParentOrganisation();
        if (parentOrg != null && !parentOrg.equals((Object)service.getRootOrganisation())) {
            request.setAttribute("pOrgId", (Object)parentOrg.getOrganisationId());
            request.setAttribute("pOrgName", (Object)parentOrg.getName());
        }
        request.setAttribute("orgType", (Object)organisation.getOrganisationType().getOrganisationTypeId());
        ArrayList userOrgs = (ArrayList)request.getAttribute("newUserOrganisations");
        for (int i = 0; i < userOrgs.size(); ++i) {
            UserBean userBean = new UserBean();
            User user = ((UserOrganisation)userOrgs.get(i)).getUser();
            BeanUtils.copyProperties((Object)userBean, (Object)user);
            userBean.setMemberOfParent(true);
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) && service.getUserOrganisation(user.getUserId(), organisation.getParentOrganisation().getOrganisationId()) == null) {
                userBean.setMemberOfParent(false);
            }
            userOrgRoleForm.addUserBean(userBean);
            log.debug((Object)("ready to assign role for user=" + userBean.getUserId()));
        }
        log.debug((Object)("ready to assign roles for " + userOrgRoleForm.getUserBeans().size() + " new users in organisation " + organisation.getName()));
        return mapping.findForward("userorgrole");
    }
}

