/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.logevent.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.logevent.LogEvent;
import org.lamsfoundation.lams.logevent.dao.ILogEventDAO;

public class LogEventDAO
extends BaseDAO
implements ILogEventDAO {
    private static final String GET_LOG_EVENT_BY_ID = "from " + LogEvent.class.getName() + "where id = ?";
    private static final String GET_LOG_EVENT_BY_USER = "from " + LogEvent.class.getName() + " where user_id = ? order by occurred_date_time asc";
    private static final String GET_LOG_EVENTS_OCCURED_BETWEEN_DATES = "from " + LogEvent.class.getName() + " where occurred_date_time > ? and occurred_date_time <= ? order by occurred_date_time asc";

    @Override
    public void save(LogEvent logEvent) {
        super.insert(logEvent);
    }

    @Override
    public LogEvent getById(Long logEventId) {
        List list = this.getHibernateTemplate().find(GET_LOG_EVENT_BY_ID, (Object)logEventId);
        if (list.size() > 0) {
            return (LogEvent)list.get(0);
        }
        return null;
    }

    @Override
    public List<LogEvent> getByUser(Integer userId) {
        return this.getHibernateTemplate().find(GET_LOG_EVENT_BY_USER, (Object)userId);
    }

    @Override
    public List<LogEvent> getEventsOccurredBetween(Date startDate, Date finishDate) {
        return this.getHibernateTemplate().find(GET_LOG_EVENTS_OCCURED_BETWEEN_DATES, (Object[])new Date[]{startDate, finishDate});
    }
}

