/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

public class TempDirectoryFilter
implements FileFilter {
    private long newestDateToKeep = 0L;
    public static final String zip_prefix = "lamszip_";
    public static final String tmp_prefix = "lamstmp_";
    private Logger log = null;

    public TempDirectoryFilter(long newestDateToKeep, Logger log) {
        this.newestDateToKeep = newestDateToKeep;
        this.log = log;
    }

    @Override
    public boolean accept(File candidate) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking file " + candidate + " date modified " + candidate.lastModified()));
        }
        if (candidate.getName().startsWith(zip_prefix) || candidate.getName().startsWith(tmp_prefix)) {
            if (!candidate.isDirectory()) {
                this.log.debug((Object)"Candidate file is not is named as we expected, but it is not a directory. Skipping file.");
                return false;
            }
            return candidate.lastModified() < this.newestDateToKeep;
        }
        return false;
    }
}

