/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class UploadFileUtil {
    private static Logger log = Logger.getLogger(UploadFileUtil.class);
    private static final int DEFAULT_MAX_SIZE = 5000000;
    private static final int DEFAULT_MEMORY_SIZE = 4096;

    public static List<FileItem> getUploadItems(HttpServletRequest request, boolean useLargeFileSize) throws FileUploadException, Exception {
        return UploadFileUtil.getUploadItems(request, useLargeFileSize, null);
    }

    public static List<FileItem> getUploadItems(HttpServletRequest request, boolean useLargeFileSize, String tempDirNameInput) throws FileUploadException, Exception {
        File dir;
        int max_memory_size;
        int max_size = 5000000;
        String tempDirName = null;
        int tempInt = -1;
        if (useLargeFileSize) {
            tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE);
            if (tempInt != -1) {
                max_size = tempInt;
            } else {
                log.warn((Object)"Default Large Max Size for file upload missing, using 5000000");
            }
        } else {
            tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
            if (tempInt != -1) {
                max_size = tempInt;
            } else {
                log.warn((Object)"Default Max Size for file upload missing, using 5000000");
            }
        }
        tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_MEMORY_SIZE);
        if (tempInt != -1) {
            max_memory_size = tempInt;
        } else {
            log.warn((Object)"Default Max Memory Size for file upload missing, using 4096");
            max_memory_size = 4096;
        }
        if (tempDirNameInput != null) {
            tempDirName = tempDirNameInput;
        } else {
            tempDirName = Configuration.get(ConfigurationKeys.LAMS_TEMP_DIR);
            if (tempDirName == null) {
                log.warn((Object)"Default Temporary Directory missing, using null");
            }
        }
        if (tempDirName != null && !(dir = new File(tempDirName)).exists()) {
            dir.mkdirs();
        }
        DiskFileUpload upload = new DiskFileUpload();
        upload.setSizeMax((long)max_size);
        upload.setSizeThreshold(max_memory_size);
        upload.setRepositoryPath(tempDirName);
        List items = upload.parseRequest(request);
        return items;
    }

    public static float getMaxFileSize() {
        int max_size = 5000000;
        int tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
        if (tempInt != -1) {
            max_size = tempInt;
        }
        return max_size != 0 ? (float)max_size / 1024.0f / 1024.0f : 0.0f;
    }

    public static float getMaxLargeFileSize() {
        int max_size = 5000000;
        int tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE);
        if (tempInt != -1) {
            max_size = tempInt;
        }
        return max_size != 0 ? (float)max_size / 1024.0f / 1024.0f : 0.0f;
    }

    public static File getUploadBaseDir() {
        String baseDirPath = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure";
        File baseDir = new File(baseDirPath);
        baseDir.mkdir();
        return baseDir;
    }

    public static File getUploadDir(String contentFolderID, String type) {
        File uploadDir = new File(UploadFileUtil.getUploadBaseDir(), contentFolderID + File.separatorChar + type);
        uploadDir.mkdirs();
        return uploadDir;
    }

    public static String getUploadFileName(File uploadDir, String fileName) {
        int counter = 1;
        String finalName = fileName;
        File uploadFile = new File(uploadDir, fileName);
        while (uploadFile.exists()) {
            finalName = UploadFileUtil.getFileNameWithoutExtension(fileName) + "_" + counter + "." + UploadFileUtil.getFileExtension(fileName);
            uploadFile = new File(uploadDir, finalName);
            ++counter;
        }
        return finalName;
    }

    public static String getUploadWebPath(String contentFolderID, String type) {
        return "/" + Configuration.get(ConfigurationKeys.SERVER_URL_CONTEXT_PATH) + "/" + "www/" + "secure" + (contentFolderID.startsWith("/") ? "" : "/") + contentFolderID + (contentFolderID.endsWith("/") ? "" : "/") + type;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

