/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.svg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.ActivityDTOOrderComparator;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.svg.ActivityTreeNode;
import org.lamsfoundation.lams.util.svg.ActivityTreeNodeComparator;
import org.lamsfoundation.lams.util.svg.SVGConstants;
import org.lamsfoundation.lams.util.svg.SVGTrigonometryUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.svg.SVGDocument;

public class SVGGenerator {
    public static final int OUTPUT_FORMAT_SVG = 1;
    public static final int OUTPUT_FORMAT_PNG = 2;
    public static final int OUTPUT_FORMAT_SYSTEM_OUT = 3;
    public static final int OUTPUT_FORMAT_SVG_LAMS_COMMUNITY = 4;
    private SVGDocument doc;
    private Integer outputFormat;
    private Integer adjustedDocumentWidth;
    private final String localSvgIconsPath = Configuration.get(ConfigurationKeys.SERVER_URL) + "images/svg/";
    private Point branchingStartPoint;
    private Point branchingEndPoint;
    private static final Logger log = Logger.getLogger(SVGGenerator.class);
    private static final DOMImplementation svgDOMImplementation = SVGDOMImplementation.getDOMImplementation();
    private static final PNGTranscoder pngTranscoder = new PNGTranscoder();
    private static DOMImplementationLS lsDOMImplementation;
    private static LSSerializer serializer;

    public void adjustDocumentWidth(Integer width) {
        this.adjustedDocumentWidth = width;
    }

    public Dimension getDocumentWidthHeight() {
        Element svg = this.doc.getDocumentElement();
        String widthStr = svg.getAttributeNS(null, "width");
        String heightStr = svg.getAttributeNS(null, "height");
        int width = Integer.parseInt(widthStr);
        int height = Integer.parseInt(heightStr);
        return new Dimension(width, height);
    }

    public void streamOutDocument(OutputStream outputStream) throws IOException {
        if (2 == this.outputFormat) {
            TranscoderInput input = new TranscoderInput((Document)this.doc);
            TranscoderOutput output = new TranscoderOutput(outputStream);
            try {
                pngTranscoder.transcode(input, output);
            }
            catch (TranscoderException e) {
                throw new IOException("Error while transcoding SVG into PNG", e);
            }
        } else {
            LSOutput output = lsDOMImplementation.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(1 == this.outputFormat || 4 == this.outputFormat ? outputStream : System.out);
            serializer.write((Node)this.doc, output);
        }
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
        }
    }

    public void generateLearningDesignDOM(LearningDesignDTO learningDesign, int outputFormat) throws IOException {
        this.outputFormat = outputFormat;
        this.initializeSvgDocument();
        ActivityTreeNode root = new ActivityTreeNode();
        Map<Long, ActivityTreeNode> allNodes = this.getActivityTree(learningDesign.getActivities(), root);
        ArrayList transitions = learningDesign.getTransitions();
        this.createActivityTransitionLines(allNodes, transitions);
        this.treeTraverse(root);
        this.setUpDocumentWidthHeight(allNodes.values());
    }

    public void generateBranchingDOM(LearningDesignDTO learningDesign, long branchingActivityId, int outputFormat) throws IOException {
        this.outputFormat = outputFormat;
        this.initializeSvgDocument();
        ActivityTreeNode root = new ActivityTreeNode();
        ArrayList<BranchDTO> branches = new ArrayList<BranchDTO>();
        Map<Long, ActivityTreeNode> allNodes = this.getActivityTree(learningDesign.getActivities(), root, branchingActivityId, branches);
        HashSet<TransitionDTO> interActivityTransitions = new HashSet<TransitionDTO>();
        Set<Long> allActivityIDs = allNodes.keySet();
        for (TransitionDTO transition : learningDesign.getTransitions()) {
            if (!allActivityIDs.contains(transition.getFromActivityID()) && !allActivityIDs.contains(transition.getToActivityID())) continue;
            interActivityTransitions.add(transition);
        }
        this.createBranchingTransitionLines(branches, root);
        this.createActivityTransitionLines(allNodes, interActivityTransitions);
        this.treeTraverse(root);
        this.setUpDocumentWidthHeight(allNodes.values());
    }

    private void initializeSvgDocument() {
        this.doc = (SVGDocument)svgDOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        Element svgRoot = this.doc.getDocumentElement();
        Element defs = this.doc.createElementNS("http://www.w3.org/2000/svg", "defs");
        svgRoot.appendChild(defs);
        Element marker = this.doc.createElementNS("http://www.w3.org/2000/svg", "marker");
        marker.setAttributeNS(null, "id", "Triangle");
        marker.setAttributeNS(null, "viewBox", "0 0 10 10");
        marker.setAttributeNS(null, "refX", "0");
        marker.setAttributeNS(null, "refY", "5");
        marker.setAttributeNS(null, "markerUnits", "strokeWidth");
        marker.setAttributeNS(null, "markerWidth", "6");
        marker.setAttributeNS(null, "markerHeight", "5");
        marker.setAttributeNS(null, "orient", "auto");
        defs.appendChild(marker);
        Element path = this.doc.createElementNS("http://www.w3.org/2000/svg", "path");
        path.setAttributeNS(null, "d", "M 0 0 L 10 5 L 0 10 z");
        marker.appendChild(path);
        Element g = this.doc.createElementNS("http://www.w3.org/2000/svg", "g");
        g.setAttributeNS(null, "id", "rootElement");
        svgRoot.appendChild(g);
    }

    private void treeTraverse(ActivityTreeNode node) {
        AuthoringActivityDTO activity = node.getActivity();
        if (activity != null) {
            this.createActivity(node);
            if (activity.getActivityTypeID().equals(10) || activity.getActivityTypeID().equals(11) || activity.getActivityTypeID().equals(12) || node.isOptionalSequenceActivityChild() || node.isOptionalActivityChild()) {
                return;
            }
        }
        for (ActivityTreeNode child : node.getChildren()) {
            this.treeTraverse(child);
        }
    }

    private void createActivity(ActivityTreeNode node) {
        AuthoringActivityDTO activity = node.getActivity();
        Element g = this.doc.createElementNS("http://www.w3.org/2000/svg", "g");
        String activityId = activity.getActivityID().toString();
        g.setAttributeNS(null, "id", activityId);
        String parentID = activity.getParentActivityID() == null ? "0" : activity.getParentActivityID().toString();
        g.setAttributeNS(null, "parentID", parentID);
        Element svgRoot = this.doc.getElementById("rootElement");
        svgRoot.appendChild(g);
        int x = node.getActivityCoordinates().x;
        int y = node.getActivityCoordinates().y;
        if (activity.getParentActivityID() != null) {
            AuthoringActivityDTO parentActivity = node.getParentActivity();
            x += parentActivity.getxCoord() == null ? 0 : parentActivity.getxCoord();
            y += parentActivity.getyCoord() == null ? 0 : parentActivity.getyCoord();
        }
        if (node.isOptionalSequenceActivityChild()) {
            this.createOptionalSequenceActivityChild(node, g, x, y);
        } else if (node.isOptionalActivityChild()) {
            this.createOptionalActivityChild(activity, node, g, x, y);
        } else if (activity.getActivityTypeID().equals(3) || activity.getActivityTypeID().equals(4) || activity.getActivityTypeID().equals(5) || activity.getActivityTypeID().equals(14)) {
            this.createGateActivity(activity, node, g, x, y);
        } else if (activity.getActivityTypeID().equals(6)) {
            this.createParallelActivity(activity, node, g, x, y);
        } else if (activity.getActivityTypeID().equals(10) || activity.getActivityTypeID().equals(11) || activity.getActivityTypeID().equals(12)) {
            this.createBranchingActivity(activity, node, g, x, y);
        } else if (activity.getActivityTypeID().equals(13)) {
            this.createOptionalSequenceActivity(activity, node, g, x, y);
        } else if (activity.getActivityTypeID().equals(8)) {
            this.createRectangle(node, x, y, g);
        } else if (activity.getActivityTypeID().equals(7)) {
            this.createOptionalActivity(activity, node, g, x, y);
        } else if (activity.getActivityTypeID().equals(15)) {
            this.createSupportActivity(activity, node, g, x, y);
        } else {
            this.createToolActivity(activity, node, g, x, y);
        }
    }

    private void createOptionalActivityChild(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        this.createRectangle(node, x, y, g);
        String text = activity.getActivityTitle();
        if (text != null) {
            Integer width = node.getActivityDimension().width;
            Integer height = node.getActivityDimension().height;
            int xText = x + width / 2;
            int yText = y + height / 2 + 18;
            this.createText("TextElement-" + activity.getActivityID(), xText, yText, "middle", "11.4", null, null, text, g);
        }
        this.createImage(node, x, y, g);
    }

    private void createOptionalSequenceActivityChild(ActivityTreeNode node, Element g, int x, int y) {
        ActivityTreeNode parentNode = (ActivityTreeNode)node.getParent();
        AuthoringActivityDTO grandParentActivity = parentNode.getParentActivity();
        this.createRectangle(node, x += grandParentActivity.getxCoord() == null ? 0 : grandParentActivity.getxCoord(), y += grandParentActivity.getyCoord() == null ? 0 : grandParentActivity.getyCoord(), g);
        this.createImage(node, x, y, g);
    }

    private void createGateActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        x += 8;
        y -= 2;
        String finalProportions = "";
        for (double[] proportion : SVGConstants.GATE_PROPORTIONS) {
            finalProportions = finalProportions + ((double)x + proportion[0]) + "," + ((double)y + proportion[1]) + " ";
        }
        Element polygon = this.doc.createElementNS("http://www.w3.org/2000/svg", "polygon");
        polygon.setAttributeNS(null, "style", node.getActivityCss());
        polygon.setAttributeNS(null, "points", finalProportions);
        g.appendChild(polygon);
        double x1 = (double)x + SVGConstants.GATE_PROPORTIONS[6][0];
        double x2 = (double)x + SVGConstants.GATE_PROPORTIONS[2][0];
        double midpointX = (x1 + x2) / 2.0;
        double y1 = (double)y + SVGConstants.GATE_PROPORTIONS[6][1];
        double y2 = (double)y + SVGConstants.GATE_PROPORTIONS[2][1];
        double midpointY = (y1 + y2) / 2.0 + 3.0;
        this.createText("Gate_" + activity.getActivityID(), midpointX, midpointY, "middle", "10", null, "fill:#FFFFFF;stroke:#FFFFFF;stroke-width:.5;", "STOP", g);
    }

    private void createParallelActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        if (activity.getApplyGrouping().booleanValue()) {
            this.createGroupingEffect(node, x, y, g);
        }
        this.createRectangle(node, x, y, g);
        this.createActvityHeader(node, x, y, g);
        String text = activity.getActivityTitle();
        if (StringUtils.isNotEmpty((String)text)) {
            this.createText("TextElement-" + activity.getActivityID(), x + 9, y + 19, "start", "12", "Arial", "fill:#828990", text, g);
        }
    }

    private void createSupportActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        this.createRectangle(node, x, y, g);
        this.createActvityHeader(node, x, y, g);
        String text = activity.getActivityTitle();
        if (StringUtils.isNotEmpty((String)text)) {
            this.createText("TextElement-" + activity.getActivityID(), x + 9, y + 19, "start", "12", "Arial", "fill:#828990", text, g);
        }
        int supportActivityChildrenSize = node.getChildCount();
        this.createText("Children-" + activity.getActivityID(), x + 9, y + 38 + 1, "start", "11", "Arial", "fill:#828990", supportActivityChildrenSize + " - Activities", g);
    }

    private void createToolActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        if (activity.getApplyGrouping().booleanValue()) {
            this.createGroupingEffect(node, x, y, g);
        }
        this.createRectangle(node, x, y, g);
        String text = activity.getActivityTitle();
        if (StringUtils.isNotEmpty((String)text)) {
            Integer width = node.getActivityDimension().width;
            Integer height = node.getActivityDimension().height;
            int xText = x + width / 2;
            int yText = y + height / 2 + 18;
            this.createText("TextElement-" + activity.getActivityID(), xText, yText, "middle", "11.4", null, null, text, g);
        }
        this.createImage(node, x, y, g);
    }

    private void createOptionalActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        int childActivitiesSize = node.getChildCount();
        this.createRectangle(node, x, y, g);
        this.createActvityHeader(node, x, y, g);
        String text = activity.getActivityTitle();
        if (StringUtils.isNotEmpty((String)text)) {
            this.createText("TextElement-" + activity.getActivityID(), x + 9, y + 19, "start", "12", "Arial", "fill:#828990", text, g);
        }
        this.createText("Children-" + activity.getActivityID(), x + 9, y + 38 + 1, "start", "11", "Arial", "fill:#828990", childActivitiesSize + " - Activities", g);
    }

    private void createOptionalSequenceActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        this.createRectangle(node, x, y, g);
        this.createActvityHeader(node, x, y, g);
        String text = activity.getActivityTitle();
        if (StringUtils.isNotEmpty((String)text)) {
            this.createText("TextElement-" + activity.getActivityID(), x + 9, y + 19, "start", "12", "Arial", "fill:#828990", text, g);
        }
        this.createText("Children-" + activity.getActivityID(), x + 9, y + 38 + 1, "start", "11", "Arial", "fill:#828990", node.getChildCount() + " - Sequences", g);
    }

    private void createBranchingActivity(AuthoringActivityDTO activity, ActivityTreeNode node, Element g, int x, int y) {
        if (activity.getApplyGrouping().booleanValue()) {
            this.createGroupingEffect(node, x, y, g);
        }
        this.createRectangle(node, x, y, g);
        int startingPointX = x + 26;
        int startingPointY = y + 40;
        if (node.getChildCount() == 4) {
            startingPointY -= 12;
        } else if (node.getChildCount() > 4) {
            startingPointY -= 24;
        }
        Element startingPoint = this.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        startingPoint.setAttributeNS(null, "x", Integer.toString(startingPointX));
        startingPoint.setAttributeNS(null, "y", Integer.toString(startingPointY));
        startingPoint.setAttributeNS(null, "width", Double.toString(9.0));
        startingPoint.setAttributeNS(null, "height", Double.toString(9.0));
        startingPoint.setAttributeNS(null, "style", "fill:#000000");
        g.appendChild(startingPoint);
        TreeSet<ActivityTreeNode> sequenceNodeSet = new TreeSet<ActivityTreeNode>(new ActivityTreeNodeComparator());
        sequenceNodeSet.addAll(node.getChildren());
        LinkedList<ActivityTreeNode> sequenceNodeList = new LinkedList<ActivityTreeNode>();
        for (ActivityTreeNode sequenceNode : sequenceNodeSet) {
            if (sequenceNode.getChildCount() == 0) {
                sequenceNodeList.addFirst(sequenceNode);
                continue;
            }
            sequenceNodeList.add(sequenceNode);
        }
        int sequenceIndex = 0;
        for (ActivityTreeNode sequenceNode : sequenceNodeList) {
            int activityIndex;
            if (Math.abs(sequenceIndex) >= 3) break;
            double previousActivityPointX = (double)startingPointX + 4.25;
            double previousActivityPointY = (double)startingPointY + 4.25;
            Iterator<ActivityTreeNode> activityNodeIterator = sequenceNode.getChildren().iterator();
            for (activityIndex = 1; activityNodeIterator.hasNext() && activityIndex <= 6; ++activityIndex) {
                double activityPointX = (double)(startingPointX + activityIndex * 15) + 4.25;
                double activityPointY = (double)(startingPointY + sequenceIndex * 15) + 4.25;
                Element line = this.doc.createElementNS("http://www.w3.org/2000/svg", "line");
                line.setAttributeNS(null, "x1", Double.toString(previousActivityPointX));
                line.setAttributeNS(null, "y1", Double.toString(previousActivityPointY));
                line.setAttributeNS(null, "x2", Double.toString(activityPointX));
                line.setAttributeNS(null, "y2", Double.toString(activityPointY));
                line.setAttributeNS(null, "style", "stroke:black;stroke-width:1;");
                g.appendChild(line);
                previousActivityPointX = activityPointX;
                previousActivityPointY = activityPointY;
                activityNodeIterator.next();
            }
            if (!sequenceNode.getActivity().getStopAfterActivity().booleanValue()) {
                Element line = this.doc.createElementNS("http://www.w3.org/2000/svg", "line");
                line.setAttributeNS(null, "x1", Double.toString(previousActivityPointX));
                line.setAttributeNS(null, "y1", Double.toString(previousActivityPointY));
                line.setAttributeNS(null, "x2", Double.toString((double)(x + 132) + 4.25));
                line.setAttributeNS(null, "y2", Double.toString((double)startingPointY + 4.25));
                line.setAttributeNS(null, "style", "stroke:black;stroke-width:1;");
                g.appendChild(line);
            }
            activityNodeIterator = sequenceNode.getChildren().iterator();
            for (activityIndex = 1; activityNodeIterator.hasNext() && activityIndex <= 6; ++activityIndex) {
                ActivityTreeNode activityNode = activityNodeIterator.next();
                String activityStyle = sequenceNode.getActivity().getStopAfterActivity() != false && !activityNodeIterator.hasNext() ? "stroke:red" : "stroke:black";
                activityStyle = activityStyle + ";stroke-width:0.8;opacity:1" + activityNode.getActivityColor();
                double activityPointX = startingPointX + activityIndex * 15;
                double activityPointY = startingPointY + sequenceIndex * 15;
                Element activityPoint = this.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
                activityPoint.setAttributeNS(null, "x", Double.toString(activityPointX));
                activityPoint.setAttributeNS(null, "y", Double.toString(activityPointY));
                activityPoint.setAttributeNS(null, "width", "8.5");
                activityPoint.setAttributeNS(null, "height", "8.5");
                activityPoint.setAttributeNS(null, "style", activityStyle);
                g.appendChild(activityPoint);
            }
            if (sequenceIndex >= 0) {
                ++sequenceIndex;
            }
            sequenceIndex *= -1;
        }
        Element endingPoint = this.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        endingPoint.setAttributeNS(null, "x", Integer.toString(x + 132));
        endingPoint.setAttributeNS(null, "y", Integer.toString(startingPointY));
        endingPoint.setAttributeNS(null, "width", Double.toString(9.0));
        endingPoint.setAttributeNS(null, "height", Double.toString(9.0));
        endingPoint.setAttributeNS(null, "style", "fill:#000000");
        g.appendChild(endingPoint);
        String text = activity.getActivityTitle();
        if (StringUtils.isNotEmpty((String)text)) {
            this.createText("TextElement-" + activity.getActivityID(), x + 82, y + 90, "middle", "11.4", null, null, text, g);
        }
    }

    private void setUpDocumentWidthHeight(Collection<ActivityTreeNode> nodes) {
        int maxX = 0;
        int maxY = 0;
        for (ActivityTreeNode node : nodes) {
            int bottomActivityPoint;
            Dimension dimension = node.getActivityDimension();
            int rightestActivityPoint = node.getActivityCoordinates().x + dimension.width;
            if (rightestActivityPoint > maxX) {
                maxX = rightestActivityPoint;
            }
            if ((bottomActivityPoint = node.getActivityCoordinates().y + dimension.height) <= maxY) continue;
            maxY = bottomActivityPoint;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (ActivityTreeNode node : nodes) {
            int topActivityPoint;
            AuthoringActivityDTO activity = node.getActivity();
            if (activity.getParentActivityID() != null) continue;
            int leftActivityPoint = node.getActivityCoordinates().x;
            if (leftActivityPoint < minX) {
                minX = leftActivityPoint;
            }
            if ((topActivityPoint = node.getActivityCoordinates().y) >= minY) continue;
            minY = topActivityPoint;
        }
        for (Point branchingEdgePoint : new Point[]{this.branchingStartPoint, this.branchingEndPoint}) {
            int y;
            if (branchingEdgePoint == null) continue;
            int x = new Double(branchingEdgePoint.getX()).intValue();
            if (x + 27 > maxX) {
                maxX = x + 27;
            }
            if (x < minX) {
                minX = x;
            }
            if ((y = new Double(branchingEdgePoint.getY()).intValue()) + 27 > maxY) {
                maxY = y + 27;
            }
            if (y >= minY) continue;
            minY = y;
        }
        Element svg = this.doc.getDocumentElement();
        int width = maxX - --minX + 5;
        int height = maxY - --minY + 5;
        svg.setAttributeNS(null, "viewBox", minX + " " + minY + " " + Integer.toString(width) + " " + Integer.toString(height));
        if (this.adjustedDocumentWidth != null && this.adjustedDocumentWidth < width) {
            double scale = (double)this.adjustedDocumentWidth.intValue() / (double)width;
            width = this.adjustedDocumentWidth;
            height = (int)((double)height * scale);
        }
        svg.setAttributeNS(null, "width", Integer.toString(width));
        svg.setAttributeNS(null, "height", Integer.toString(height));
    }

    private void createRectangle(ActivityTreeNode node, double x, double y, Element g) {
        AuthoringActivityDTO activity = node.getActivity();
        Dimension dimension = node.getActivityDimension();
        String style = node.getActivityCss();
        if (style == null) {
            style = "";
        }
        Element rectangle = this.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        rectangle.setAttributeNS(null, "id", "act" + activity.getActivityID());
        rectangle.setAttributeNS(null, "x", Double.toString(x));
        rectangle.setAttributeNS(null, "y", Double.toString(y));
        rectangle.setAttributeNS(null, "width", Double.toString(dimension.width));
        rectangle.setAttributeNS(null, "height", Double.toString(dimension.height));
        rectangle.setAttributeNS(null, "style", style);
        g.appendChild(rectangle);
    }

    private void createActvityHeader(ActivityTreeNode node, double x, double y, Element g) {
        AuthoringActivityDTO activity = node.getActivity();
        Dimension dimension = node.getActivityDimension();
        double height = activity.getActivityTypeID().equals(6) ? 23.0 : 39.0;
        Element rectangle = this.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        rectangle.setAttributeNS(null, "x", Double.toString(x + 4.0));
        rectangle.setAttributeNS(null, "y", Double.toString(y + 5.0));
        rectangle.setAttributeNS(null, "width", Double.toString(dimension.width - 8));
        rectangle.setAttributeNS(null, "height", Double.toString(height));
        rectangle.setAttributeNS(null, "style", "fill:#A9C8FD;stroke:#E1F0FD;stroke-width:2.2;opacity:1");
        g.appendChild(rectangle);
    }

    private void createGroupingEffect(ActivityTreeNode node, double x, double y, Element g) {
        AuthoringActivityDTO activity = node.getActivity();
        Dimension dimension = node.getActivityDimension();
        String style = node.getActivityCss();
        Element groupingRectangle = this.doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        groupingRectangle.setAttributeNS(null, "id", "grouping-" + activity.getActivityID());
        groupingRectangle.setAttributeNS(null, "x", Double.toString(x + 4.0));
        groupingRectangle.setAttributeNS(null, "y", Double.toString(y + 4.0));
        groupingRectangle.setAttributeNS(null, "width", Double.toString(dimension.width));
        groupingRectangle.setAttributeNS(null, "height", Double.toString(dimension.height));
        groupingRectangle.setAttributeNS(null, "style", style + ";stroke:#3b3b3b;stroke-width:3");
        g.appendChild(groupingRectangle);
    }

    private void createText(String id, double x, double y, String textAnchor, String fontSize, String fontFamily, String style, String text, Element g) {
        if (textAnchor == null) {
            textAnchor = "start";
        }
        if (fontSize == null) {
            fontSize = "11.4";
        }
        if (fontFamily == null) {
            fontFamily = "Verdana";
        }
        if (text.length() > 21) {
            text = text.substring(0, 20);
        }
        Element textNode = this.doc.createElementNS("http://www.w3.org/2000/svg", "text");
        Text textContent = this.doc.createTextNode(text);
        textNode.appendChild(textContent);
        textNode.setAttributeNS(null, "id", id);
        textNode.setAttributeNS(null, "x", "" + x);
        textNode.setAttributeNS(null, "y", "" + y);
        textNode.setAttributeNS(null, "dy", "0");
        textNode.setAttributeNS(null, "text-anchor", textAnchor);
        textNode.setAttributeNS(null, "font-size", fontSize);
        textNode.setAttributeNS(null, "font-family", fontFamily);
        if (style != null) {
            textNode.setAttributeNS(null, "style", style);
        }
        g.appendChild(textNode);
    }

    private void createImage(ActivityTreeNode node, int x, int y, Element g) {
        String imageFileName;
        String imagePath;
        AuthoringActivityDTO activity = node.getActivity();
        Dimension dimension = node.getActivityDimension();
        int imageX = x + dimension.width / 2 - 15;
        int imageY = y + dimension.height / 2 - 22;
        if (node.isOptionalSequenceActivityChild()) {
            imageX += 2;
            imageY += 7;
        }
        if (!StringUtils.isBlank((String)(imagePath = activity.getLibraryActivityUIImage()))) {
            imageFileName = FileUtil.getFileName(imagePath);
            imageFileName = imageFileName.replaceFirst(".swf$", ".png");
        } else {
            imageFileName = activity.getActivityTypeID().equals(3) || activity.getActivityTypeID().equals(4) || activity.getActivityTypeID().equals(5) || activity.getActivityTypeID().equals(14) ? "icon_gate.png" : (activity.getActivityTypeID().equals(10) || activity.getActivityTypeID().equals(11) || activity.getActivityTypeID().equals(12) ? "icon_branching.png" : (activity.getActivityTypeID().equals(13) || activity.getActivityTypeID().equals(7) ? "icon_urlcontentmessageboard.png" : "icon_grouping.png"));
        }
        imageFileName = (4 == this.outputFormat ? "http://lamscommunity.org/lamscentral/images/acts/" : this.localSvgIconsPath) + imageFileName;
        String imageId = "image-" + activity.getActivityID();
        this.createImage(g, imageFileName, imageId, imageX, imageY);
    }

    private void createImage(Element g, String imageFileName, String id, int x, int y) {
        Element imageNode = this.doc.createElementNS("http://www.w3.org/2000/svg", "image");
        imageNode.setAttributeNS(null, "id", id);
        imageNode.setAttributeNS(null, "x", Integer.toString(x));
        imageNode.setAttributeNS(null, "y", Integer.toString(y));
        imageNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", imageFileName);
        imageNode.setAttributeNS(null, "width", Integer.toString(30));
        imageNode.setAttributeNS(null, "height", Integer.toString(30));
        if (g == null) {
            Element svgRoot = this.doc.getDocumentElement();
            svgRoot.appendChild(imageNode);
        } else {
            g.appendChild(imageNode);
        }
    }

    private void createTransitionLine(String id, Point2D fromIntersection, Point2D toIntersection, String branchTitle, String chosenColor) {
        String color = chosenColor == null ? "#8C8FA6" : chosenColor;
        Element line = this.doc.createElementNS("http://www.w3.org/2000/svg", "line");
        line.setAttributeNS(null, "id", id);
        line.setAttributeNS(null, "x1", Double.toString(fromIntersection.getX()));
        line.setAttributeNS(null, "y1", Double.toString(fromIntersection.getY()));
        line.setAttributeNS(null, "x2", Double.toString(toIntersection.getX()));
        line.setAttributeNS(null, "y2", Double.toString(toIntersection.getY()));
        line.setAttributeNS(null, "style", "stroke:" + color + ";stroke-width:2;opacity:1");
        line.setAttributeNS(null, "parentID", "0");
        double a = toIntersection.getX() - fromIntersection.getX();
        double b = toIntersection.getY() - fromIntersection.getY();
        double arrowShiftX = a * a + b * b == 0.0 ? 0.0 : 5.0 * a / Math.sqrt(a * a + b * b);
        double arrowShiftY = a * a + b * b == 0.0 ? 0.0 : 5.0 * b / Math.sqrt(a * a + b * b);
        double arrowEndX = (fromIntersection.getX() + toIntersection.getX()) / 2.0 - arrowShiftX;
        double arrowEndY = (fromIntersection.getY() + toIntersection.getY()) / 2.0 - arrowShiftY;
        Element arrowhead = this.doc.createElementNS("http://www.w3.org/2000/svg", "line");
        arrowhead.setAttributeNS(null, "id", "arrowhead_" + id);
        arrowhead.setAttributeNS(null, "x1", Double.toString(fromIntersection.getX()));
        arrowhead.setAttributeNS(null, "y1", Double.toString(fromIntersection.getY()));
        arrowhead.setAttributeNS(null, "x2", Double.toString(arrowEndX));
        arrowhead.setAttributeNS(null, "y2", Double.toString(arrowEndY));
        arrowhead.setAttributeNS(null, "style", "fill:" + color + ";stroke:" + color + ";stroke-width:2;opacity:1");
        arrowhead.setAttributeNS(null, "marker-end", "url(#Triangle)");
        arrowhead.setAttributeNS(null, "parentID", "0");
        Element svgRoot = this.doc.getDocumentElement();
        svgRoot.appendChild(line);
        svgRoot.appendChild(arrowhead);
        if (!StringUtils.isBlank((String)branchTitle)) {
            double titleY = arrowEndY + (double)(b < 0.0 ? -10 : 20);
            this.createText("branch_title_" + id, arrowEndX, titleY, "end", null, null, null, branchTitle, svgRoot);
        }
    }

    private Map<Long, ActivityTreeNode> getActivityTree(List<AuthoringActivityDTO> activities, ActivityTreeNode root) {
        HashMap<Long, ActivityTreeNode> allNodes = new HashMap<Long, ActivityTreeNode>();
        for (AuthoringActivityDTO activity : activities) {
            ActivityTreeNode node = new ActivityTreeNode(activity);
            allNodes.put(activity.getActivityID(), node);
        }
        for (ActivityTreeNode node : allNodes.values()) {
            AuthoringActivityDTO activity = node.getActivity();
            if (activity.getParentActivityID() == null) {
                root.add(node);
                continue;
            }
            Long parentId = activity.getParentActivityID();
            ActivityTreeNode parent = (ActivityTreeNode)allNodes.get(parentId);
            parent.add(node);
        }
        return allNodes;
    }

    private Map<Long, ActivityTreeNode> getActivityTree(List<AuthoringActivityDTO> activities, ActivityTreeNode root, long branchingActivityId, Collection<BranchDTO> branchesContainter) {
        ActivityTreeNode parent;
        ActivityTreeNode node;
        Long activityId;
        Long parentActivityId;
        HashSet<AuthoringActivityDTO> allChildActivities = new HashSet<AuthoringActivityDTO>();
        HashMap<Long, TreeSet<AuthoringActivityDTO>> sequenceMapping = new HashMap<Long, TreeSet<AuthoringActivityDTO>>();
        ActivityDTOOrderComparator orderComparator = new ActivityDTOOrderComparator();
        for (AuthoringActivityDTO activity : activities) {
            Long activityId2 = activity.getActivityID();
            parentActivityId = activity.getParentActivityID();
            if (activityId2.equals(branchingActivityId)) {
                this.branchingStartPoint = new Point(activity.getStartXCoord(), activity.getStartYCoord());
                this.branchingEndPoint = new Point(activity.getEndXCoord(), activity.getEndYCoord());
                continue;
            }
            if (parentActivityId == null) continue;
            allChildActivities.add(activity);
            if (!parentActivityId.equals(branchingActivityId)) continue;
            sequenceMapping.put(activityId2, new TreeSet<AuthoringActivityDTO>(orderComparator));
            BranchDTO branchDTO = new BranchDTO();
            branchDTO.sequenceActivityId = activityId2;
            branchDTO.branchTitle = activity.getActivityTitle();
            branchDTO.stopAfterActivity = activity.getStopAfterActivity();
            branchesContainter.add(branchDTO);
        }
        HashMap<Long, ActivityTreeNode> branchingNodes = new HashMap<Long, ActivityTreeNode>();
        for (AuthoringActivityDTO childActivity : allChildActivities) {
            parentActivityId = childActivity.getParentActivityID();
            if (!sequenceMapping.keySet().contains(parentActivityId)) continue;
            childActivity.setParentActivityID(null);
            ActivityTreeNode node2 = new ActivityTreeNode(childActivity);
            root.add(node2);
            branchingNodes.put(childActivity.getActivityID(), node2);
            ((Set)sequenceMapping.get(parentActivityId)).add(childActivity);
        }
        block2: for (Long sequenceActivityId : sequenceMapping.keySet()) {
            for (BranchDTO branchDTO : branchesContainter) {
                if (!sequenceActivityId.equals(branchDTO.sequenceActivityId)) continue;
                Set sequence = (Set)sequenceMapping.get(sequenceActivityId);
                for (AuthoringActivityDTO childActivity : sequence) {
                    ActivityTreeNode childAcitivityNode = (ActivityTreeNode)branchingNodes.get(childActivity.getActivityID());
                    branchDTO.add(childAcitivityNode);
                }
                continue block2;
            }
        }
        for (AuthoringActivityDTO activity : allChildActivities) {
            parentActivityId = activity.getParentActivityID();
            activityId = activity.getActivityID();
            if (!branchingNodes.keySet().contains(parentActivityId) || branchingNodes.keySet().contains(activityId)) continue;
            node = new ActivityTreeNode(activity);
            parent = (ActivityTreeNode)branchingNodes.get(parentActivityId);
            parent.add(node);
            branchingNodes.put(activityId, node);
        }
        for (AuthoringActivityDTO activity : allChildActivities) {
            parentActivityId = activity.getParentActivityID();
            activityId = activity.getActivityID();
            if (!branchingNodes.keySet().contains(parentActivityId) || branchingNodes.keySet().contains(activityId)) continue;
            node = new ActivityTreeNode(activity);
            parent = (ActivityTreeNode)branchingNodes.get(parentActivityId);
            parent.add(node);
            branchingNodes.put(activityId, node);
        }
        return branchingNodes;
    }

    private void createActivityTransitionLines(Map<Long, ActivityTreeNode> nodes, Collection<TransitionDTO> transitions) {
        for (TransitionDTO transition : transitions) {
            ActivityTreeNode fromActivity = nodes.get(transition.getFromActivityID());
            ActivityTreeNode toActivity = nodes.get(transition.getToActivityID());
            Point2D fromIntersection = SVGTrigonometryUtils.getActivityAndLineSegmentIntersection(fromActivity, toActivity);
            Point2D toIntersection = SVGTrigonometryUtils.getActivityAndLineSegmentIntersection(toActivity, fromActivity);
            if (fromActivity.isOptionalSequenceActivityChild() || fromIntersection == null || toIntersection == null) continue;
            String id = transition.getFromActivityID() + "_to_" + transition.getToActivityID();
            this.createTransitionLine(id, fromIntersection, toIntersection, null, null);
        }
    }

    private void createBranchingTransitionLines(Collection<BranchDTO> branches, ActivityTreeNode root) {
        String imageFolder = 4 == this.outputFormat ? "http://lamscommunity.org/lamscentral/images/acts/" : Configuration.get(ConfigurationKeys.SERVER_URL) + "images/icons/";
        String imageFileName = imageFolder + "door_out.png";
        String imageId = "image-start";
        this.createImage(null, imageFileName, imageId, new Double(this.branchingStartPoint.getX()).intValue(), new Double(this.branchingStartPoint.getY()).intValue());
        imageFileName = imageFolder + "door_in.png";
        imageId = "image-end";
        this.createImage(null, imageFileName, imageId, new Double(this.branchingEndPoint.getX()).intValue(), new Double(this.branchingEndPoint.getY()).intValue());
        Dimension edgePointsDimensions = new Dimension(27, 27);
        Rectangle startRectangle = new Rectangle(this.branchingStartPoint, edgePointsDimensions);
        Rectangle endRectangle = new Rectangle(this.branchingEndPoint, edgePointsDimensions);
        for (BranchDTO branch : branches) {
            if (branch.isEmpty()) {
                Point2D fromIntersection = SVGTrigonometryUtils.getRectangleAndLineSegmentIntersection(startRectangle, endRectangle);
                Point2D toIntersection = SVGTrigonometryUtils.getRectangleAndLineSegmentIntersection(endRectangle, startRectangle);
                if (fromIntersection == null || toIntersection == null) continue;
                String id = "start_to_end";
                this.createTransitionLine(id, fromIntersection, toIntersection, branch.branchTitle, "#AFCE63");
                continue;
            }
            ActivityTreeNode branchFirstActivity = (ActivityTreeNode)branch.getFirst();
            Rectangle branchFirstActivityRectangle = new Rectangle(branchFirstActivity.getActivityCoordinates().x, branchFirstActivity.getActivityCoordinates().y, branchFirstActivity.getActivityDimension().width, branchFirstActivity.getActivityDimension().height);
            Point2D fromIntersection = SVGTrigonometryUtils.getRectangleAndLineSegmentIntersection(startRectangle, branchFirstActivityRectangle);
            Point2D toIntersection = SVGTrigonometryUtils.getRectangleAndLineSegmentIntersection(branchFirstActivityRectangle, startRectangle);
            if (fromIntersection == null || toIntersection == null) continue;
            String id = "start_to_" + branchFirstActivity.getActivity().getActivityID();
            this.createTransitionLine(id, fromIntersection, toIntersection, branch.branchTitle, "#AFCE63");
            ActivityTreeNode branchLastActivity = (ActivityTreeNode)branch.getLast();
            if (branch.stopAfterActivity.booleanValue()) continue;
            Rectangle branchLastActivityRectangle = new Rectangle(branchLastActivity.getActivityCoordinates().x, branchLastActivity.getActivityCoordinates().y, branchLastActivity.getActivityDimension().width, branchLastActivity.getActivityDimension().height);
            fromIntersection = SVGTrigonometryUtils.getRectangleAndLineSegmentIntersection(branchLastActivityRectangle, endRectangle);
            toIntersection = SVGTrigonometryUtils.getRectangleAndLineSegmentIntersection(endRectangle, branchLastActivityRectangle);
            if (fromIntersection == null || toIntersection == null) continue;
            id = branchLastActivity.getActivity().getActivityID() + "_to_end";
            this.createTransitionLine(id, fromIntersection, toIntersection, null, "#AFCE63");
        }
    }

    static {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            lsDOMImplementation = (DOMImplementationLS)((Object)registry.getDOMImplementation("XML 1.0 LS"));
            serializer = lsDOMImplementation.createLSSerializer();
            serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static class BranchDTO
    extends LinkedList<ActivityTreeNode> {
        private Long sequenceActivityId;
        private Boolean stopAfterActivity;
        private String branchTitle;

        private BranchDTO() {
        }
    }
}

