/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.CrCredential;
import org.lamsfoundation.lams.contentrepository.CrNode;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.CrWorkspaceCredential;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NoSuchNodeTypeException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.ValidationException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.dao.ICredentialDAO;
import org.lamsfoundation.lams.contentrepository.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryAdmin;
import org.lamsfoundation.lams.contentrepository.service.SimpleTicket;
import org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class SimpleRepository
implements IRepositoryAdmin,
BeanFactoryAware {
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$service$SimpleRepository == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleRepository = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.service.SimpleRepository")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleRepository));
    private ICredentialDAO credentialDAO = null;
    private IWorkspaceDAO workspaceDAO = null;
    private BeanFactory beanFactory = null;
    private Set ticketIdSet = new HashSet();
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$service$SimpleRepository;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$CrWorkspace;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode;

    public SimpleRepository() {
        this.log.info((Object)"Repository singleton being created.");
    }

    private CrWorkspace getWorkspace(String workspaceName) throws WorkspaceNotFoundException {
        CrWorkspace workspace = this.workspaceDAO.findByName(workspaceName);
        if (workspace == null) {
            throw new WorkspaceNotFoundException("Workspace " + workspaceName + " does not exist.");
        }
        return workspace;
    }

    private CrWorkspace getWorkspace(Long workspaceId) throws WorkspaceNotFoundException {
        CrWorkspace workspace = (CrWorkspace)this.workspaceDAO.find(class$org$lamsfoundation$lams$contentrepository$CrWorkspace == null ? (class$org$lamsfoundation$lams$contentrepository$CrWorkspace = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.CrWorkspace")) : class$org$lamsfoundation$lams$contentrepository$CrWorkspace, workspaceId);
        if (workspace == null) {
            throw new WorkspaceNotFoundException("Workspace id=" + workspaceId + " does not exist.");
        }
        return workspace;
    }

    public ITicket login(ICredentials credentials, String workspaceName) throws AccessDeniedException, LoginException, WorkspaceNotFoundException {
        if (this.workspaceDAO == null || this.credentialDAO == null) {
            throw new RepositoryRuntimeException("Workspace or Credential DAO object missing. Unable to process login.");
        }
        CrWorkspace workspace = this.getWorkspace(workspaceName);
        if (!this.credentialDAO.checkCredential(credentials, workspace)) {
            throw new LoginException("Login failed. Password incorrect or not authorised to access this workspace.");
        }
        SimpleTicket ticket = new SimpleTicket(workspace.getWorkspaceId());
        this.ticketIdSet.add(ticket.getTicketId());
        return ticket;
    }

    public void addWorkspace(ICredentials credentials, String workspaceName) throws AccessDeniedException, LoginException, ItemExistsException, RepositoryCheckedException {
        if (this.workspaceDAO == null || this.credentialDAO == null || this.beanFactory == null) {
            throw new RepositoryRuntimeException("Workspace, Credential DAO or Bean Factory object missing. Unable to process login.");
        }
        CrWorkspace workspace = this.workspaceDAO.findByName(workspaceName);
        if (workspace != null) {
            throw new ItemExistsException("Workspace " + workspaceName + " already exists, cannot add workspace.");
        }
        if (!this.credentialDAO.checkCredential(credentials)) {
            throw new LoginException("User not authorised to access the repository.");
        }
        CrWorkspace crWorkspace = new CrWorkspace();
        crWorkspace.setName(workspaceName);
        this.workspaceDAO.insert(crWorkspace);
        this.assignCredentials(credentials, crWorkspace);
    }

    public void createCredentials(ICredentials newCredential) throws AccessDeniedException, RepositoryCheckedException, ItemExistsException {
        if (newCredential == null || newCredential.getName() == null || newCredential.getPassword() == null) {
            throw new RepositoryCheckedException("Credential is null or name/password is missing - cannot create credential.");
        }
        this.verifyNewPassword(newCredential.getPassword());
        CrCredential cred = this.credentialDAO.findByName(newCredential.getName());
        if (cred != null) {
            throw new ItemExistsException("Credential name " + newCredential.getName() + " already exists - cannot create credential.");
        }
        cred = new CrCredential();
        cred.setName(newCredential.getName());
        cred.setPassword(new String(newCredential.getPassword()));
        this.credentialDAO.insert(cred);
    }

    public void updateCredentials(ICredentials oldCredential, ICredentials newCredential) throws AccessDeniedException, LoginException, RepositoryCheckedException, RepositoryRuntimeException {
        if (this.workspaceDAO == null || this.credentialDAO == null) {
            throw new RepositoryRuntimeException("Workspace or Credential DAO object missing. Cannot update credentials.");
        }
        if (oldCredential == null || newCredential == null) {
            throw new RepositoryCheckedException("Credentials missing. Cannot update credentials.");
        }
        if (!this.credentialDAO.checkCredential(oldCredential)) {
            throw new LoginException("Old password wrong. Cannot update credentials.");
        }
        char[] newPassword = newCredential.getPassword();
        if (newPassword != null) {
            this.verifyNewPassword(newPassword);
            CrCredential cred = this.credentialDAO.findByName(oldCredential.getName());
            cred.setPassword(new String(newPassword));
            this.credentialDAO.update(cred);
        }
    }

    private void verifyNewPassword(char[] password) throws RepositoryCheckedException {
        if (password != null && password.length < 6) {
            throw new RepositoryCheckedException("Password invalid - must be 6 or more characters. Cannot create credential.");
        }
    }

    public void assignCredentials(ICredentials credentials, String workspaceName) throws AccessDeniedException, RepositoryCheckedException, WorkspaceNotFoundException, LoginException {
        if (this.workspaceDAO == null) {
            throw new RepositoryRuntimeException("Workspace DAO object missing. Cannot assign credentials.");
        }
        if (credentials == null || workspaceName == null) {
            throw new RepositoryCheckedException("Credentials or workspace is missing. Cannot assign credentials.");
        }
        if (!this.credentialDAO.checkCredential(credentials)) {
            throw new LoginException("Credentials are not authorised to have access to the repository/workspace.");
        }
        CrWorkspace workspace = this.getWorkspace(workspaceName);
        if (workspace == null) {
            throw new WorkspaceNotFoundException("Workspace " + workspaceName + " does not exist.");
        }
        this.assignCredentials(credentials, workspace);
    }

    private void assignCredentials(ICredentials credentials, CrWorkspace workspace) throws RepositoryCheckedException {
        if (this.workspaceDAO == null || this.credentialDAO == null) {
            throw new RepositoryRuntimeException("Workspace or Credential DAO object missing. Cannot assign credentials.");
        }
        if (credentials == null || workspace == null) {
            throw new RepositoryCheckedException("Credentials or workspace is missing. Cannot assign credentials.");
        }
        CrCredential crCredential = this.credentialDAO.findByName(credentials.getName());
        if (crCredential == null) {
            throw new RepositoryCheckedException("Credential object cannot be found in database. Cannot assign credentials.");
        }
        CrWorkspaceCredential wc = new CrWorkspaceCredential();
        wc.setCrCredential(crCredential);
        wc.setCrWorkspace(workspace);
        HashSet<CrWorkspaceCredential> wcSet = workspace.getCrWorkspaceCredentials();
        if (wcSet == null) {
            this.log.debug((Object)("Creating new wc set for workspace " + workspace.getName()));
            wcSet = new HashSet<CrWorkspaceCredential>();
            wcSet.add(wc);
            workspace.setCrWorkspaceCredentials(wcSet);
        } else {
            Iterator iter = wcSet.iterator();
            CrWorkspaceCredential found = null;
            while (iter.hasNext() && found == null) {
                CrWorkspaceCredential item = (CrWorkspaceCredential)iter.next();
                if (item.getCrCredential() == null || !item.getCrCredential().getCredentialId().equals(crCredential.getCredentialId()) || item.getCrWorkspace() == null || !item.getCrWorkspace().getWorkspaceId().equals(workspace.getWorkspaceId())) continue;
                found = item;
            }
            if (found == null) {
                wcSet.add(wc);
            }
        }
        this.workspaceDAO.insert(wc);
    }

    public void logout(ITicket ticket) throws AccessDeniedException {
        this.ticketIdSet.remove(ticket.getTicketId());
        ticket.clear();
    }

    public boolean isTicketOkay(ITicket ticket) {
        return ticket != null && this.ticketIdSet.contains(ticket.getTicketId());
    }

    private SimpleVersionedNode getNode(Long workspaceId, Long uuid, Long versionId) throws ItemNotFoundException {
        SimpleVersionedNode dbNode = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
        dbNode.loadData(workspaceId, uuid, versionId);
        return dbNode;
    }

    private SimpleVersionedNode createFileNode(CrWorkspace workspace, InputStream istream, String filename, String mimeType, String versionDescription, String relPath, SimpleVersionedNode packageNode) throws InvalidParameterException, FileException, ValidationException {
        try {
            SimpleVersionedNode initialNodeVersion = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
            initialNodeVersion.initialiseNode(relPath, "FILENODE", workspace, packageNode);
            initialNodeVersion.setFile(istream, filename, mimeType);
            return initialNodeVersion;
        }
        catch (NoSuchNodeTypeException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
    }

    public NodeKey addFileItem(ITicket ticket, InputStream istream, String filename, String mimeType, String versionDescription) throws FileException, AccessDeniedException, InvalidParameterException {
        try {
            CrWorkspace workspace = this.getWorkspace(ticket.getWorkspaceId());
            SimpleVersionedNode initialNodeVersion = this.createFileNode(workspace, istream, filename, mimeType, versionDescription, null, null);
            initialNodeVersion.save(versionDescription, null);
            return initialNodeVersion.getNodeKey();
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
        catch (WorkspaceNotFoundException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
    }

    private List processPackageFilesSaveNode(CrWorkspace workspace, String dirPath, SimpleVersionedNode packageNode, String versionDescription) throws InvalidParameterException, FileException, ValidationException {
        File directory = new File(dirPath);
        if (!(directory.exists() && directory.isDirectory() && directory.canRead())) {
            throw new FileException("Directory " + dirPath + " does not exist, is not a directory or cannot be read.");
        }
        String removePathToMakeRelPath = directory.getAbsolutePath();
        if (removePathToMakeRelPath.charAt(removePathToMakeRelPath.length() - 1) != File.separatorChar) {
            removePathToMakeRelPath = removePathToMakeRelPath + File.separatorChar;
        }
        ArrayList nodeList = new ArrayList();
        this.processDirectory(workspace, removePathToMakeRelPath, directory, packageNode, versionDescription, nodeList);
        return nodeList;
    }

    private void processDirectory(CrWorkspace workspace, String removePathToMakeRelPath, File dirFile, SimpleVersionedNode packageNode, String versionDescription, List nodeList) throws InvalidParameterException, FileException, ValidationException {
        if (!(dirFile.exists() && dirFile.isDirectory() && dirFile.canRead())) {
            throw new FileException("Directory " + dirFile.getAbsolutePath() + " does not exist, is not a directory or cannot be read.");
        }
        File file = null;
        try {
            File[] files = dirFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                this.log.debug((Object)("Processing file " + file.getAbsolutePath()));
                this.log.debug((Object)("Name is " + file.getName()));
                if (file.isDirectory()) {
                    this.processDirectory(workspace, removePathToMakeRelPath, file, packageNode, versionDescription, nodeList);
                    continue;
                }
                String filename = file.getName();
                String filePath = file.getPath();
                String relPath = StringUtils.replace((String)filePath, (String)removePathToMakeRelPath, (String)"");
                if (filePath.length() == relPath.length()) {
                    throw new FileException("Unable to determine relative path of file. Path to package is " + removePathToMakeRelPath + "Path to file is " + filePath + "Attempted relPath is " + relPath);
                }
                relPath = relPath.replace(File.separatorChar, '/');
                FileInputStream istream = new FileInputStream(file);
                SimpleVersionedNode newNode = this.createFileNode(workspace, istream, filename, null, versionDescription, relPath, packageNode);
                nodeList.add(newNode);
            }
        }
        catch (FileNotFoundException fe) {
            String message = "FileNotFoundException thrown while trying to read file in package. File path=\"" + (file != null ? file.getAbsolutePath() : "") + "\"";
            this.log.error((Object)message, (Throwable)fe);
            throw new FileException("Internal error: unable to add package. " + message, fe);
        }
        catch (FileException e) {
            String message = "FileException thrown while trying to read file in package. File path=\"" + (file != null ? file.getAbsolutePath() : "") + "\"";
            this.log.error((Object)message, (Throwable)e);
            throw e;
        }
    }

    public NodeKey addPackageItem(ITicket ticket, String dirPath, String startFile, String versionDescription) throws AccessDeniedException, InvalidParameterException, FileException {
        CrWorkspace workspace = null;
        try {
            workspace = this.getWorkspace(ticket.getWorkspaceId());
        }
        catch (WorkspaceNotFoundException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
        SimpleVersionedNode packageNode = null;
        try {
            packageNode = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
            packageNode.initialiseNode(null, "PACKAGENODE", workspace, null);
            packageNode.setProperty("INITIALPATH", startFile);
        }
        catch (NoSuchNodeTypeException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add package." + e.getMessage(), e);
        }
        try {
            packageNode.save(versionDescription, null);
            List nodeList = this.processPackageFilesSaveNode(workspace, dirPath, packageNode, versionDescription);
            packageNode.save(versionDescription, nodeList);
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add package." + e.getMessage(), e);
        }
        return packageNode.getNodeKey();
    }

    public IVersionedNode getFileItem(ITicket ticket, Long uuid, Long version) throws AccessDeniedException, ItemNotFoundException, FileException {
        return this.getNode(ticket.getWorkspaceId(), uuid, version);
    }

    public IVersionedNode getFileItem(ITicket ticket, Long uuid, Long version, String relPath) throws AccessDeniedException, ItemNotFoundException, FileException {
        long start = System.currentTimeMillis();
        String key = "getFileItem " + uuid;
        SimpleVersionedNode latestNodeVersion = this.getNode(ticket.getWorkspaceId(), uuid, version);
        this.log.error((Object)(key + " latestNodeVersion " + (System.currentTimeMillis() - start)));
        if (relPath == null) {
            return latestNodeVersion;
        }
        IVersionedNode childNode = latestNodeVersion.getNode(relPath);
        this.log.error((Object)(key + " latestNodeVersion.getNode " + (System.currentTimeMillis() - start)));
        return childNode;
    }

    public List getPackageNodes(ITicket ticket, Long uuid, Long version) throws AccessDeniedException, ItemNotFoundException, FileException {
        long start = System.currentTimeMillis();
        SimpleVersionedNode latestNodeVersion = this.getNode(ticket.getWorkspaceId(), uuid, version);
        this.log.error((Object)("getPackageNodes latestNodeVersion " + (System.currentTimeMillis() - start)));
        Set childNodes = latestNodeVersion.getChildNodes();
        int childNodesSize = childNodes != null ? childNodes.size() : 0;
        this.log.error((Object)("getPackageNodes getChildNodes " + (System.currentTimeMillis() - start)));
        ArrayList<SimpleVersionedNode> list = new ArrayList<SimpleVersionedNode>(1 + childNodesSize);
        list.add(latestNodeVersion);
        list.addAll(childNodes);
        this.log.error((Object)("getPackageNodes end " + (System.currentTimeMillis() - start)));
        return list;
    }

    public SortedMap getNodeList(ITicket ticket) throws AccessDeniedException {
        Long workspaceId = ticket.getWorkspaceId();
        List nodes = this.workspaceDAO.findWorkspaceNodes(workspaceId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Workspace " + workspaceId + " has " + nodes.size() + " nodes."));
        }
        TreeMap<Long, SortedSet> map = new TreeMap<Long, SortedSet>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            CrNode node = (CrNode)iter.next();
            map.put(node.getNodeId(), node.getVersionHistory());
        }
        return map;
    }

    public SortedSet getVersionHistory(ITicket ticket, Long uuid) throws ItemNotFoundException, AccessDeniedException {
        SimpleVersionedNode node = this.getNode(ticket.getWorkspaceId(), uuid, null);
        return node.getVersionHistory();
    }

    public NodeKey updateFileItem(ITicket ticket, Long uuid, String filename, InputStream istream, String mimeType, String versionDescription) throws AccessDeniedException, ItemNotFoundException, FileException, InvalidParameterException {
        SimpleVersionedNode latestNodeVersion = this.getNode(ticket.getWorkspaceId(), uuid, null);
        if (!latestNodeVersion.isNodeType("FILENODE")) {
            throw new InvalidParameterException("Node is not a file node - it is a " + latestNodeVersion.getNodeType() + ". Unable to update as a file.");
        }
        SimpleVersionedNode newNodeVersion = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
        newNodeVersion.initialiseNewVersionOfNode(latestNodeVersion);
        newNodeVersion.setFile(istream, filename, mimeType);
        try {
            newNodeVersion.save(versionDescription, null);
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to update file." + e.getMessage(), e);
        }
        return newNodeVersion.getNodeKey();
    }

    public NodeKey updatePackageItem(ITicket ticket, Long uuid, String dirPath, String startFile, String versionDescription) throws AccessDeniedException, ItemNotFoundException, FileException, InvalidParameterException {
        SimpleVersionedNode latestNodeVersion = this.getNode(ticket.getWorkspaceId(), uuid, null);
        if (!latestNodeVersion.isNodeType("PACKAGENODE")) {
            throw new InvalidParameterException("Node is not a package node - it is a " + latestNodeVersion.getNodeType() + ". Unable to update as a package.");
        }
        SimpleVersionedNode newPackageNode = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleRepository.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
        newPackageNode.initialiseNewVersionOfNode(latestNodeVersion);
        newPackageNode.setProperty("INITIALPATH", startFile);
        try {
            CrWorkspace workspace = this.getWorkspace(ticket.getWorkspaceId());
            newPackageNode.save(versionDescription, null);
            List nodeList = this.processPackageFilesSaveNode(workspace, dirPath, newPackageNode, versionDescription);
            newPackageNode.save(versionDescription, nodeList);
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add package." + e.getMessage(), e);
        }
        catch (WorkspaceNotFoundException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
        return newPackageNode.getNodeKey();
    }

    public String[] deleteNode(ITicket ticket, Long uuid) throws AccessDeniedException, InvalidParameterException, ItemNotFoundException {
        if (uuid == null) {
            throw new InvalidParameterException("UUID is required for deleteItem.");
        }
        SimpleVersionedNode latestNodeVersion = this.getNode(ticket.getWorkspaceId(), uuid, new Long(1L));
        if (latestNodeVersion.hasParentNode()) {
            throw new InvalidParameterException("You cannot delete a node that is in a package (ie has a parent). Please delete the parent. Node UUID " + uuid);
        }
        List problemPaths = latestNodeVersion.deleteNode();
        return problemPaths != null ? problemPaths.toArray(new String[problemPaths.size()]) : new String[]{};
    }

    public String[] deleteVersion(ITicket ticket, Long uuid, Long version) throws AccessDeniedException, InvalidParameterException, ItemNotFoundException {
        if (uuid == null || version == null) {
            throw new InvalidParameterException("Both uuid and version are required for deleteVersion.");
        }
        SimpleVersionedNode nodeVersion = this.getNode(ticket.getWorkspaceId(), uuid, version);
        List problemPaths = nodeVersion.deleteVersion();
        return problemPaths != null ? problemPaths.toArray(new String[problemPaths.size()]) : new String[]{};
    }

    public IWorkspaceDAO getWorkspaceDAO() {
        return this.workspaceDAO;
    }

    public void setWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    public ICredentialDAO getCredentialDAO() {
        return this.credentialDAO;
    }

    public void setCredentialDAO(ICredentialDAO credentialDAO) {
        this.credentialDAO = credentialDAO;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

