/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.dto.BranchActivityEntryDTO;
import org.lamsfoundation.lams.learningdesign.dto.ToolOutputBranchActivityEntryDTO;

public class BranchActivityEntry {
    protected Long entryId;
    protected Integer entryUIID;
    protected SequenceActivity branchSequenceActivity;
    protected BranchingActivity branchingActivity;
    private Group group;
    private BranchCondition condition;

    public BranchActivityEntry() {
    }

    public BranchActivityEntry(Long entryId, Integer entryUIID, SequenceActivity branchSequenceActivity, BranchingActivity branchingActivity, Group group) {
        this.entryId = entryId;
        this.entryUIID = entryUIID;
        this.branchSequenceActivity = branchSequenceActivity;
        this.branchingActivity = branchingActivity;
        this.group = group;
        this.condition = null;
    }

    public BranchActivityEntry(Long entryId, Integer entryUIID, SequenceActivity branchSequenceActivity, BranchingActivity branchingActivity, BranchCondition condition) {
        this.entryId = entryId;
        this.entryUIID = entryUIID;
        this.branchSequenceActivity = branchSequenceActivity;
        this.branchingActivity = branchingActivity;
        this.group = null;
        this.condition = condition;
    }

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long id) {
        this.entryId = id;
    }

    public Integer getEntryUIID() {
        return this.entryUIID;
    }

    public void setEntryUIID(Integer entryUIID) {
        this.entryUIID = entryUIID;
    }

    public SequenceActivity getBranchSequenceActivity() {
        return this.branchSequenceActivity;
    }

    public void setBranchSequenceActivity(SequenceActivity branchSequenceActivity) {
        this.branchSequenceActivity = branchSequenceActivity;
    }

    public BranchingActivity getBranchingActivity() {
        return this.branchingActivity;
    }

    public void setBranchingActivity(BranchingActivity branchingActivity) {
        this.branchingActivity = branchingActivity;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public BranchCondition getCondition() {
        return this.condition;
    }

    public void setCondition(BranchCondition condition) {
        this.condition = condition;
    }

    public BranchActivityEntryDTO getBranchActivityEntryDTO() {
        BranchActivityEntryDTO entryDTO = null;
        if (this.getCondition() != null) {
            ToolOutputBranchActivityEntryDTO toolEntryDTO = new ToolOutputBranchActivityEntryDTO();
            toolEntryDTO.setCondition(this.getCondition().getBranchConditionDTO());
            entryDTO = toolEntryDTO;
        } else {
            entryDTO = new BranchActivityEntryDTO();
        }
        entryDTO.setEntryID(this.getEntryId());
        entryDTO.setEntryUIID(this.getEntryUIID());
        if (this.getGroup() != null) {
            entryDTO.setGroupUIID(this.getGroup().getGroupUIID());
        }
        entryDTO.setSequenceActivityUIID(this.getBranchSequenceActivity().getActivityUIID());
        entryDTO.setBranchingActivityUIID(this.getBranchingActivity().getActivityUIID());
        return entryDTO;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BranchActivityEntry)) {
            return false;
        }
        BranchActivityEntry castOther = (BranchActivityEntry)other;
        return new EqualsBuilder().append((Object)this.getEntryId(), (Object)castOther.getEntryId()).append((Object)this.getEntryUIID(), (Object)castOther.getEntryUIID()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getEntryId()).append((Object)this.getEntryUIID()).toHashCode();
    }

    public int compareTo(Object other) {
        BranchActivityEntry castOther = (BranchActivityEntry)other;
        return new CompareToBuilder().append((Object)this.getEntryId(), (Object)castOther.getEntryId()).append((Object)this.getEntryUIID(), (Object)castOther.getEntryUIID()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entryId", (Object)this.getEntryId()).append("entryUIID", (Object)this.getEntryUIID()).append("group", (Object)(this.getGroup() != null ? this.getGroup().getGroupId().toString() : "")).append("sequence activity", (Object)(this.getBranchSequenceActivity() != null ? this.getBranchSequenceActivity().getActivityId().toString() : "")).toString();
    }
}

