/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.strategy.SequenceActivityStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceActivity
extends ComplexActivity
implements Serializable {
    private static Logger log = Logger.getLogger(SequenceActivity.class);
    private Set branchEntries;

    public SequenceActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Set inputActivities, Set activities, Activity defaultActivity, Set branchEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, inputActivities, activities, defaultActivity);
        this.activityStrategy = new SequenceActivityStrategy(this);
        this.branchEntries = branchEntries;
    }

    public SequenceActivity() {
        this.activityStrategy = new SequenceActivityStrategy(this);
    }

    public SequenceActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, SortedSet activities) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, activities);
        this.activityStrategy = new SequenceActivityStrategy(this);
    }

    @Override
    public Activity createCopy() {
        SequenceActivity newSequenceActivity = new SequenceActivity();
        this.copyToNewComplexActivity(newSequenceActivity);
        newSequenceActivity.defaultActivity = this.defaultActivity;
        if (this.getBranchEntries() != null && this.getBranchEntries().size() > 0) {
            newSequenceActivity.setBranchEntries(new HashSet());
            for (BranchActivityEntry oldEntry : this.getBranchEntries()) {
                BranchActivityEntry newEntry = new BranchActivityEntry(null, oldEntry.getEntryUIID(), newSequenceActivity, oldEntry.getBranchingActivity(), oldEntry.getGroup());
                if (oldEntry.getCondition() != null) {
                    newEntry.setCondition(oldEntry.getCondition().clone());
                }
                newSequenceActivity.getBranchEntries().add(newEntry);
            }
        }
        return newSequenceActivity;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public Set getBranchEntries() {
        return this.branchEntries;
    }

    public void setBranchEntries(Set branchEntries) {
        this.branchEntries = branchEntries;
    }

    public SortedSet<Group> getGroupsForBranch() {
        Set mappingEntries = this.getBranchEntries();
        TreeSet<Group> sortedGroups = new TreeSet<Group>();
        if (mappingEntries != null) {
            Iterator mappingIter = mappingEntries.iterator();
            while (mappingIter.hasNext()) {
                Group group = ((BranchActivityEntry)mappingIter.next()).getGroup();
                if (group == null) continue;
                sortedGroups.add(group);
            }
        }
        return sortedGroups;
    }

    public Group getSoleGroupForBranch() {
        Iterator iter;
        SortedSet<Group> groups = this.getGroupsForBranch();
        if (groups.size() > 1) {
            log.warn((Object)("Branch " + this + " has more than one group. This is unexpected. Using only the first group."));
        }
        if ((iter = groups.iterator()).hasNext()) {
            return (Group)iter.next();
        }
        return null;
    }
}

