/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Date;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.SystemGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.BranchActivityEntryDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringActivityDTO
extends BaseDTO {
    private Long activityID;
    private Integer activityUIID;
    private String description;
    private String activityTitle;
    private String helpText;
    private String helpURL;
    private Integer xCoord;
    private Integer yCoord;
    private Long parentActivityID;
    private Integer parentUIID;
    private Integer activityTypeID;
    private Long groupingID;
    private Integer groupingUIID;
    private Integer orderID;
    private Boolean defineLater;
    private Long learningDesignID;
    private Long learningLibraryID;
    private Date createDateTime;
    private Boolean runOffline;
    private Integer maxOptions;
    private Integer minOptions;
    private String optionsInstructions;
    private String toolSignature;
    private Long toolID;
    private Long toolContentID;
    private String toolDisplayName;
    private String toolVersion;
    private String authoringURL;
    private String monitoringURL;
    private String contributeURL;
    private String moderationURL;
    private String adminURL;
    private Integer activityCategoryID;
    private Integer gateActivityLevelID;
    private Boolean gateOpen;
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Date gateStartDateTime;
    private Date gateEndDateTime;
    private Boolean applyGrouping;
    private Integer groupingSupportType;
    private Integer groupingType;
    private String libraryActivityUIImage;
    private Long createGroupingID;
    private Integer createGroupingUIID;
    private Boolean readOnly;
    private Boolean initialised;
    private Boolean stopAfterActivity;
    private Long libraryActivityID;
    private String languageFile;
    private ArrayList<Integer> inputActivities;
    private Integer toolActivityUIID;
    private Integer defaultActivityUIID;
    private Integer startXCoord;
    private Integer startYCoord;
    private Integer endXCoord;
    private Integer endYCoord;

    public AuthoringActivityDTO(Long activityID, Integer activityUIID, String description, String title, String helpText, Integer xcoord, Integer ycoord, Long parentActivityID, Integer parentUIID, Integer activityTypeId, Long groupingID, Integer groupingUIID, Integer orderID, Boolean defineLater, Long learningDesignID, Long learningLibraryID, Date createDateTime, Boolean runOffline, String languageFile, Integer maxOptions, Integer minOptions, String optionsInstructions, String toolSignature, Long toolID, Long toolContentID, Integer activityCategoryID, Integer gateActivityLevelID, Boolean gateOpen, Long gateStartTimeOffset, Long gateEndTimeOffset, Date gateStartDateTime, Date gateEndDateTime, String libraryActivityUiImage, Long createGroupingID, Integer createGroupingUIID, Long libraryActivityID, Boolean applyGrouping, Integer groupingSupportType, Integer groupingType, GroupingDTO groupingDTO, Boolean readOnly, Boolean initialised, Boolean stopAfterActivity, ArrayList<Integer> inputActivities, Integer toolActivityUIID, Integer defaultActivityUIID, Integer startXCoord, Integer startYCoord, Integer endXCoord, Integer endYCoord) {
        this.activityID = activityID;
        this.activityUIID = activityUIID;
        this.description = description;
        this.activityTitle = title;
        this.helpText = helpText;
        this.xCoord = xcoord;
        this.yCoord = ycoord;
        this.parentActivityID = parentActivityID;
        this.parentUIID = parentUIID;
        this.activityTypeID = activityTypeId;
        this.groupingID = groupingID;
        this.groupingUIID = groupingUIID;
        this.orderID = orderID;
        this.defineLater = defineLater;
        this.learningDesignID = learningDesignID;
        this.learningLibraryID = learningLibraryID;
        this.createDateTime = createDateTime;
        this.runOffline = runOffline;
        this.languageFile = languageFile;
        this.maxOptions = maxOptions;
        this.minOptions = minOptions;
        this.optionsInstructions = optionsInstructions;
        this.toolSignature = toolSignature;
        this.toolID = toolID;
        this.toolContentID = toolContentID;
        this.activityCategoryID = activityCategoryID;
        this.gateActivityLevelID = gateActivityLevelID;
        this.gateOpen = gateOpen;
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.gateStartDateTime = gateStartDateTime;
        this.gateEndDateTime = gateEndDateTime;
        this.libraryActivityUIImage = libraryActivityUiImage;
        this.createGroupingID = createGroupingID;
        this.createGroupingUIID = createGroupingUIID;
        this.libraryActivityID = libraryActivityID;
        this.applyGrouping = applyGrouping;
        this.groupingSupportType = groupingSupportType;
        this.groupingType = groupingType;
        this.readOnly = readOnly;
        this.initialised = initialised;
        this.stopAfterActivity = stopAfterActivity;
        this.toolActivityUIID = toolActivityUIID;
        this.inputActivities = inputActivities;
        this.defaultActivityUIID = defaultActivityUIID;
        this.startXCoord = startXCoord;
        this.startYCoord = startYCoord;
        this.endXCoord = endXCoord;
        this.endYCoord = endYCoord;
    }

    public AuthoringActivityDTO(Activity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        this.processActivityType(activity, branchMappings);
        this.activityID = activity.getActivityId();
        this.activityUIID = activity.getActivityUIID();
        this.description = activity.getDescription();
        this.activityTitle = activity.getTitle();
        this.helpText = activity.getHelpText();
        this.xCoord = activity.getXcoord();
        this.yCoord = activity.getYcoord();
        this.parentActivityID = activity.getParentActivity() != null ? activity.getParentActivity().getActivityId() : null;
        this.parentUIID = activity.getParentUIID();
        this.activityTypeID = activity.getActivityTypeId();
        this.groupingID = activity.getGrouping() != null ? activity.getGrouping().getGroupingId() : null;
        this.groupingUIID = activity.getGroupingUIID();
        this.orderID = activity.getOrderId();
        this.defineLater = activity.getDefineLater();
        this.learningDesignID = activity.getLearningDesign() != null ? activity.getLearningDesign().getLearningDesignId() : null;
        this.learningLibraryID = activity.getLearningLibrary() != null ? activity.getLearningLibrary().getLearningLibraryId() : null;
        this.createDateTime = activity.getCreateDateTime();
        this.runOffline = activity.getRunOffline();
        this.languageFile = activity.getLanguageFile();
        this.activityCategoryID = activity.getActivityCategoryID();
        this.libraryActivityUIImage = activity.getLibraryActivityUiImage();
        this.libraryActivityID = activity.getLibraryActivity() != null ? activity.getLibraryActivity().getActivityId() : null;
        this.applyGrouping = activity.getApplyGrouping();
        this.groupingSupportType = activity.getGroupingSupportType();
        this.readOnly = activity.getReadOnly();
        this.initialised = activity.isInitialised();
        this.stopAfterActivity = activity.isStopAfterActivity();
        if (activity.getInputActivities() != null && activity.getInputActivities().size() > 0) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Activity inputAct : activity.getInputActivities()) {
                list.add(inputAct.getActivityUIID());
                this.toolActivityUIID = inputAct.getActivityUIID();
            }
            this.inputActivities = list;
        }
    }

    private void processActivityType(Activity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        if (activity.isGroupingActivity()) {
            this.addGroupingActivityAttributes((GroupingActivity)activity);
        } else if (activity.isToolActivity()) {
            this.addToolActivityAttributes((ToolActivity)activity);
        } else if (activity.isGateActivity()) {
            this.addGateActivityAttributes(activity);
        } else {
            this.addComplexActivityAttributes(activity, branchMappings);
        }
    }

    private void addComplexActivityAttributes(Activity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        ComplexActivity complex = (ComplexActivity)activity;
        if (complex.getDefaultActivity() != null) {
            this.defaultActivityUIID = complex.getDefaultActivity().getActivityUIID();
        }
        if (activity.isOptionsActivity()) {
            this.addOptionsActivityAttributes((OptionsActivity)activity);
        } else if (activity.isParallelActivity()) {
            this.addParallelActivityAttributes((ParallelActivity)activity);
        } else if (activity.isBranchingActivity()) {
            this.addBranchingActivityAttributes((BranchingActivity)activity);
        } else {
            this.addSequenceActivityAttributes((SequenceActivity)activity, branchMappings);
        }
    }

    private void addGroupingActivityAttributes(GroupingActivity groupingActivity) {
        Grouping grouping = groupingActivity.getCreateGrouping();
        this.createGroupingID = grouping.getGroupingId();
        this.createGroupingUIID = grouping.getGroupingUIID();
        this.adminURL = groupingActivity.getSystemTool().getAdminUrl();
    }

    private void addOptionsActivityAttributes(OptionsActivity optionsActivity) {
        this.maxOptions = optionsActivity.getMaxNumberOfOptions();
        this.minOptions = optionsActivity.getMinNumberOfOptions();
        this.optionsInstructions = optionsActivity.getOptionsInstructions();
    }

    private void addParallelActivityAttributes(ParallelActivity activity) {
    }

    private void addBranchingActivityAttributes(BranchingActivity activity) {
        this.startXCoord = activity.getStartXcoord();
        this.startYCoord = activity.getStartYcoord();
        this.endXCoord = activity.getEndXcoord();
        this.endYCoord = activity.getEndYcoord();
    }

    private void addSequenceActivityAttributes(SequenceActivity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        for (BranchActivityEntry ba : activity.getBranchEntries()) {
            branchMappings.add(ba.getBranchActivityEntryDTO());
        }
    }

    private void addToolActivityAttributes(ToolActivity toolActivity) {
        this.toolContentID = toolActivity.getToolContentId();
        this.toolID = toolActivity.getTool().getToolId();
        this.toolSignature = toolActivity.getTool().getToolSignature();
        this.authoringURL = toolActivity.getTool().getAuthorUrl();
        this.monitoringURL = toolActivity.getTool().getMonitorUrl();
        this.contributeURL = toolActivity.getTool().getContributeUrl();
        this.moderationURL = toolActivity.getTool().getModerationUrl();
        this.helpURL = toolActivity.getTool().getHelpUrl();
        this.adminURL = toolActivity.getTool().getAdminUrl();
        this.toolDisplayName = toolActivity.getTool().getToolDisplayName();
        this.toolVersion = toolActivity.getTool().getToolVersion();
    }

    private void addGateActivityAttributes(Object activity) {
        if (activity instanceof SynchGateActivity) {
            this.addSynchGateActivityAttributes((SynchGateActivity)activity);
        } else if (activity instanceof PermissionGateActivity) {
            this.addPermissionGateActivityAttributes((PermissionGateActivity)activity);
        } else if (activity instanceof SystemGateActivity) {
            this.addSystemGateActivityAttributes((SystemGateActivity)activity);
        } else {
            this.addScheduleGateActivityAttributes((ScheduleGateActivity)activity);
        }
        GateActivity gateActivity = (GateActivity)activity;
        this.gateActivityLevelID = gateActivity.getGateActivityLevelId();
        this.gateOpen = gateActivity.getGateOpen();
        this.adminURL = gateActivity.getSystemTool().getAdminUrl();
    }

    private void addSynchGateActivityAttributes(SynchGateActivity activity) {
    }

    private void addPermissionGateActivityAttributes(PermissionGateActivity activity) {
    }

    private void addSystemGateActivityAttributes(SystemGateActivity activity) {
    }

    private void addScheduleGateActivityAttributes(ScheduleGateActivity activity) {
        this.gateStartDateTime = activity.getGateStartDateTime();
        this.gateStartTimeOffset = activity.getGateStartTimeOffset();
        this.gateEndDateTime = activity.getGateEndDateTime();
        this.gateEndTimeOffset = activity.getGateEndTimeOffset();
    }

    public Integer getActivityCategoryID() {
        return this.activityCategoryID;
    }

    public Long getActivityID() {
        return this.activityID;
    }

    public Integer getActivityTypeID() {
        return this.activityTypeID;
    }

    public Integer getActivityUIID() {
        return this.activityUIID;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Long getCreateGroupingID() {
        return this.createGroupingID;
    }

    public Integer getCreateGroupingUIID() {
        return this.createGroupingUIID;
    }

    public Boolean getDefineLater() {
        return this.defineLater;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getGateActivityLevelID() {
        return this.gateActivityLevelID;
    }

    public Date getGateEndDateTime() {
        return this.gateEndDateTime;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset;
    }

    public Boolean getGateOpen() {
        return this.gateOpen;
    }

    public Date getGateStartDateTime() {
        return this.gateStartDateTime;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset;
    }

    public Long getGroupingID() {
        return this.groupingID;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Long getLearningLibraryID() {
        return this.learningLibraryID;
    }

    public Long getLibraryActivityID() {
        return this.libraryActivityID;
    }

    public String getLibraryActivityUIImage() {
        return this.libraryActivityUIImage;
    }

    public Integer getMaxOptions() {
        return this.maxOptions;
    }

    public Integer getMinOptions() {
        return this.minOptions;
    }

    public String getOptionsInstructions() {
        return this.optionsInstructions;
    }

    public Integer getOrderID() {
        return this.orderID;
    }

    public Long getParentActivityID() {
        return this.parentActivityID;
    }

    public Integer getParentUIID() {
        return this.parentUIID;
    }

    public Boolean getRunOffline() {
        return this.runOffline;
    }

    public String getActivityTitle() {
        return this.activityTitle;
    }

    public Long getToolContentID() {
        return this.toolContentID;
    }

    public Long getToolID() {
        return this.toolID;
    }

    public Integer getxCoord() {
        return this.xCoord;
    }

    public Integer getyCoord() {
        return this.yCoord;
    }

    public String getAuthoringURL() {
        return this.authoringURL;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public String getLanguageFile() {
        return this.languageFile;
    }

    public String getToolDisplayName() {
        return this.toolDisplayName;
    }

    public String getContributeURL() {
        return this.contributeURL;
    }

    public String getMonitoringURL() {
        return this.monitoringURL;
    }

    public String getModerationURL() {
        return this.moderationURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public String getToolSignature() {
        return this.toolSignature;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public Boolean getInitialised() {
        return this.initialised;
    }

    public Boolean getStopAfterActivity() {
        return this.stopAfterActivity;
    }

    public Boolean getApplyGrouping() {
        return this.applyGrouping;
    }

    public Integer getGroupingSupportType() {
        return this.groupingSupportType;
    }

    public Integer getGroupingType() {
        return this.groupingType;
    }

    public Integer getDefaultActivityUIID() {
        return this.defaultActivityUIID;
    }

    public Integer getEndXCoord() {
        return this.endXCoord;
    }

    public Integer getEndYCoord() {
        return this.endYCoord;
    }

    public Integer getStartXCoord() {
        return this.startXCoord;
    }

    public Integer getStartYCoord() {
        return this.startYCoord;
    }

    public void setActivityCategoryID(Integer activityCategoryID) {
        if (!activityCategoryID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.activityCategoryID = activityCategoryID;
        }
    }

    public void setActivityID(Long activityId) {
        if (!activityId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.activityID = activityId;
        }
    }

    public void setActivityTypeID(Integer activityTypeId) {
        if (!activityTypeId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.activityTypeID = activityTypeId;
        }
    }

    public void setActivityUIID(Integer activityUIID) {
        if (!activityUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.activityUIID = activityUIID;
        }
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setCreateGroupingID(Long createGroupingID) {
        if (!createGroupingID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.createGroupingID = createGroupingID;
        }
    }

    public void setCreateGroupingUIID(Integer createGroupingUIID) {
        if (!createGroupingUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.createGroupingUIID = createGroupingUIID;
        }
    }

    public void setDefineLater(Boolean defineLater) {
        this.defineLater = defineLater;
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setGateActivityLevelID(Integer gateActivityLevelID) {
        if (!gateActivityLevelID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.gateActivityLevelID = gateActivityLevelID;
        }
    }

    public void setGateEndDateTime(Date gateEndDateTime) {
        if (!gateEndDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.gateEndDateTime = gateEndDateTime;
        }
    }

    public void setGateEndTimeOffset(Long gateEndTimeOffset) {
        if (!gateEndTimeOffset.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.gateEndTimeOffset = gateEndTimeOffset;
        }
    }

    public void setGateOpen(Boolean gateOpen) {
        this.gateOpen = gateOpen;
    }

    public void setGateStartDateTime(Date gateStartDateTime) {
        if (!gateStartDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.gateStartDateTime = gateStartDateTime;
        }
    }

    public void setGateStartTimeOffset(Long gateStartTimeOffset) {
        if (!gateStartTimeOffset.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.gateStartTimeOffset = gateStartTimeOffset;
        }
    }

    public void setGroupingID(Long groupingID) {
        if (!groupingID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.groupingID = groupingID;
        }
    }

    public void setGroupingUIID(Integer groupingUIID) {
        if (!groupingUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingUIID = groupingUIID;
        }
    }

    public void setHelpText(String helpText) {
        if (!helpText.equals("string_null_value")) {
            this.helpText = helpText;
        }
    }

    public void setLearningDesignID(Long learningDesignID) {
        if (!learningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignID = learningDesignID;
        }
    }

    public void setLearningLibraryID(Long learningLibraryID) {
        if (!learningLibraryID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningLibraryID = learningLibraryID;
        }
    }

    public void setLibraryActivityID(Long libraryActivityID) {
        if (!libraryActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.libraryActivityID = libraryActivityID;
        }
    }

    public void setLibraryActivityUIImage(String libraryActivityUiImage) {
        if (!libraryActivityUiImage.equals("string_null_value")) {
            this.libraryActivityUIImage = libraryActivityUiImage;
        }
    }

    public void setMaxOptions(Integer maxOptions) {
        if (!maxOptions.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxOptions = maxOptions;
        }
    }

    public void setMinOptions(Integer minOptions) {
        if (!minOptions.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.minOptions = minOptions;
        }
    }

    public void setOptionsInstructions(String optionsInstructions) {
        if (!optionsInstructions.equals("string_null_value")) {
            this.optionsInstructions = optionsInstructions;
        }
    }

    public void setOrderID(Integer orderID) {
        if (!orderID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.orderID = orderID;
        }
    }

    public void setParentActivityID(Long parentActivityID) {
        if (!parentActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.parentActivityID = parentActivityID;
        }
    }

    public void setParentUIID(Integer parentUIID) {
        if (!parentUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.parentUIID = parentUIID;
        }
    }

    public void setRunOffline(Boolean runOffline) {
        this.runOffline = runOffline;
    }

    public void setActivityTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.activityTitle = title;
        }
    }

    public void setToolContentID(Long toolContentID) {
        if (!toolContentID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.toolContentID = toolContentID;
        }
    }

    public void setToolID(Long toolID) {
        if (!toolID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.toolID = toolID;
        }
    }

    public void setxCoord(Integer xcoord) {
        if (!xcoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.xCoord = xcoord;
        }
    }

    public void setyCoord(Integer ycoord) {
        if (!this.xCoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.yCoord = ycoord;
        }
    }

    public void setApplyGrouping(Boolean applyGrouping) {
        this.applyGrouping = applyGrouping;
    }

    public void setGroupingSupportType(Integer groupingSupportType) {
        if (!groupingSupportType.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingSupportType = groupingSupportType;
        }
    }

    public void setGroupingType(Integer groupingType) {
        if (!groupingType.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingType = groupingType;
        }
    }

    public void setReadOnly(Boolean readOnly) {
        if (!readOnly.equals(WDDXTAGS.BOOLEAN_NULL_VALUE)) {
            this.readOnly = readOnly;
        }
    }

    public void setAuthoringURL(String toolAuthoringURL) {
        this.authoringURL = toolAuthoringURL;
    }

    public void setToolDisplayName(String toolDisplayName) {
        this.toolDisplayName = toolDisplayName;
    }

    public void setLanguageFile(String languageFile) {
        this.languageFile = languageFile;
    }

    public void setContributeURL(String contributeURL) {
        this.contributeURL = contributeURL;
    }

    public void setMonitoringURL(String monitoringURL) {
        this.monitoringURL = monitoringURL;
    }

    public void setModerationURL(String moderationURL) {
        this.moderationURL = moderationURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public void setToolSignature(String toolSignature) {
        this.toolSignature = toolSignature;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public void setInitialised(Boolean initialised) {
        this.initialised = initialised;
    }

    public void setStopAfterActivity(Boolean stopAfterActivity) {
        this.stopAfterActivity = stopAfterActivity;
    }

    public void setDefaultActivityUIID(Integer defaultActivityUIID) {
        if (!defaultActivityUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.defaultActivityUIID = defaultActivityUIID;
        }
    }

    public void setEndXCoord(Integer endXCoord) {
        if (!endXCoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.endXCoord = endXCoord;
        }
    }

    public void setEndYCoord(Integer endYCoord) {
        if (!endYCoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.endYCoord = endYCoord;
        }
    }

    public void setStartXCoord(Integer startXCoord) {
        if (!startXCoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.startXCoord = startXCoord;
        }
    }

    public void setStartYCoord(Integer startYCoord) {
        if (!startYCoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.startYCoord = startYCoord;
        }
    }

    public String getAdminURL() {
        return this.adminURL;
    }

    public void setAdminURL(String adminURL) {
        this.adminURL = adminURL;
    }

    public ArrayList<Integer> getInputActivities() {
        return this.inputActivities;
    }

    public void setInputActivities(ArrayList<Integer> inputActivities) {
        this.inputActivities = inputActivities;
    }

    public Integer getToolActivityUIID() {
        return this.toolActivityUIID;
    }

    public void setToolActivityUIID(Integer toolActivityUIID) {
        this.toolActivityUIID = toolActivityUIID;
    }
}

