/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class GroupingDTO
extends BaseDTO {
    private Long groupingID;
    private Integer groupingUIID;
    private Integer groupingTypeID;
    private Integer numberOfGroups;
    private Integer learnersPerGroup;
    private Long staffGroupID;
    private Integer maxNumberOfGroups;
    private List groups;

    public GroupingDTO(Long groupingID, Integer groupingUIID, Integer groupingType, Integer numberOfGroups, Integer learnersPerGroup, Long staffGroupID, Integer maxNumberOfGroups, List groupDTOs) {
        this.groupingID = groupingID;
        this.groupingUIID = groupingUIID;
        this.groupingTypeID = groupingType;
        this.numberOfGroups = numberOfGroups;
        this.learnersPerGroup = learnersPerGroup;
        this.staffGroupID = staffGroupID;
        this.maxNumberOfGroups = maxNumberOfGroups;
        this.groups = groupDTOs;
    }

    public GroupingDTO(Grouping grouping, boolean setupUserList) {
        this.groupingID = grouping.getGroupingId();
        this.groupingUIID = grouping.getGroupingUIID();
        this.maxNumberOfGroups = grouping.getMaxNumberOfGroups();
        this.groupingTypeID = grouping.getGroupingTypeId();
        Set groupSet = grouping.getGroups();
        this.groups = new ArrayList();
        if (groupSet != null) {
            Iterator iter = groupSet.iterator();
            while (iter.hasNext()) {
                this.groups.add(((Group)iter.next()).getGroupDTO(setupUserList));
            }
        }
        this.processGroupingActivity(grouping);
    }

    public void processGroupingActivity(Object object) {
        if (object instanceof RandomGrouping) {
            this.addRandomGroupingAttributes((RandomGrouping)object);
        } else if (object instanceof ChosenGrouping) {
            this.addChosenGroupingAttributes((ChosenGrouping)object);
        } else {
            this.addLessonClassAttributes((LessonClass)object);
        }
    }

    private void addRandomGroupingAttributes(RandomGrouping grouping) {
        this.learnersPerGroup = grouping.getLearnersPerGroup();
        this.numberOfGroups = grouping.getNumberOfGroups();
    }

    private void addChosenGroupingAttributes(ChosenGrouping grouping) {
    }

    private void addLessonClassAttributes(LessonClass grouping) {
        this.staffGroupID = grouping.getStaffGroup().getGroupId();
    }

    public Long getGroupingID() {
        return this.groupingID;
    }

    public void setGroupingID(Long groupingID) {
        if (!groupingID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.groupingID = groupingID;
        }
    }

    public Integer getGroupingTypeID() {
        return this.groupingTypeID;
    }

    public void setGroupingTypeID(Integer groupingType) {
        if (!groupingType.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingTypeID = groupingType;
        }
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public void setGroupingUIID(Integer groupingUIID) {
        if (!groupingUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingUIID = groupingUIID;
        }
    }

    public Integer getLearnersPerGroup() {
        return this.learnersPerGroup;
    }

    public void setLearnersPerGroup(Integer learnersPerGroup) {
        if (!learnersPerGroup.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.learnersPerGroup = learnersPerGroup;
        }
    }

    public Integer getMaxNumberOfGroups() {
        return this.maxNumberOfGroups;
    }

    public void setMaxNumberOfGroups(Integer maxNumberOfGroups) {
        if (!maxNumberOfGroups.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxNumberOfGroups = maxNumberOfGroups;
        }
    }

    public Integer getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public void setNumberOfGroups(Integer numberOfGroups) {
        if (!numberOfGroups.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.numberOfGroups = numberOfGroups;
        }
    }

    public Long getStaffGroupID() {
        return this.staffGroupID;
    }

    public void setStaffGroupID(Long staffGroupID) {
        if (!staffGroupID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.staffGroupID = staffGroupID;
        }
    }

    public List getGroups() {
        return this.groups;
    }

    public void setGroups(List groups) {
        this.groups = groups;
    }
}

