/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.util.ILoadedMessageSourceService;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningDesignService
implements ILearningDesignService {
    protected Logger log = Logger.getLogger(LearningDesignService.class);
    protected MessageService messageService;
    protected LearningDesignDAO learningDesignDAO;
    protected ActivityDAO activityDAO;
    protected GroupingDAO groupingDAO;
    protected LearningLibraryDAO learningLibraryDAO;
    protected ILoadedMessageSourceService toolActMessageService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public ILoadedMessageSourceService getToolActMessageService() {
        return this.toolActMessageService;
    }

    public void setToolActMessageService(ILoadedMessageSourceService toolActMessageService) {
        this.toolActMessageService = toolActMessageService;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    @Override
    public LearningDesignDTO getLearningDesignDTO(Long learningDesignID) {
        LearningDesign design = learningDesignID != null ? this.learningDesignDAO.getLearningDesignById(learningDesignID) : null;
        return design != null ? new LearningDesignDTO(design, this.activityDAO, this.groupingDAO) : null;
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(LearningDesign learningDesign) {
        Vector<ValidationErrorDTO> listOfValidationErrorDTOs = new Vector<ValidationErrorDTO>();
        this.validateActivityTransitionRules(learningDesign.getParentActivities(), learningDesign.getTransitions(), listOfValidationErrorDTOs);
        this.validateGeneral(learningDesign.getActivities(), listOfValidationErrorDTOs);
        this.cleanupValidationErrors(listOfValidationErrorDTOs);
        return listOfValidationErrorDTOs;
    }

    @Override
    public void setValid(Long learningLibraryId, boolean valid) {
        LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryId);
        library.setValidLibrary(valid);
        this.learningLibraryDAO.update(library);
    }

    private void cleanupValidationErrors(Vector<ValidationErrorDTO> errors) {
        Object currentError = null;
        Iterator<ValidationErrorDTO> it = errors.iterator();
        while (it.hasNext()) {
            this.cleanupTransitionErrors(errors, it);
        }
    }

    private void cleanupTransitionErrors(Vector<ValidationErrorDTO> errors, Iterator topIt) {
        ValidationErrorDTO currentError = (ValidationErrorDTO)topIt.next();
        Iterator<ValidationErrorDTO> it = errors.iterator();
        while (it.hasNext()) {
            ValidationErrorDTO nextError = it.next();
            if (!currentError.getCode().equals("AT") || !nextError.getCode().equals("IT") && !nextError.getCode().equals("OT1")) continue;
            if (currentError.getUIID().equals(nextError.getUIID())) {
                topIt.remove();
                return;
            }
            if (!currentError.getCode().equals("IT") || !nextError.getCode().equals("AT")) continue;
            if (currentError.getUIID().equals(nextError.getUIID())) {
                it.remove();
                continue;
            }
            if (!currentError.getCode().equals("OT1") || !nextError.getCode().equals("AT") || !currentError.getUIID().equals(nextError.getUIID())) continue;
            it.remove();
        }
    }

    private void validateActivityTransitionRules(Set topLevelActivities, Set transitions, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        this.validateTransitions(transitions, listOfValidationErrorDTOs);
        Vector<Activity> noInputTransition = new Vector<Activity>();
        Vector<Activity> noOuputTransition = new Vector<Activity>();
        int numOfTopLevelActivities = topLevelActivities.size();
        for (Activity activity : topLevelActivities) {
            this.checkActivityForTransition(activity, numOfTopLevelActivities, listOfValidationErrorDTOs);
            if (activity.getTransitionFrom() == null) {
                noOuputTransition.add(activity);
            }
            if (activity.getTransitionTo() != null) continue;
            noInputTransition.add(activity);
        }
        if (numOfTopLevelActivities > 0) {
            if (noInputTransition.size() == 0) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("IT", this.messageService.getMessage("validation.error.inputTransitionType2")));
            }
            if (noInputTransition.size() > 1) {
                for (Activity a : noInputTransition) {
                    listOfValidationErrorDTOs.add(new ValidationErrorDTO("IT", this.messageService.getMessage("validation.error.inputTransitionType1"), a.getActivityUIID()));
                }
            }
            if (noOuputTransition.size() == 0) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("OT1", this.messageService.getMessage("validation.error.outputTransitionType2")));
            }
            if (noOuputTransition.size() > 1) {
                for (Activity a : noOuputTransition) {
                    listOfValidationErrorDTOs.add(new ValidationErrorDTO("OT1", this.messageService.getMessage("validation.error.outputTransitionType1"), a.getActivityUIID()));
                }
            }
        }
    }

    private void validateTransitions(Set transitions, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        for (Transition transition : transitions) {
            Activity fromActivity = transition.getFromActivity();
            Activity toActivity = transition.getToActivity();
            if (fromActivity == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("T", this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
                continue;
            }
            if (toActivity != null) continue;
            listOfValidationErrorDTOs.add(new ValidationErrorDTO("T", this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
        }
    }

    private void checkActivityForTransition(Activity activity, int numOfActivities, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        Transition inputTransition = activity.getTransitionTo();
        Transition outputTransition = activity.getTransitionFrom();
        if (numOfActivities > 1 && inputTransition == null && outputTransition == null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO("AT", this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
        if (numOfActivities == 1 && (inputTransition != null || outputTransition != null)) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO("AT", this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
    }

    private void validateGeneral(Set activities, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        for (Activity activity : activities) {
            this.checkIfGroupingRequired(activity, listOfValidationErrorDTOs);
            this.validateGroupingIfGroupingIsApplied(activity, listOfValidationErrorDTOs);
            this.validateOptionalActivity(activity, listOfValidationErrorDTOs);
            this.validateOptionsActivityOrderId(activity, listOfValidationErrorDTOs);
            this.validateGroupingActivity(activity, listOfValidationErrorDTOs);
            Vector<ValidationErrorDTO> activityErrors = activity.validateActivity(this.messageService);
            if (activityErrors == null || activityErrors.isEmpty()) continue;
            listOfValidationErrorDTOs.addAll(activityErrors);
        }
    }

    private void checkIfGroupingRequired(Activity activity, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        Grouping grouping;
        Integer groupingSupportType = activity.getGroupingSupportType();
        if (groupingSupportType == 3) {
            Grouping grouping2 = activity.getGrouping();
            if (grouping2 == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("GR", this.messageService.getMessage("validation.error.GroupingRequired"), activity.getActivityUIID()));
            }
        } else if (groupingSupportType == 1 && (grouping = activity.getGrouping()) != null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO("GNR", this.messageService.getMessage("validation.error.GroupingNotRequired"), activity.getActivityUIID()));
        }
    }

    private void validateOptionalActivity(Activity parentActivity, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        OptionsActivity optionsActivity;
        Set childActivities;
        int numOfChildActivities;
        if (parentActivity.isOptionsActivity() && (numOfChildActivities = (childActivities = (optionsActivity = (OptionsActivity)parentActivity).getActivities()).size()) == 0) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO("OA", this.messageService.getMessage("validation.error.OptionalActivity"), optionsActivity.getActivityUIID()));
        }
    }

    private void validateGroupingActivity(Activity activity, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        if (activity.isGroupingActivity()) {
            int maxNumGroups;
            GroupingActivity groupingActivity = (GroupingActivity)activity;
            Grouping grouping = groupingActivity.getCreateGrouping();
            if (grouping == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("GM", this.messageService.getMessage("validation.error.grouping.missing"), activity.getActivityUIID()));
            }
            Integer numGroupsInteger = null;
            if (grouping.isRandomGrouping()) {
                RandomGrouping random = (RandomGrouping)grouping;
                numGroupsInteger = random.getNumberOfGroups();
            } else {
                numGroupsInteger = grouping.getMaxNumberOfGroups();
            }
            int n = maxNumGroups = numGroupsInteger == null ? 0 : numGroupsInteger;
            if (grouping.getGroups() != null && grouping.getGroups().size() > maxNumGroups) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("GC", this.messageService.getMessage("validation.error.group.count.mismatch"), activity.getActivityUIID()));
            }
        }
    }

    private void validateOptionsActivityOrderId(Activity parentActivity, Vector listOfValidationErrorDTOs) {
        Integer thisActivityOrderId = null;
        Integer previousActivityOrderId = null;
        boolean validOrderId = true;
        if (parentActivity.isOptionsActivity()) {
            OptionsActivity optionsActivity = (OptionsActivity)parentActivity;
            Set childActivities = optionsActivity.getActivities();
            Iterator i = childActivities.iterator();
            while (i.hasNext() && validOrderId) {
                Activity childActivity = (Activity)i.next();
                thisActivityOrderId = childActivity.getOrderId();
                if (previousActivityOrderId != null) {
                    if (thisActivityOrderId == null) {
                        validOrderId = false;
                    } else if (thisActivityOrderId.longValue() != previousActivityOrderId.longValue() + 1L) {
                        validOrderId = false;
                    }
                } else if (thisActivityOrderId == null || thisActivityOrderId.longValue() != 1L) {
                    validOrderId = false;
                }
                previousActivityOrderId = thisActivityOrderId;
            }
            if (!validOrderId) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO("OAOI", this.messageService.getMessage("validation.error.OptionalActivityOrderId"), optionsActivity.getActivityUIID()));
            }
        }
    }

    private void validateGroupingIfGroupingIsApplied(Activity activity, Vector listOfValidationErrorDTOs) {
        if (activity.getApplyGrouping().booleanValue() && activity.getGrouping() == null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO("GS", this.messageService.getMessage("validation.error.GroupingSelected"), activity.getActivityUIID()));
        }
    }

    @Override
    public ArrayList<LearningLibraryDTO> getAllLearningLibraryDetails() throws IOException {
        return this.getAllLearningLibraryDetails(true);
    }

    @Override
    public ArrayList<LearningLibraryDTO> getAllLearningLibraryDetails(boolean valid) throws IOException {
        Iterator iterator = this.learningLibraryDAO.getAllLearningLibraries(valid).iterator();
        ArrayList<LearningLibraryDTO> libraries = new ArrayList<LearningLibraryDTO>();
        while (iterator.hasNext()) {
            LearningLibrary learningLibrary = (LearningLibrary)iterator.next();
            List templateActivities = this.activityDAO.getActivitiesByLibraryID(learningLibrary.getLearningLibraryId());
            if (templateActivities != null & templateActivities.size() == 0) {
                this.log.error((Object)("Learning Library with ID " + learningLibrary.getLearningLibraryId() + " does not have a template activity"));
            }
            LearningLibraryDTO libraryDTO = learningLibrary.getLearningLibraryDTO(templateActivities);
            this.internationaliseActivities(libraryDTO.getTemplateActivities());
            libraries.add(libraryDTO);
        }
        return libraries;
    }

    private void internationaliseActivities(Collection activities) {
        Iterator iter = activities.iterator();
        Locale locale = LocaleContextHolder.getLocale();
        if (this.log.isDebugEnabled()) {
            if (locale != null) {
                this.log.debug((Object)("internationaliseActivities: Locale has lang/country " + locale.getLanguage() + "," + locale.getCountry()));
            } else {
                this.log.debug((Object)"internationaliseActivities: Locale missing.");
            }
        }
        while (iter.hasNext()) {
            LibraryActivityDTO activity = (LibraryActivityDTO)iter.next();
            String languageFilename = activity.getLanguageFile();
            if (languageFilename != null) {
                MessageSource toolMessageSource = this.toolActMessageService.getMessageService(languageFilename);
                if (toolMessageSource != null) {
                    activity.setActivityTitle(toolMessageSource.getMessage("activity.title", null, activity.getActivityTitle(), locale));
                    activity.setDescription(toolMessageSource.getMessage("activity.description", null, activity.getDescription(), locale));
                    activity.setHelpText(toolMessageSource.getMessage("activity.helptext", null, activity.getHelpText(), locale));
                } else {
                    this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + " message file " + activity.getLanguageFile() + ". Activity Message source not available"));
                }
                if (activity.getActivityTypeID() == null || 1 != activity.getActivityTypeID()) continue;
                languageFilename = activity.getToolLanguageFile();
                toolMessageSource = this.toolActMessageService.getMessageService(languageFilename);
                if (toolMessageSource != null) {
                    activity.setToolDisplayName(toolMessageSource.getMessage("tool.display.name", null, activity.getToolDisplayName(), locale));
                    continue;
                }
                this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + " message file " + activity.getLanguageFile() + ". Tool Message source not available"));
                continue;
            }
            this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + ". No message file supplied."));
        }
    }
}

