/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.themes.CSSStyle;

public class CSSProperty
implements Serializable {
    private Long propertyId;
    private String name;
    private String value;
    private byte type;
    private String styleSubset;
    private CSSStyle style;

    public CSSProperty(Long propertyId, String name, String value, byte type, String styleSubset, CSSStyle style) {
        this.propertyId = propertyId;
        this.name = name;
        this.value = value;
        this.type = type;
        this.styleSubset = styleSubset;
        this.style = style;
    }

    public CSSProperty(String name, Object value, String styleSubset) {
        this.name = name;
        this.value = value != null ? value.toString() : null;
        this.type = this.getValueType(value);
        this.styleSubset = styleSubset;
    }

    public CSSProperty() {
    }

    public Long getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(Long propertyId) {
        this.propertyId = propertyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getStyleSubset() {
        return this.styleSubset;
    }

    public void setStyleSubset(String styleSubset) {
        this.styleSubset = styleSubset;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public void setStyle(CSSStyle style) {
        this.style = style;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("propertyId", (Object)this.getPropertyId()).append("name", (Object)this.name).append("value", (Object)this.value).append("type", this.type).append("styleSubset", (Object)this.styleSubset).toString();
    }

    public Object getValueAsObject() throws NumberFormatException, ParseException {
        if (this.value != null) {
            switch (this.getType()) {
                case 5: {
                    return Boolean.valueOf(this.value);
                }
                case 4: {
                    return this.getDate();
                }
                case 3: {
                    return Double.valueOf(this.value);
                }
                case 2: {
                    return Long.valueOf(this.value);
                }
            }
            return this.value;
        }
        return null;
    }

    protected byte getValueType(Object value) {
        if (value != null) {
            if (String.class.isInstance(value)) {
                return 1;
            }
            if (Boolean.class.isInstance(value)) {
                return 5;
            }
            if (Integer.class.isInstance(value) || Long.class.isInstance(value) || Short.class.isInstance(value) || BigInteger.class.isInstance(value)) {
                return 2;
            }
            if (Double.class.isInstance(value) || Float.class.isInstance(value) || BigDecimal.class.isInstance(value)) {
                return 3;
            }
            if (Calendar.class.isInstance(value) || Date.class.isInstance(value)) {
                return 4;
            }
        }
        return 1;
    }

    private Calendar getDate() throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat();
        Date date = df.parse(this.value);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }
}

