/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.dto;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.dto.CSSStyleDTO;
import org.lamsfoundation.lams.themes.dto.CSSVisualElementDTO;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

public class CSSThemeDTO
extends BaseDTO {
    protected Logger log = Logger.getLogger(CSSThemeDTO.class);
    public static final String ID_TAG = "id";
    public static final String NAME_TAG = "name";
    public static final String DESCRIPTION_TAG = "description";
    public static final String BASE_STYLE_OBJECT_TAG = "baseStyleObject";
    public static final String VISUAL_ELEMENTS_TAG = "visualElements";
    public static final String TEXT_FORMAT_TAG = "_tf";
    public static final String STYLE_OBJECT_TAG = "styleObject";
    private Long id;
    private String name;
    private String description;
    private CSSStyleDTO baseStyleObject;
    private List visualElements;

    public CSSThemeDTO(Hashtable wddxData) throws WDDXProcessorConversionException {
        if (wddxData != null) {
            List ve;
            this.id = WDDXProcessor.convertToLong(wddxData, ID_TAG);
            this.name = WDDXProcessor.convertToString(wddxData, NAME_TAG);
            this.description = WDDXProcessor.convertToString(wddxData, DESCRIPTION_TAG);
            Hashtable so = (Hashtable)wddxData.get(BASE_STYLE_OBJECT_TAG);
            if (so != null) {
                this.baseStyleObject = new CSSStyleDTO(so);
            }
            if ((ve = (List)wddxData.get(VISUAL_ELEMENTS_TAG)) != null) {
                int numElements = ve.size();
                this.visualElements = new ArrayList(numElements);
                Iterator iter = ve.iterator();
                while (iter.hasNext()) {
                    this.visualElements.add(new CSSVisualElementDTO((Hashtable)iter.next()));
                }
            }
        }
    }

    public CSSThemeDTO(CSSThemeVisualElement theme) {
        if (theme != null) {
            int numElements;
            this.id = theme.getId();
            this.name = theme.getName();
            this.description = theme.getDescription();
            if (theme.getStyle() != null) {
                this.baseStyleObject = new CSSStyleDTO(theme.getStyle());
            }
            if (theme.getElements() != null && (numElements = theme.getElements().size()) > 0) {
                this.visualElements = new ArrayList(numElements);
                for (CSSThemeVisualElement element : theme.getElements()) {
                    if (element.isTheme()) {
                        this.log.error((Object)("Theme found within another theme. Flash packet currently doesn't support this format.  Theme being skipped. " + element));
                        continue;
                    }
                    this.visualElements.add(new CSSVisualElementDTO(element));
                }
            }
        }
    }

    public CSSThemeVisualElement createCSSThemeVisualElement() {
        CSSThemeVisualElement theme = new CSSThemeVisualElement();
        if (this.baseStyleObject != null) {
            theme.setStyle(this.baseStyleObject.createNewCSSStyle());
        }
        theme.setDescription(this.description);
        theme.setName(this.name);
        theme.setId(this.id);
        theme.setTheme(true);
        if (this.visualElements != null && this.visualElements.size() > 0) {
            for (CSSVisualElementDTO element : this.visualElements) {
                theme.addElement(element.createCSSThemeVisualElement());
            }
        }
        return theme;
    }

    public CSSThemeVisualElement updateCSSTheme(CSSThemeVisualElement currentTheme) {
        if (this.baseStyleObject != null) {
            currentTheme.setStyle(this.baseStyleObject.createNewCSSStyle());
        } else {
            currentTheme.setStyle(null);
        }
        currentTheme.setDescription(this.description);
        currentTheme.setName(this.name);
        currentTheme.setId(this.id);
        currentTheme.clearElements();
        if (this.visualElements != null && this.visualElements.size() > 0) {
            for (CSSVisualElementDTO element : this.visualElements) {
                currentTheme.addElement(element.createCSSThemeVisualElement());
            }
        }
        return currentTheme;
    }

    public CSSStyleDTO getBaseStyleObject() {
        return this.baseStyleObject;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List getVisualElements() {
        return this.visualElements;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(ID_TAG, (Object)this.id).append(NAME_TAG, (Object)this.name).append(DESCRIPTION_TAG, (Object)this.description).append(BASE_STYLE_OBJECT_TAG, (Object)this.baseStyleObject).append(VISUAL_ELEMENTS_TAG, (Object)this.visualElements).toString();
    }
}

