/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool;

import java.util.Locale;
import java.util.SortedMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.util.ILoadedMessageSourceService;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutputFactory {
    protected Logger log = Logger.getLogger(OutputFactory.class);
    private MessageService toolMessageService;
    private ILoadedMessageSourceService loadedMessageSourceService;
    private String languageFilename;
    protected final String KEY_PREFIX = "output.desc.";

    public abstract SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Object var1) throws ToolException;

    public MessageService getToolMessageService() {
        return this.toolMessageService;
    }

    public void setToolMessageService(MessageService toolMessageService) {
        this.toolMessageService = toolMessageService;
    }

    public ILoadedMessageSourceService getLoadedMessageSourceService() {
        return this.loadedMessageSourceService;
    }

    public void setLoadedMessageSourceService(ILoadedMessageSourceService loadedMessageSourceService) {
        this.loadedMessageSourceService = loadedMessageSourceService;
    }

    public String getLanguageFilename() {
        return this.languageFilename;
    }

    public void setLanguageFilename(String languageFilename) {
        this.languageFilename = languageFilename;
    }

    protected String getDescription(String definitionName) {
        MessageSource msgSource = null;
        if (this.getToolMessageService() != null) {
            msgSource = this.getToolMessageService().getMessageSource();
        }
        if (msgSource == null && this.getLoadedMessageSourceService() != null && this.getLanguageFilename() != null) {
            msgSource = this.getLoadedMessageSourceService().getMessageService(this.getLanguageFilename());
        }
        if (msgSource == null) {
            this.log.warn((Object)("Unable to internationalise the description for the output definition " + definitionName + " as no MessageSource is available. " + "The tool's OutputDefinition factory needs to set either (a) messageSource or (b) loadedMessageSourceService and languageFilename."));
        }
        String description = null;
        if (msgSource != null) {
            String key = "output.desc." + definitionName;
            Locale locale = LocaleContextHolder.getLocale();
            try {
                description = msgSource.getMessage(key, null, locale);
            }
            catch (NoSuchMessageException e) {
                // empty catch block
            }
        }
        if (description == null || description.length() == 0) {
            description = definitionName.replace('.', ' ');
        }
        return description;
    }

    protected ToolOutputDefinition buildDefinition(String definitionName, OutputType type, Object startValue, Object endValue, Object complexValue) {
        ToolOutputDefinition definition = new ToolOutputDefinition();
        definition.setName(definitionName);
        definition.setDescription(this.getDescription(definitionName));
        definition.setType(type);
        definition.setStartValue(startValue);
        definition.setEndValue(endValue);
        definition.setComplexDefinition(complexValue);
        return definition;
    }

    protected ToolOutputDefinition buildRangeDefinition(String definitionName, Long startValue, Long endValue) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_LONG, startValue, endValue, null);
    }

    protected ToolOutputDefinition buildRangeDefinition(String definitionName, String startValue, String endValue) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_STRING, startValue, endValue, null);
    }

    protected ToolOutputDefinition buildLongOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_LONG, null, null, null);
    }

    protected ToolOutputDefinition buildDoubleOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_DOUBLE, null, null, null);
    }

    protected ToolOutputDefinition buildBooleanOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_BOOLEAN, null, null, null);
    }

    protected ToolOutputDefinition buildStringOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_STRING, null, null, null);
    }

    protected ToolOutputDefinition buildComplexOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_COMPLEX, null, null, null);
    }
}

