/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.util.HashUtil;

public class Authenticator {
    public static void authenticate(ExtServerOrgMap map, String datetime, String username, String method, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + method.toLowerCase().trim() + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticate(ExtServerOrgMap map, String datetime, String username, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticate(ExtServerOrgMap map, String datetime, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        String plaintext = datetime.toLowerCase().trim() + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    private static void checkHash(String plaintext, String hashValue) throws AuthenticationException {
        if (!hashValue.equals(HashUtil.sha1(plaintext))) {
            throw new AuthenticationException("Authentication failed!");
        }
    }
}

