/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.WorkspaceWorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTOFactory;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserManageBean;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagementService
implements IUserManagementService {
    private Logger log = Logger.getLogger(UserManagementService.class);
    private static final String SEQUENCES_FOLDER_NAME_KEY = "runsequences.folder.name";
    private IBaseDAO baseDAO;
    protected MessageService messageService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    @Override
    public void save(Object object) {
        try {
            User user;
            if (object instanceof User && (user = (User)object).getUserId() == null) {
                this.baseDAO.insertOrUpdate(user);
                object = this.createWorkspaceForUser(user);
            }
            this.baseDAO.insertOrUpdate(object);
        }
        catch (Exception e) {
            this.log.debug((Object)e);
        }
    }

    @Override
    public void saveAll(Collection objects) {
        for (Object o : objects) {
            if (!(o instanceof User)) continue;
            this.baseDAO.insertOrUpdate((User)o);
            User user = this.createWorkspaceForUser((User)o);
        }
        this.baseDAO.insertOrUpdateAll(objects);
    }

    @Override
    public void delete(Object object) {
        this.baseDAO.delete(object);
    }

    @Override
    public void deleteAll(Class clazz) {
        this.baseDAO.deleteAll(clazz);
    }

    @Override
    public void deleteAll(Collection objects) {
        this.baseDAO.deleteAll(objects);
    }

    @Override
    public void deleteById(Class clazz, Serializable id) {
        this.baseDAO.deleteById(clazz, id);
    }

    @Override
    public void deleteByProperty(Class clazz, String name, Object value) {
        this.baseDAO.deleteByProperty(clazz, name, value);
    }

    @Override
    public void deleteByProperties(Class clazz, Map<String, Object> properties) {
        this.baseDAO.deleteByProperties(clazz, properties);
    }

    @Override
    public void deleteAnythingLike(Object object) {
        this.baseDAO.deleteAnythingLike(object);
    }

    @Override
    public Object findById(Class clazz, Serializable id) {
        return this.baseDAO.find(clazz, id);
    }

    @Override
    public List findAll(Class clazz) {
        return this.baseDAO.findAll(clazz);
    }

    @Override
    public List findByProperty(Class clazz, String name, Object value) {
        return this.baseDAO.findByProperty(clazz, name, value);
    }

    @Override
    public List findByProperties(Class clazz, Map<String, Object> properties) {
        return this.baseDAO.findByProperties(clazz, properties);
    }

    @Override
    public List findAnythingLike(Object object) {
        return this.baseDAO.findAnythingLike(object);
    }

    @Override
    public List searchByStringProperties(Class clazz, Map<String, String> properties) {
        return this.baseDAO.searchByStringProperties(clazz, properties);
    }

    @Override
    public OrganisationDTO getOrganisationsForUserByRole(User user, List<String> restrictToRoleNames) {
        ArrayList<OrganisationDTO> list = new ArrayList<OrganisationDTO>();
        for (UserOrganisation userOrganisation : user.getUserOrganisations()) {
            OrganisationDTO dto;
            boolean aRoleFound = this.addRolesToDTO(restrictToRoleNames, userOrganisation, dto = userOrganisation.getOrganisation().getOrganisationDTO());
            if (!aRoleFound) continue;
            list.add(dto);
        }
        return OrganisationDTOFactory.createTree(list);
    }

    @Override
    public OrganisationDTO getOrganisationsForUserByRole(User user, List<String> restrictToRoleNames, Integer courseId, List<Integer> restrictToClassIds) {
        ArrayList<OrganisationDTO> dtolist = new ArrayList<OrganisationDTO>();
        Organisation org = (Organisation)this.baseDAO.find(Organisation.class, courseId);
        dtolist.add(org.getOrganisationDTO());
        this.getChildOrganisations(user, org, restrictToRoleNames, restrictToClassIds, dtolist);
        OrganisationDTO dtoTree = OrganisationDTOFactory.createTree(dtolist);
        Vector<OrganisationDTO> nodes = dtoTree.getNodes();
        return nodes.get(0);
    }

    private void getChildOrganisations(User user, Organisation org, List<String> restrictToRoleNames, List<Integer> restrictToClassIds, List<OrganisationDTO> dtolist) {
        if (org != null) {
            boolean notCheckClassId = restrictToClassIds == null || restrictToClassIds.size() == 0;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("user.userId", user.getUserId());
            map.put("organisation.parentOrganisation.organisationId", org.getOrganisationId());
            List childOrgs = this.baseDAO.findByProperties(UserOrganisation.class, map);
            for (UserOrganisation userOrganisation : childOrgs) {
                OrganisationDTO dto = userOrganisation.getOrganisation().getOrganisationDTO();
                if (!notCheckClassId && !restrictToClassIds.contains(dto.getOrganisationID())) continue;
                boolean aRoleFound = this.addRolesToDTO(restrictToRoleNames, userOrganisation, dto);
                if (aRoleFound) {
                    dtolist.add(dto);
                }
                Organisation childOrganisation = userOrganisation.getOrganisation();
                if (org.getChildOrganisations().size() <= 0) continue;
                this.getChildOrganisations(user, childOrganisation, restrictToRoleNames, restrictToClassIds, dtolist);
            }
        }
    }

    private boolean addRolesToDTO(List<String> restrictToRoleNames, UserOrganisation userOrganisation, OrganisationDTO dto) {
        Iterator iter = userOrganisation.getUserOrganisationRoles().iterator();
        boolean roleFound = false;
        while (iter.hasNext()) {
            UserOrganisationRole userOrganisationRole = (UserOrganisationRole)iter.next();
            String roleName = userOrganisationRole.getRole().getName();
            if (restrictToRoleNames != null && restrictToRoleNames.size() != 0 && !restrictToRoleNames.contains(roleName)) continue;
            dto.addRoleName(roleName);
            roleFound = true;
        }
        return roleFound;
    }

    @Override
    public OrganisationDTO getOrganisationForUserWithRole(User user, Integer organisationId) {
        if (user != null && organisationId != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("user.userId", user.getUserId());
            map.put("organisation.organisationId", organisationId);
            UserOrganisation userOrganisation = (UserOrganisation)this.baseDAO.findByProperties(UserOrganisation.class, map).get(0);
            OrganisationDTO dto = userOrganisation.getOrganisation().getOrganisationDTO();
            this.addRolesToDTO(null, userOrganisation, dto);
            return dto;
        }
        return null;
    }

    @Override
    public List<Role> getRolesForUserByOrganisation(User user, Integer orgId) {
        ArrayList<Role> list = new ArrayList<Role>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user.userId", user.getUserId());
        map.put("organisation.organisationId", orgId);
        UserOrganisation userOrg = (UserOrganisation)this.baseDAO.findByProperties(UserOrganisation.class, map).get(0);
        if (userOrg == null) {
            return null;
        }
        for (UserOrganisationRole userOrgRole : userOrg.getUserOrganisationRoles()) {
            list.add(userOrgRole.getRole());
        }
        return list;
    }

    @Override
    public List<User> getUsersFromOrganisation(Integer orgId) {
        ArrayList<User> list = new ArrayList<User>();
        for (UserOrganisation userOrganisation : this.baseDAO.findByProperty(UserOrganisation.class, "organisation.organisationId", orgId)) {
            list.add(userOrganisation.getUser());
        }
        return list;
    }

    @Override
    public Vector getUsersFromOrganisationByRole(Integer organisationID, String roleName, boolean isFlashCall) {
        Vector<Object> users = null;
        users = isFlashCall ? new Vector<Object>() : new Vector();
        Organisation organisation = (Organisation)this.baseDAO.find(Organisation.class, organisationID);
        if (organisation != null) {
            for (UserOrganisation userOrganisation : organisation.getUserOrganisations()) {
                for (UserOrganisationRole userOrganisationRole : userOrganisation.getUserOrganisationRoles()) {
                    if (!userOrganisationRole.getRole().getName().equals(roleName)) continue;
                    if (isFlashCall) {
                        users.add(userOrganisation.getUser().getUserFlashDTO());
                        continue;
                    }
                    users.add(userOrganisation.getUser().getUserDTO());
                }
            }
        }
        return users;
    }

    @Override
    public Organisation getRootOrganisation() {
        return (Organisation)this.baseDAO.findByProperty(Organisation.class, "organisationType.organisationTypeId", OrganisationType.ROOT_TYPE).get(0);
    }

    @Override
    public boolean isUserInRole(Integer userId, Integer orgId, String roleName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("userOrganisation.user.userId", userId);
        properties.put("userOrganisation.organisation.organisationId", orgId);
        properties.put("role.name", roleName);
        return this.baseDAO.findByProperties(UserOrganisationRole.class, properties).size() != 0;
    }

    @Override
    public List getOrganisationsByTypeAndStatus(Integer typeId, Integer stateId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("organisationType.organisationTypeId", typeId);
        properties.put("organisationState.organisationStateId", stateId);
        return this.baseDAO.findByProperties(Organisation.class, properties);
    }

    @Override
    public List getUserOrganisationRoles(Integer orgId, String login) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("userOrganisation.organisation.organisationId", orgId);
        properties.put("userOrganisation.user.login", login);
        return this.baseDAO.findByProperties(UserOrganisationRole.class, properties);
    }

    @Override
    public List getUserOrganisationsForUserByTypeAndStatus(String login, Integer typeId, Integer stateId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.login", login);
        properties.put("organisation.organisationType.organisationTypeId", typeId);
        properties.put("organisation.organisationState.organisationStateId", stateId);
        return this.baseDAO.findByProperties(UserOrganisation.class, properties);
    }

    @Override
    public User getUserByLogin(String login) {
        List results = this.baseDAO.findByProperty(User.class, "login", login);
        return results.isEmpty() ? null : (User)results.get(0);
    }

    @Override
    public void updatePassword(String login, String password) {
        try {
            User user = this.getUserByLogin(login);
            user.setPassword(HashUtil.sha1(password));
            this.baseDAO.update(user);
        }
        catch (Exception e) {
            this.log.debug((Object)e);
        }
    }

    @Override
    public UserOrganisation getUserOrganisation(Integer userId, Integer orgId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.userId", userId);
        properties.put("organisation.organisationId", orgId);
        List results = this.baseDAO.findByProperties(UserOrganisation.class, properties);
        return results.isEmpty() ? null : (UserOrganisation)results.get(0);
    }

    private User createWorkspaceForUser(User user) {
        Workspace workspace = new Workspace(user.getFullName());
        this.save(workspace);
        WorkspaceFolder folder = new WorkspaceFolder(workspace.getName(), user.getUserId(), new Date(), new Date(), WorkspaceFolder.NORMAL);
        this.save(folder);
        workspace.addFolder(folder);
        workspace.setDefaultFolder(folder);
        user.setWorkspace(workspace);
        return user;
    }

    public Workspace createWorkspaceForOrganisation(String workspaceName, Integer userID, Date createDateTime) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(workspaceName, userID, createDateTime, createDateTime, WorkspaceFolder.NORMAL);
        this.save(workspaceFolder);
        String description = this.messageService.getMessage(SEQUENCES_FOLDER_NAME_KEY, new Object[]{workspaceName});
        if (description != null && description.startsWith("???")) {
            this.log.warn((Object)"Problem in the language file - can't find an entry for runsequences.folder.name. Creating folder as \"run sequences\" ");
            description = "run sequences";
        }
        WorkspaceFolder workspaceFolder2 = new WorkspaceFolder(description, userID, createDateTime, createDateTime, WorkspaceFolder.RUN_SEQUENCES);
        workspaceFolder2.setParentWorkspaceFolder(workspaceFolder);
        this.save(workspaceFolder2);
        workspaceFolder.addChild(workspaceFolder2);
        this.save(workspaceFolder);
        Workspace workspace = new Workspace(workspaceName);
        workspace.setDefaultFolder(workspaceFolder);
        workspace.setDefaultRunSequencesFolder(workspaceFolder2);
        workspace.addFolder(workspaceFolder);
        workspace.addFolder(workspaceFolder2);
        this.save(workspace);
        return workspace;
    }

    @Override
    public Organisation saveOrganisation(Organisation organisation, Integer userID) {
        User creator = (User)this.findById(User.class, userID);
        if (organisation.getOrganisationId() == null) {
            Date createDateTime = new Date();
            organisation.setCreateDate(createDateTime);
            organisation.setCreatedBy(creator);
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
                Workspace workspace = this.createWorkspaceForOrganisation(organisation.getName(), userID, createDateTime);
                organisation.setWorkspace(workspace);
            }
            this.save(organisation);
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
                Vector managers = this.getUsersFromOrganisationByRole(organisation.getParentOrganisation().getOrganisationId(), "COURSE MANAGER", false);
                for (UserDTO m : managers) {
                    User user = (User)this.findById(User.class, m.getUserID());
                    UserOrganisation uo = new UserOrganisation(user, organisation);
                    this.log.debug((Object)("adding course manager: " + user.getUserId() + " as staff"));
                    UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
                    HashSet<UserOrganisationRole> uors = new HashSet<UserOrganisationRole>();
                    uors.add(uor);
                    uo.setUserOrganisationRoles(uors);
                    HashSet<UserOrganisation> uos = organisation.getUserOrganisations();
                    if (uos == null) {
                        uos = new HashSet<UserOrganisation>();
                    }
                    uos.add(uo);
                    organisation.setUserOrganisations(uos);
                    this.save(uo);
                }
            }
        }
        return organisation;
    }

    @Override
    public SupportedLocale getSupportedLocale(String language, String country) {
        List results;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("languageIsoCode", language);
        if (country != null) {
            properties.put("countryIsoCode", country);
        }
        return (results = this.findByProperties(SupportedLocale.class, properties)).isEmpty() ? null : (SupportedLocale)results.get(0);
    }

    @Override
    public List<UserManageBean> getUserManageBeans(Integer orgId) {
        String query = "select u.userId,u.login,u.title,u.firstName,u.lastName, r from User u left join u.userOrganisations as uo left join uo.userOrganisationRoles as uor left join uor.role as r where uo.organisation.organisationId=?";
        List list = this.baseDAO.find(query, (Object)orgId);
        HashMap<Integer, UserManageBean> beansMap = new HashMap<Integer, UserManageBean>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] data = (Object[])list.get(i);
            if (beansMap.containsKey(data[0])) {
                ((UserManageBean)beansMap.get(data[0])).getRoles().add((Role)data[5]);
                continue;
            }
            UserManageBean bean = new UserManageBean();
            bean.setUserId((Integer)data[0]);
            bean.setLogin((String)data[1]);
            bean.setTitle((String)data[2]);
            bean.setFirstName((String)data[3]);
            bean.setLastName((String)data[4]);
            bean.getRoles().add((Role)data[5]);
            beansMap.put((Integer)data[0], bean);
        }
        ArrayList<UserManageBean> userManageBeans = new ArrayList<UserManageBean>();
        userManageBeans.addAll(beansMap.values());
        return userManageBeans;
    }

    @Override
    public void removeUser(Integer userId) throws Exception {
        User user = (User)this.findById(User.class, userId);
        if (user != null) {
            if (this.userHasData(user).booleanValue()) {
                throw new Exception("Cannot remove User ID " + userId + ". User has data.");
            }
            Workspace workspace = user.getWorkspace();
            Set wwfs = workspace != null ? workspace.getWorkspaceWorkspaceFolders() : null;
            HashSet<WorkspaceFolder> foldersToDelete = new HashSet<WorkspaceFolder>();
            if (wwfs != null) {
                for (WorkspaceWorkspaceFolder wwf : wwfs) {
                    foldersToDelete.add(wwf.getWorkspaceFolder());
                    this.log.debug((Object)("deleting wkspc_wkspc_folder: " + wwf.getId()));
                    this.delete(wwf);
                }
            }
            for (WorkspaceFolder wf : foldersToDelete) {
                this.log.debug((Object)("deleting wkspc_folder: " + wf.getName()));
                this.delete(wf);
            }
            if (workspace != null) {
                this.log.debug((Object)("deleting workspace: " + workspace.getName()));
                this.delete(workspace);
            }
            this.log.debug((Object)("deleting user " + user.getLogin()));
            this.delete(user);
        } else {
            this.log.error((Object)("Requested delete of a user who does not exist. User ID " + userId));
        }
    }

    @Override
    public Boolean userHasData(User user) {
        if (user.getLearnerProgresses() != null && !user.getLearnerProgresses().isEmpty()) {
            this.log.debug((Object)("user has data, learnerProgresses: " + user.getLearnerProgresses().size()));
            return true;
        }
        if (user.getUserToolSessions() != null && !user.getUserToolSessions().isEmpty()) {
            this.log.debug((Object)("user has data, userToolSessions: " + user.getUserToolSessions().size()));
            return true;
        }
        if (user.getLearningDesigns() != null && !user.getLearningDesigns().isEmpty()) {
            this.log.debug((Object)("user has data, learningDesigns: " + user.getLearningDesigns().size()));
            return true;
        }
        if (user.getLessons() != null && !user.getLessons().isEmpty()) {
            this.log.debug((Object)("user has data, lessons: " + user.getLessons().size()));
            return true;
        }
        if (user.getUserGroups() != null && !user.getUserGroups().isEmpty()) {
            this.log.debug((Object)("user has data, userGroups: " + user.getUserGroups().size()));
            return true;
        }
        return false;
    }

    @Override
    public void disableUser(Integer userId) {
        User user = (User)this.findById(User.class, userId);
        user.setDisabledFlag(true);
        Set uos = user.getUserOrganisations();
        Iterator iter = uos.iterator();
        while (iter.hasNext()) {
            UserOrganisation uo = (UserOrganisation)iter.next();
            this.log.debug((Object)("removing membership of: " + uo.getOrganisation().getName()));
            this.delete(uo);
            iter.remove();
        }
        this.log.debug((Object)("disabling user " + user.getLogin()));
        this.save(user);
    }

    @Override
    public void setRolesForUserOrganisation(User user, Organisation org, List<String> rolesList) {
        UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo == null) {
            uo = new UserOrganisation(user, org);
            this.save(uo);
            this.log.debug((Object)("added " + user.getLogin() + " to " + org.getName()));
            Set uos = org.getUserOrganisations();
            uos.add(uo);
        }
        ArrayList<String> rolesCopy = new ArrayList<String>();
        rolesCopy.addAll(rolesList);
        this.log.debug((Object)("rolesList.size: " + rolesList.size()));
        HashSet<UserOrganisationRole> uors = uo.getUserOrganisationRoles();
        HashSet uorsCopy = new HashSet();
        if (uors != null) {
            uorsCopy.addAll(uors);
            for (String roleId : rolesList) {
                for (UserOrganisationRole uor : uors) {
                    if (!uor.getRole().getRoleId().toString().equals(roleId)) continue;
                    rolesCopy.remove(roleId);
                    uorsCopy.remove(uor);
                }
            }
            this.log.debug((Object)("removing roles: " + uorsCopy));
            uors.removeAll(uorsCopy);
        } else {
            uors = new HashSet<UserOrganisationRole>();
        }
        for (String roleId : rolesCopy) {
            UserOrganisationRole uor;
            Role role = (Role)this.findById(Role.class, Integer.valueOf(Integer.parseInt(roleId)));
            uor = new UserOrganisationRole(uo, role);
            this.save(uor);
            this.log.debug((Object)("setting role: " + role.getName()));
            uors.add(uor);
            if (!role.getName().equals("AUTHOR") || user.getWorkspace() != null) continue;
            this.createWorkspaceForUser(user);
        }
        uo.setUserOrganisationRoles(uors);
        this.save(user);
    }
}

