/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.zipfile;

import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

class OldZipDirectoryFilter
implements FileFilter {
    private long newestDateToKeep = 0L;
    private Logger log = null;

    public OldZipDirectoryFilter(long newestDateToKeep, Logger log) {
        this.newestDateToKeep = newestDateToKeep;
        this.log = log;
    }

    public boolean accept(File candidate) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking file " + candidate + " date modified " + candidate.lastModified()));
        }
        if (candidate.getName().startsWith("lamszip_")) {
            if (!candidate.isDirectory()) {
                this.log.debug((Object)"Candidate file is not is named as we expected, but it is not a directory. Skipping file.");
                return false;
            }
            return candidate.lastModified() < this.newestDateToKeep;
        }
        return false;
    }
}

