/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.IObjectExtractor;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.authoring.service.EditOnFlyProcessor;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignAccess;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IBranchActivityEntryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceDAO;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceMappingDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.LicenseDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.LearningDesignService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dto.ToolOutputDefinitionDTO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class AuthoringService
implements IAuthoringService,
BeanFactoryAware {
    protected Logger log = Logger.getLogger(AuthoringService.class);
    protected ILearningDesignDAO learningDesignDAO;
    protected ILearningLibraryDAO learningLibraryDAO;
    protected IActivityDAO activityDAO;
    protected IBaseDAO baseDAO;
    protected ITransitionDAO transitionDAO;
    protected IToolDAO toolDAO;
    protected ILicenseDAO licenseDAO;
    protected IGroupingDAO groupingDAO;
    protected IGroupDAO groupDAO;
    protected ICompetenceDAO competenceDAO;
    protected ICompetenceMappingDAO competenceMappingDAO;
    protected ISystemToolDAO systemToolDAO;
    protected PedagogicalPlannerDAO pedagogicalPlannerDAO;
    protected ILamsCoreToolService lamsCoreToolService;
    protected ILearningDesignService learningDesignService;
    protected MessageService messageService;
    protected ILessonService lessonService;
    protected IMonitoringService monitoringService;
    protected IWorkspaceManagementService workspaceManagementService;
    protected ILogEventService logEventService;
    protected IGradebookService gradebookService;
    protected ToolContentIDGenerator contentIDGenerator;
    protected BeanFactory beanFactory;
    protected IBranchActivityEntryDAO branchActivityEntryDAO;

    public void setPedagogicalPlannerDAO(PedagogicalPlannerDAO pedagogicalPlannerDAO) {
        this.pedagogicalPlannerDAO = pedagogicalPlannerDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setGroupDAO(IGroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setBranchActivityEntryDAO(IBranchActivityEntryDAO branchActivityEntryDAO) {
        this.branchActivityEntryDAO = branchActivityEntryDAO;
    }

    public ICompetenceDAO getCompetenceDAO() {
        return this.competenceDAO;
    }

    public void setCompetenceDAO(ICompetenceDAO competenceDAO) {
        this.competenceDAO = competenceDAO;
    }

    public ICompetenceMappingDAO getCompetenceMappingDAO() {
        return this.competenceMappingDAO;
    }

    public void setCompetenceMappingDAO(ICompetenceMappingDAO competenceMappingDAO) {
        this.competenceMappingDAO = competenceMappingDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setLicenseDAO(ILicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public ILamsCoreToolService getLamsCoreToolService() {
        return this.lamsCoreToolService;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    public ILearningDesignService getLearningDesignService() {
        return this.learningDesignService;
    }

    public void setLearningDesignService(ILearningDesignService learningDesignService) {
        this.learningDesignService = learningDesignService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public void setMonitoringService(IMonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }

    public void setGradebookService(IGradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public void setWorkspaceManagementService(IWorkspaceManagementService workspaceManagementService) {
        this.workspaceManagementService = workspaceManagementService;
    }

    public void setLogEventService(ILogEventService logEventService) {
        this.logEventService = logEventService;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    @Override
    public LearningDesign getLearningDesign(Long learningDesignID) {
        return this.learningDesignDAO.getLearningDesignById(learningDesignID);
    }

    @Override
    public void saveLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public static Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? learner.getUserID() : null;
    }

    @Override
    public List<ToolOutputDefinitionDTO> getToolOutputDefinitions(Long toolContentID, int definitionType) {
        SortedMap defns = this.lamsCoreToolService.getOutputDefinitionsFromTool(toolContentID, definitionType);
        ArrayList<ToolOutputDefinitionDTO> defnDTOList = new ArrayList<ToolOutputDefinitionDTO>(defns != null ? defns.size() : 0);
        if (defns != null) {
            for (ToolOutputDefinition defn : defns.values()) {
                defnDTOList.add(new ToolOutputDefinitionDTO(defn));
            }
        }
        return defnDTOList;
    }

    @Override
    public boolean setupEditOnFlyLock(Long learningDesignID, Integer userID) throws LearningDesignException, UserException, IOException {
        boolean learningDesignAvailable;
        LearningDesign design;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        LearningDesign learningDesign = design = learningDesignID == null ? null : this.getLearningDesign(learningDesignID);
        if (design == null) {
            throw new LearningDesignException("Learning Design was not found, ID: " + learningDesignID);
        }
        boolean bl = learningDesignAvailable = design.getEditOverrideUser() == null || design.getEditOverrideLock() == null || design.getEditOverrideUser().getUserId().equals(userID) || design.getEditOverrideLock() == false;
        if (learningDesignAvailable) {
            if (design.getLessons().isEmpty()) {
                throw new LearningDesignException("There are no lessons attached to the design.");
            }
            for (Lesson lesson : design.getLessons()) {
                lesson.setLockedForEdit(Boolean.valueOf(true));
                if (design.getEditOverrideUser() != null && design.getEditOverrideLock() != null && design.getEditOverrideLock().booleanValue()) continue;
                String message = this.messageService.getMessage("audit.live.edit.start", new Object[]{design.getTitle(), design.getLearningDesignId(), lesson.getLessonId(), user.getLogin(), user.getUserId()});
                this.logEventService.logEvent(Integer.valueOf(22), user.getUserId(), null, lesson.getLessonId(), null, message);
            }
            design.setEditOverrideLock(Boolean.valueOf(true));
            design.setEditOverrideUser(user);
            this.learningDesignDAO.update((Object)design);
            return true;
        }
        return false;
    }

    @Override
    public void setupEditOnFlyGate(Long learningDesignID, Integer userID) throws UserException, IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        LearningDesign design = learningDesignID == null ? null : this.getLearningDesign(learningDesignID);
        EditOnFlyProcessor processor = new EditOnFlyProcessor(design, this.activityDAO);
        processor.parseLearningDesign();
        Activity lastReadOnlyActivity = processor.lastReadOnlyActivity;
        if (lastReadOnlyActivity == null || !lastReadOnlyActivity.isGateActivity() || !((GateActivity)lastReadOnlyActivity).isSystemGate()) {
            this.addSystemGateAfterActivity(lastReadOnlyActivity, design);
            this.learningDesignDAO.update((Object)design);
        }
    }

    @Override
    public void finishEditOnFly(Long learningDesignID, Integer userID, boolean cancelled) throws Exception {
        LearningDesign design;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new IOException("User not found, ID: " + userID);
        }
        LearningDesign learningDesign = design = learningDesignID == null ? null : this.learningDesignDAO.getLearningDesignById(learningDesignID);
        if (design == null) {
            throw new IOException("Learning Design not found, ID: " + learningDesignID);
        }
        if (design.getEditOverrideUser().equals((Object)user)) {
            Long firstAddedActivityId;
            design.setEditOverrideLock(Boolean.valueOf(false));
            design.setEditOverrideUser(null);
            EditOnFlyProcessor processor = new EditOnFlyProcessor(design, this.activityDAO);
            processor.parseLearningDesign();
            Activity lastReadOnlyActivity = processor.lastReadOnlyActivity;
            Long l = firstAddedActivityId = processor.firstAddedActivity == null ? null : processor.firstAddedActivity.getActivityId();
            if (lastReadOnlyActivity != null && lastReadOnlyActivity.isGateActivity() && ((GateActivity)lastReadOnlyActivity).isSystemGate()) {
                design = this.removeTempSystemGate(lastReadOnlyActivity.getActivityId(), design.getLearningDesignId());
            }
            for (Lesson lesson : design.getLessons()) {
                lesson.setLockedForEdit(Boolean.valueOf(false));
                String message = this.messageService.getMessage("audit.live.edit.end", new Object[]{design.getTitle(), design.getLearningDesignId(), lesson.getLessonId(), user.getLogin(), user.getUserId()});
                this.logEventService.logEvent(Integer.valueOf(22), user.getUserId(), null, lesson.getLessonId(), null, message);
                if (!cancelled && firstAddedActivityId != null) {
                    this.lessonService.performMarkLessonUncompleted(lesson.getLessonId(), firstAddedActivityId);
                }
                this.initialiseToolActivityForRuntime(design, lesson);
                this.learningDesignDAO.update((Object)design);
                this.gradebookService.recalculateTotalMarksForLesson(lesson.getLessonId());
            }
        }
    }

    private LearningDesign removeTempSystemGate(Long gateId, Long learningDesignId) {
        LearningDesign design = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        Transition toTransition = gate.getTransitionTo();
        Transition fromTransition = gate.getTransitionFrom();
        if (toTransition != null && fromTransition != null) {
            toTransition.setToActivity(fromTransition.getToActivity());
            fromTransition.getToActivity().setTransitionTo(toTransition);
            toTransition.setToUIID(toTransition.getToActivity().getActivityUIID());
            design.getTransitions().remove(fromTransition);
            this.transitionDAO.update((Object)toTransition);
        } else if (toTransition != null && fromTransition == null) {
            toTransition.getFromActivity().setTransitionFrom(null);
            design.getTransitions().remove(toTransition);
        } else if (toTransition == null && fromTransition != null) {
            design.setFirstActivity(fromTransition.getToActivity());
            fromTransition.getToActivity().setTransitionTo(null);
            design.getTransitions().remove(fromTransition);
        }
        this.lessonService.removeProgressReferencesToActivity((Activity)gate);
        design.getActivities().remove(gate);
        gate.setTransitionFrom(null);
        gate.setTransitionTo(null);
        design.setDesignVersion(Integer.valueOf(design.getDesignVersion() + 1));
        return design;
    }

    private void addSystemGateAfterActivity(Activity activity, LearningDesign design) {
        GateActivity gate = null;
        Integer maxId = design.getMaxID();
        String title = "System Gate";
        SystemTool systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.SYSTEM_GATE);
        gate = (GateActivity)Activity.getActivityInstance((int)9);
        gate.setActivityTypeId(Integer.valueOf(9));
        gate.setActivityCategoryID(Integer.valueOf(1));
        gate.setSystemTool(systemTool);
        maxId = maxId + 1;
        gate.setActivityUIID(maxId);
        gate.setTitle(title);
        gate.setGateOpen(Boolean.valueOf(false));
        gate.setGateActivityLevelId(Integer.valueOf(1));
        gate.setApplyGrouping(Boolean.valueOf(false));
        gate.setGroupingSupportType(Integer.valueOf(2));
        gate.setOrderId(null);
        gate.setCreateDateTime(new Date());
        gate.setReadOnly(Boolean.TRUE);
        gate.setLearningDesign(design);
        design.getActivities().add(gate);
        this.baseDAO.insert((Object)gate);
        Transition fromTransition = null;
        Activity toActivity = null;
        Transition newTransition = new Transition();
        maxId = maxId + 1;
        newTransition.setTransitionUIID(maxId);
        newTransition.setLearningDesign(design);
        if (activity == null) {
            Integer x2;
            toActivity = design.getFirstActivity();
            newTransition.setToActivity(toActivity);
            newTransition.setToUIID(toActivity.getActivityUIID());
            newTransition.setFromActivity((Activity)gate);
            newTransition.setFromUIID(gate.getActivityUIID());
            gate.setTransitionFrom(newTransition);
            toActivity.setTransitionTo(newTransition);
            design.setFirstActivity((Activity)gate);
            Integer x1 = toActivity.getXcoord() == null ? 0 : toActivity.getXcoord();
            Integer n = x2 = toActivity.getTransitionFrom() == null ? null : toActivity.getTransitionFrom().getToActivity().getXcoord();
            if (x1 != null && x2 != null) {
                gate.setXcoord(Integer.valueOf(x2 >= x1 ? x1 - 13 - 20 : x1 + 123 + 13 + 20));
            } else {
                gate.setXcoord(Integer.valueOf(x1 - 13 - 20));
            }
            gate.setYcoord(Integer.valueOf(toActivity.getYcoord() + 25));
        } else {
            fromTransition = activity.getTransitionFrom();
            if (fromTransition == null) {
                Integer x2;
                newTransition.setFromActivity(activity);
                newTransition.setFromUIID(activity.getActivityUIID());
                newTransition.setToActivity((Activity)gate);
                newTransition.setToUIID(gate.getActivityUIID());
                activity.setTransitionFrom(newTransition);
                gate.setTransitionTo(newTransition);
                Integer x1 = activity.getTransitionTo() == null ? 0 : activity.getTransitionTo().getFromActivity().getXcoord();
                Integer n = x2 = activity.getXcoord() == null ? null : activity.getXcoord();
                if (x1 != null && x2 != null) {
                    gate.setXcoord(Integer.valueOf(x2 >= x1 ? x2 + 123 + 13 + 20 : x2 - 13 - 20));
                } else {
                    gate.setXcoord(Integer.valueOf(x2 + 123 + 13 + 20));
                }
                gate.setYcoord(Integer.valueOf(activity.getYcoord() + 25));
            } else {
                BranchingActivity branchingActivity;
                toActivity = fromTransition.getToActivity();
                fromTransition.setToActivity((Activity)gate);
                fromTransition.setToUIID(gate.getActivityUIID());
                newTransition.setFromActivity((Activity)gate);
                newTransition.setFromUIID(gate.getActivityUIID());
                newTransition.setToActivity(toActivity);
                newTransition.setToUIID(toActivity.getActivityUIID());
                gate.setTransitionFrom(newTransition);
                toActivity.setTransitionTo(newTransition);
                gate.setTransitionTo(fromTransition);
                Integer x1 = null;
                Integer x2 = null;
                Integer y1 = null;
                Integer y2 = null;
                if (activity.isBranchingActivity()) {
                    branchingActivity = (BranchingActivity)activity;
                    x1 = branchingActivity.getEndXcoord();
                    y1 = branchingActivity.getEndYcoord();
                } else {
                    x1 = activity.getXcoord() == null ? 0 : activity.getXcoord();
                    y1 = activity.getYcoord() == null ? 0 : activity.getYcoord();
                }
                if (toActivity.isBranchingActivity()) {
                    branchingActivity = (BranchingActivity)this.activityDAO.getActivityByActivityId(toActivity.getActivityId());
                    x2 = branchingActivity.getEndXcoord();
                    y2 = branchingActivity.getEndYcoord();
                } else {
                    x2 = toActivity.getXcoord() == null ? 0 : toActivity.getXcoord();
                    y2 = toActivity.getYcoord() == null ? 0 : toActivity.getYcoord();
                }
                gate.setXcoord(Integer.valueOf((x1 + 123 + x2) / 2 - 13));
                gate.setYcoord(Integer.valueOf((y1 + 50 + y2) / 2));
            }
        }
        design.getTransitions().add(newTransition);
        design.setMaxID(maxId);
        design.setDesignVersion(Integer.valueOf(design.getDesignVersion() + 1));
        if (gate != null) {
            this.activityDAO.update((Object)gate);
        }
        if (activity != null) {
            this.activityDAO.update((Object)activity);
        }
        if (toActivity != null) {
            this.activityDAO.update((Object)toActivity);
        }
        if (fromTransition != null) {
            this.baseDAO.update((Object)fromTransition);
        }
        this.baseDAO.insert((Object)newTransition);
        this.learningDesignDAO.update((Object)design);
    }

    private void initialiseToolActivityForRuntime(LearningDesign design, Lesson lesson) throws MonitoringServiceException {
        Date now = new Date();
        for (Activity activity : design.getActivities()) {
            if (activity.isInitialised().booleanValue()) continue;
            if (activity.isToolActivity()) {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                Long newContentId = this.lamsCoreToolService.notifyToolToCopyContent(toolActivity, null);
                toolActivity.setToolContentId(newContentId);
            } else {
                Integer newMaxId = this.monitoringService.startSystemActivity(activity, design.getMaxID(), now, lesson.getLessonName());
                if (newMaxId != null) {
                    design.setMaxID(newMaxId);
                }
            }
            activity.setInitialised(Boolean.TRUE);
            this.activityDAO.update((Object)activity);
        }
        this.learningDesignDAO.update((Object)design);
    }

    @Override
    public LearningDesign copyLearningDesign(Long originalDesignID, Integer copyType, Integer userID, Integer workspaceFolderID, boolean setOriginalDesign) throws UserException, LearningDesignException, WorkspaceFolderException, IOException {
        LearningDesign originalDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (originalDesign == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{originalDesignID}));
        }
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
        if (workspaceFolder == null) {
            throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace.exist", new Object[]{workspaceFolderID}));
        }
        if (!this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(workspaceFolder.getWorkspaceFolderId(), user.getUserId())) {
            throw new UserAccessDeniedException("User with user_id of " + user.getUserId() + " is not authorized to copy a learning design into the workspace folder " + workspaceFolder.getWorkspaceFolderId());
        }
        return this.copyLearningDesign(originalDesign, copyType, user, workspaceFolder, setOriginalDesign, null, null);
    }

    @Override
    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user, WorkspaceFolder workspaceFolder, boolean setOriginalDesign, String newDesignName, String customCSV) {
        String newTitle = newDesignName;
        if (newTitle == null) {
            newTitle = this.getUniqueNameForLearningDesign(originalLearningDesign.getTitle(), workspaceFolder != null ? workspaceFolder.getWorkspaceFolderId() : null);
        }
        LearningDesign newLearningDesign = LearningDesign.createLearningDesignCopy((LearningDesign)originalLearningDesign, (Integer)copyType, (boolean)setOriginalDesign);
        newLearningDesign.setTitle(newTitle);
        newLearningDesign.setUser(user);
        newLearningDesign.setWorkspaceFolder(workspaceFolder);
        newLearningDesign.setEditOverrideLock(Boolean.valueOf(false));
        this.learningDesignDAO.insert((Object)newLearningDesign);
        this.updateDesignCompetences(originalLearningDesign, newLearningDesign, false);
        HashMap<Integer, Activity> newActivities = this.updateDesignActivities(originalLearningDesign, newLearningDesign, 0, customCSV);
        this.updateDesignTransitions(originalLearningDesign, newLearningDesign, newActivities, 0);
        newLearningDesign.setFirstActivity(newLearningDesign.calculateFirstActivity());
        newLearningDesign.setFloatingActivity(newLearningDesign.calculateFloatingActivity());
        newLearningDesign.setLearningDesignUIID(originalLearningDesign.getLearningDesignUIID());
        this.updateCompetenceMappings(newLearningDesign.getCompetences(), newActivities);
        try {
            File sourceSVG = new File(LearningDesignService.getLearningDesignSVGPath((long)originalLearningDesign.getLearningDesignId()));
            if (sourceSVG.canRead()) {
                FileUtils.copyFile((File)sourceSVG, (File)new File(LearningDesignService.getLearningDesignSVGPath((long)newLearningDesign.getLearningDesignId())), (boolean)false);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Error while copying Learning Design " + originalLearningDesign.getLearningDesignId() + " image"), (Throwable)e);
        }
        return newLearningDesign;
    }

    @Override
    public LearningDesign insertLearningDesign(Long originalDesignID, Long designToImportID, Integer userID, boolean createNewLearningDesign, String newDesignName, Integer workspaceFolderID, String customCSV) throws UserException, WorkspaceFolderException, IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        LearningDesign mainDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (mainDesign == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{originalDesignID}));
        }
        LearningDesign designToImport = this.learningDesignDAO.getLearningDesignById(designToImportID);
        if (designToImport == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{designToImportID}));
        }
        if (createNewLearningDesign) {
            WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
            if (workspaceFolder == null) {
                throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace.exist", new Object[]{workspaceFolderID}));
            }
            if (!this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(workspaceFolder.getWorkspaceFolderId(), user.getUserId())) {
                throw new UserAccessDeniedException("User with user_id of " + user.getUserId() + " is not authorized to store a copy a learning design into the workspace folder " + workspaceFolder);
            }
            mainDesign = this.copyLearningDesign(mainDesign, 1, user, workspaceFolder, false, newDesignName, customCSV);
        } else {
            boolean authorised = this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(mainDesign.getWorkspaceFolder().getWorkspaceFolderId(), user.getUserId());
            if (!authorised) {
                boolean bl = authorised = mainDesign.getEditOverrideLock() != null && mainDesign.getEditOverrideLock() != false && userID.equals(mainDesign.getEditOverrideUser().getUserId());
            }
            if (!authorised) {
                throw new UserAccessDeniedException("User with user_id of " + user.getUserId() + " is not authorized to update a learning design into the workspace folder " + mainDesign.getWorkspaceFolder());
            }
        }
        int uiidOffset = mainDesign.getMaxID();
        this.updateDesignCompetences(designToImport, mainDesign, true);
        HashMap<Integer, Activity> newActivities = this.updateDesignActivities(designToImport, mainDesign, uiidOffset, customCSV);
        this.updateDesignTransitions(designToImport, mainDesign, newActivities, uiidOffset);
        mainDesign.setMaxID(LearningDesign.addOffset((Integer)designToImport.getMaxID(), (int)uiidOffset));
        mainDesign.setValidDesign(Boolean.FALSE);
        mainDesign.setLastModifiedDateTime(new Date());
        this.learningDesignDAO.update((Object)mainDesign);
        this.insertCompetenceMappings(mainDesign.getCompetences(), designToImport.getCompetences(), newActivities);
        return mainDesign;
    }

    private LearningDesign copyLearningDesignToolContent(LearningDesign design, LearningDesign originalLearningDesign, Integer copyType, String customCSV) throws LearningDesignException {
        for (Activity currentActivity : design.getActivities()) {
            if (!currentActivity.isToolActivity()) continue;
            this.copyActivityToolContent(currentActivity, design.getCopyTypeID(), originalLearningDesign.getLearningDesignId(), customCSV);
        }
        return design;
    }

    private void copyActivityToolContent(Activity activity, Integer ldCopyType, Long originalLearningDesignId, String customCSV) {
        try {
            ToolActivity toolActivity = (ToolActivity)activity;
            Long newContentId = this.lamsCoreToolService.notifyToolToCopyContent(toolActivity, customCSV);
            toolActivity.setToolContentId(newContentId);
            toolActivity.setReadOnly(Boolean.valueOf(false));
        }
        catch (DataMissingException e) {
            String error = "Unable to copy a design / initialise the lesson. Data is missing for activity " + activity.getActivityUIID() + " in learning design " + originalLearningDesignId + " default content may be missing for the tool. Error was " + e.getMessage();
            this.log.error((Object)error, (Throwable)e);
            throw new LearningDesignException(error, (Throwable)e);
        }
        catch (ToolException e) {
            String error = "Unable to copy a design / initialise the lesson. Tool encountered an error copying the data is missing for activity " + activity.getActivityUIID() + " in learning design " + originalLearningDesignId + " default content may be missing for the tool. Error was " + e.getMessage();
            this.log.error((Object)error, (Throwable)e);
            throw new LearningDesignException(error, (Throwable)e);
        }
    }

    private HashMap<Integer, Activity> updateDesignActivities(LearningDesign originalLearningDesign, LearningDesign newLearningDesign, int uiidOffset, String customCSV) {
        HashMap<Integer, Activity> newActivities = new HashMap<Integer, Activity>();
        HashMap<Integer, Grouping> newGroupings = new HashMap<Integer, Grouping>();
        HashMap firstChildUIIDToSequence = new HashMap();
        HashSet oldParentActivities = originalLearningDesign.getParentActivities();
        if (oldParentActivities != null) {
            Iterator iterator = oldParentActivities.iterator();
            while (iterator.hasNext()) {
                this.processActivity((Activity)iterator.next(), newLearningDesign, newActivities, newGroupings, null, originalLearningDesign.getLearningDesignId(), uiidOffset, customCSV);
            }
        }
        Collection activities = newActivities.values();
        for (Activity activity : activities) {
            if (activity.getGroupingUIID() == null) continue;
            activity.setGrouping(newGroupings.get(activity.getGroupingUIID()));
        }
        for (Activity activity : activities) {
            SequenceActivity newSequenceActivity;
            ComplexActivity newComplex;
            Activity oldDefaultActivity;
            if (activity.isComplexActivity() && (oldDefaultActivity = (newComplex = (ComplexActivity)activity).getDefaultActivity()) != null) {
                Activity newDefaultActivity = newActivities.get(LearningDesign.addOffset((Integer)oldDefaultActivity.getActivityUIID(), (int)uiidOffset));
                newComplex.setDefaultActivity(newDefaultActivity);
            }
            if (activity.isSequenceActivity() && (newSequenceActivity = (SequenceActivity)activity).getBranchEntries() != null && newSequenceActivity.getBranchEntries().size() > 0) {
                Activity parentActivity = newSequenceActivity.getParentActivity();
                if (parentActivity.isChosenBranchingActivity()) {
                    newSequenceActivity.getBranchEntries().clear();
                } else {
                    for (BranchActivityEntry entry : newSequenceActivity.getBranchEntries()) {
                        Grouping oldGrouping;
                        Grouping newGrouping;
                        BranchingActivity oldBranchingActivity = (BranchingActivity)entry.getBranchingActivity();
                        entry.setBranchingActivity(newActivities.get(LearningDesign.addOffset((Integer)oldBranchingActivity.getActivityUIID(), (int)uiidOffset)));
                        Group oldGroup = entry.getGroup();
                        if (oldGroup == null || (newGrouping = newGroupings.get(LearningDesign.addOffset((Integer)(oldGrouping = oldGroup.getGrouping()).getGroupingUIID(), (int)uiidOffset))) == null) continue;
                        entry.setGroup(newGrouping.getGroup(LearningDesign.addOffset((Integer)oldGroup.getGroupUIID(), (int)uiidOffset)));
                    }
                }
            }
            if (activity.getInputActivities() == null || activity.getInputActivities().size() <= 0) continue;
            HashSet<Activity> newInputActivities = new HashSet<Activity>();
            for (Activity elem : activity.getInputActivities()) {
                newInputActivities.add(newActivities.get(LearningDesign.addOffset((Integer)elem.getActivityUIID(), (int)uiidOffset)));
            }
            activity.getInputActivities().clear();
            activity.getInputActivities().addAll(newInputActivities);
        }
        if (uiidOffset == 0) {
            newLearningDesign.getActivities().clear();
        }
        newLearningDesign.getActivities().addAll(activities);
        for (Activity activity : activities) {
            if (!activity.isBranchingActivity()) continue;
            this.activityDAO.insert((Object)activity);
        }
        return newActivities;
    }

    private void processActivity(Activity activity, LearningDesign newLearningDesign, Map<Integer, Activity> newActivities, Map<Integer, Grouping> newGroupings, Activity parentActivity, Long originalLearningDesignId, int uiidOffset, String customCSV) {
        HashSet oldChildActivities;
        Activity newActivity = this.getActivityCopy(activity, newGroupings, uiidOffset);
        newActivity.setActivityUIID(newActivity.getActivityUIID());
        newActivity.setLearningDesign(newLearningDesign);
        newActivity.setReadOnly(Boolean.valueOf(false));
        if (parentActivity != null) {
            newActivity.setParentActivity(parentActivity);
            newActivity.setParentUIID(parentActivity.getActivityUIID());
            ((ComplexActivity)parentActivity).getActivities().add(newActivity);
        }
        if (!newActivity.isFloatingActivity() || newLearningDesign.getFloatingActivity() == null) {
            newActivities.put(newActivity.getActivityUIID(), newActivity);
        }
        if (newActivity.isToolActivity()) {
            this.copyActivityToolContent(newActivity, newLearningDesign.getCopyTypeID(), originalLearningDesignId, customCSV);
        }
        if ((oldChildActivities = this.getChildActivities(activity)) != null) {
            for (Activity childActivity : oldChildActivities) {
                FloatingActivity fParentActivity = null;
                Activity refParentActivity = null;
                if (childActivity.isFloating() && newLearningDesign.getFloatingActivity() != null) {
                    fParentActivity = newLearningDesign.getFloatingActivity();
                } else {
                    refParentActivity = newActivity;
                }
                if (childActivity.isFloating() && fParentActivity != null) {
                    childActivity.setOrderId(Integer.valueOf(fParentActivity.getActivities().size() + childActivity.getOrderId() + 1));
                }
                FloatingActivity pActivity = fParentActivity != null ? fParentActivity : refParentActivity;
                this.processActivity(childActivity, newLearningDesign, newActivities, newGroupings, (Activity)pActivity, originalLearningDesignId, uiidOffset, customCSV);
            }
        }
    }

    public void updateDesignTransitions(LearningDesign originalLearningDesign, LearningDesign newLearningDesign, HashMap<Integer, Activity> newActivities, int uiidOffset) {
        HashSet<Transition> newTransitions = new HashSet<Transition>();
        Set oldTransitions = originalLearningDesign.getTransitions();
        for (Transition transition : oldTransitions) {
            Transition newTransition = Transition.createCopy((Transition)transition, (int)uiidOffset);
            Activity toActivity = null;
            Activity fromActivity = null;
            if (newTransition.getToUIID() != null) {
                toActivity = newActivities.get(newTransition.getToUIID());
                if (transition.isProgressTransition()) {
                    toActivity.setTransitionTo(newTransition);
                }
            }
            if (newTransition.getFromUIID() != null) {
                fromActivity = newActivities.get(newTransition.getFromUIID());
                if (transition.isProgressTransition()) {
                    fromActivity.setTransitionFrom(newTransition);
                }
            }
            newTransition.setToActivity(toActivity);
            newTransition.setFromActivity(fromActivity);
            newTransition.setLearningDesign(newLearningDesign);
            this.transitionDAO.insert((Object)newTransition);
            newTransitions.add(newTransition);
        }
        if (newLearningDesign.getTransitions() != null) {
            if (uiidOffset == 0) {
                newLearningDesign.getTransitions().clear();
            }
            newLearningDesign.getTransitions().addAll(newTransitions);
        } else {
            newLearningDesign.setTransitions(newTransitions);
        }
    }

    public void updateDesignCompetences(LearningDesign originalLearningDesign, LearningDesign newLearningDesign, boolean insert) {
        HashSet<Competence> newCompeteces = new HashSet<Competence>();
        Set oldCompetences = originalLearningDesign.getCompetences();
        if (oldCompetences != null) {
            for (Competence competence : oldCompetences) {
                Competence newCompetence = competence.createCopy(competence);
                newCompetence.setLearningDesign(newLearningDesign);
                if (this.competenceDAO.getCompetence(newLearningDesign, newCompetence.getTitle()) == null) {
                    this.competenceDAO.saveOrUpdate(newCompetence);
                }
                newCompeteces.add(newCompetence);
            }
        }
        if (newLearningDesign.getCompetences() != null) {
            if (!insert) {
                newLearningDesign.getCompetences().clear();
                newLearningDesign.getCompetences().addAll(newCompeteces);
            } else {
                for (Competence newCompetence : newCompeteces) {
                    boolean alreadyExistsInLD = false;
                    for (Competence existingCompetence : originalLearningDesign.getCompetences()) {
                        if (!newCompetence.getTitle().equals(existingCompetence.getTitle())) continue;
                        alreadyExistsInLD = true;
                        break;
                    }
                    if (alreadyExistsInLD) continue;
                    newLearningDesign.getCompetences().add(newCompetence);
                }
            }
        } else {
            newLearningDesign.setCompetences(newCompeteces);
        }
    }

    public void insertCompetenceMappings(Set<Competence> oldCompetences, Set<Competence> newCompetences, HashMap<Integer, Activity> newActivities) {
        for (Integer activityKey : newActivities.keySet()) {
            Activity activity = newActivities.get(activityKey);
            if (!activity.isToolActivity()) continue;
            HashSet<CompetenceMapping> newCompetenceMappings = new HashSet<CompetenceMapping>();
            ToolActivity newToolActivity = (ToolActivity)activity;
            if (newToolActivity.getCompetenceMappings() != null) {
                for (CompetenceMapping competenceMapping : newToolActivity.getCompetenceMappings()) {
                    CompetenceMapping newMapping = new CompetenceMapping();
                    newMapping.setToolActivity(newToolActivity);
                    if (oldCompetences != null && oldCompetences.size() > 0 && this.getCompetenceFromSet(oldCompetences, competenceMapping.getCompetence().getTitle()) != null) {
                        newMapping.setCompetence(this.getCompetenceFromSet(oldCompetences, competenceMapping.getCompetence().getTitle()));
                        this.competenceMappingDAO.insert(newMapping);
                        newCompetenceMappings.add(newMapping);
                        continue;
                    }
                    if (newCompetences == null || newCompetences.size() <= 0 || this.getCompetenceFromSet(newCompetences, competenceMapping.getCompetence().getTitle()) == null) continue;
                    newMapping.setCompetence(this.getCompetenceFromSet(newCompetences, competenceMapping.getCompetence().getTitle()));
                    this.competenceMappingDAO.insert(newMapping);
                    newCompetenceMappings.add(newMapping);
                }
            }
            newToolActivity.getCompetenceMappings().addAll(newCompetenceMappings);
        }
    }

    public Competence getCompetenceFromSet(Set<Competence> competences, String title) {
        Competence ret = null;
        for (Competence competence : competences) {
            if (!competence.getTitle().equals(title)) continue;
            ret = competence;
            break;
        }
        return ret;
    }

    public void updateCompetenceMappings(Set<Competence> newCompetences, HashMap<Integer, Activity> newActivities) {
        for (Integer activityKey : newActivities.keySet()) {
            Activity activity = newActivities.get(activityKey);
            if (!activity.isToolActivity()) continue;
            HashSet<CompetenceMapping> newCompetenceMappings = new HashSet<CompetenceMapping>();
            ToolActivity newToolActivity = (ToolActivity)activity;
            if (newToolActivity.getCompetenceMappings() != null) {
                for (CompetenceMapping competenceMapping : newToolActivity.getCompetenceMappings()) {
                    CompetenceMapping newMapping = new CompetenceMapping();
                    if (newCompetences == null) continue;
                    for (Competence newCompetence : newCompetences) {
                        if (!competenceMapping.getCompetence().getTitle().equals(newCompetence.getTitle())) continue;
                        newMapping.setToolActivity(newToolActivity);
                        newMapping.setCompetence(newCompetence);
                        this.competenceMappingDAO.insert(newMapping);
                        newCompetenceMappings.add(newMapping);
                    }
                }
            }
            newToolActivity.getCompetenceMappings().addAll(newCompetenceMappings);
        }
    }

    private Activity getActivityCopy(Activity activity, Map<Integer, Grouping> newGroupings, int uiidOffset) {
        if (2 == activity.getActivityTypeId()) {
            GroupingActivity newGroupingActivity = (GroupingActivity)activity.createCopy(uiidOffset);
            Grouping grouping = newGroupingActivity.getCreateGrouping();
            grouping.setGroupingUIID(grouping.getGroupingUIID());
            if (grouping != null) {
                this.groupingDAO.insert((Object)grouping);
                newGroupings.put(grouping.getGroupingUIID(), grouping);
            }
            return newGroupingActivity;
        }
        return activity.createCopy(uiidOffset);
    }

    private HashSet getChildActivities(Activity parentActivity) {
        HashSet childActivities = new HashSet();
        List list = this.activityDAO.getActivitiesByParentActivityId(parentActivity.getActivityId());
        if (list != null) {
            childActivities.addAll(list);
        }
        return childActivities;
    }

    @Override
    public LearningDesign saveLearningDesignDetails(ObjectNode ldJSON) throws UserException, WorkspaceFolderException, ObjectExtractorException, ParseException {
        Long learningDesignId;
        LearningDesign existingLearningDesign;
        User user = null;
        Integer userID = AuthoringService.getUserId();
        if (userID != null) {
            user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        }
        if (user == null) {
            throw new UserException("UserID missing or user not found.");
        }
        Integer workspaceFolderID = JsonUtil.optInt((JsonNode)ldJSON, (String)"workspaceFolderID");
        WorkspaceFolder workspaceFolder = null;
        boolean authorised = false;
        if (workspaceFolderID != null) {
            workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
            authorised = this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(workspaceFolderID, userID);
        }
        LearningDesign learningDesign = existingLearningDesign = (learningDesignId = JsonUtil.optLong((JsonNode)ldJSON, (String)"learningDesignID")) == null ? null : this.learningDesignDAO.getLearningDesignById(learningDesignId);
        if (!authorised && existingLearningDesign != null && Boolean.TRUE.equals(existingLearningDesign.getEditOverrideLock())) {
            authorised = userID.equals(existingLearningDesign.getEditOverrideUser().getUserId());
        }
        if (!authorised) {
            throw new UserException("User with ID " + userID + " is not authorized to store a design in this workspace folder " + workspaceFolderID);
        }
        IObjectExtractor extractor = (IObjectExtractor)this.beanFactory.getBean("ObjectExtractor");
        LearningDesign design = extractor.extractSaveLearningDesign(ldJSON, existingLearningDesign, workspaceFolder, user);
        if (extractor.getMode() == 1) {
            String customCSV = JsonUtil.optString((JsonNode)ldJSON, (String)"customCSV");
            this.copyLearningDesignToolContent(design, design, design.getCopyTypeID(), customCSV);
        }
        this.insertEventLogEntry(user, design, null);
        return design;
    }

    private void insertEventLogEntry(User user, LearningDesign design, Date createDate) {
        String message = this.messageService.getMessage("audit.design.created", new Object[]{design.getTitle(), design.getLearningDesignId(), user.getLogin(), user.getUserId()});
        this.logEventService.logEvent(Integer.valueOf(1), user.getUserId(), null, null, null, message, createDate);
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(Long learningDesignId) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        Vector listOfValidationErrorDTOs = this.learningDesignService.validateLearningDesign(learningDesign);
        Boolean valid = listOfValidationErrorDTOs.size() > 0 ? Boolean.FALSE : Boolean.TRUE;
        learningDesign.setValidDesign(valid);
        this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
        return listOfValidationErrorDTOs;
    }

    @Override
    public Vector<AuthoringActivityDTO> getToolActivities(Long learningDesignId, String languageCode) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        Vector<AuthoringActivityDTO> listOfAuthoringActivityDTOs = new Vector<AuthoringActivityDTO>();
        for (Activity currentActivity : learningDesign.getActivities()) {
            if (!currentActivity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(currentActivity.getActivityId());
                AuthoringActivityDTO activityDTO = new AuthoringActivityDTO((Activity)toolActivity, null, languageCode);
                listOfAuthoringActivityDTOs.add(activityDTO);
            }
            catch (ToolException e) {
                String error = "" + e.getMessage();
                this.log.error((Object)error, (Throwable)e);
                throw new LearningDesignException(error, (Throwable)e);
            }
        }
        return listOfAuthoringActivityDTOs;
    }

    @Override
    public Long insertToolContentID(Long toolID) {
        Tool tool = this.toolDAO.getToolByID(toolID);
        if (tool == null) {
            this.log.error((Object)("The toolID " + toolID + " is not valid. A Tool with tool id " + toolID + " does not exist on the database."));
            return null;
        }
        return this.contentIDGenerator.getNextToolContentIDFor(tool);
    }

    @Override
    public Long copyToolContent(Long toolContentID, String customCSV) throws IOException {
        return this.lamsCoreToolService.notifyToolToCopyContent(toolContentID, customCSV);
    }

    public Vector getAvailableLicenses() {
        List licenses = this.licenseDAO.findAll(License.class);
        Vector<LicenseDTO> licenseDTOList = new Vector<LicenseDTO>(licenses.size());
        for (License element : licenses) {
            licenseDTOList.add(element.getLicenseDTO(Configuration.get((String)ConfigurationKeys.SERVER_URL)));
        }
        return licenseDTOList;
    }

    @Override
    public void deleteLearningDesign(LearningDesign design) {
        if (design == null) {
            this.log.error((Object)"deleteLearningDesign: unable to delete learning design as design is null.");
            return;
        }
        Set acts = design.getActivities();
        for (Activity activity : acts) {
            if (!activity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                this.lamsCoreToolService.notifyToolToDeleteContent(toolActivity);
            }
            catch (ToolException e) {
                this.log.error((Object)("Unable to delete tool content for activity" + activity + " as activity threw an exception"), (Throwable)e);
            }
        }
        this.learningDesignDAO.delete((Object)design);
    }

    @Override
    public String getUniqueNameForLearningDesign(String originalTitle, Integer workspaceFolderId) {
        String newName = originalTitle;
        if (workspaceFolderId != null) {
            List ldTitleList = this.learningDesignDAO.getLearningDesignTitlesByWorkspaceFolder(workspaceFolderId, originalTitle);
            int idx = 1;
            Calendar calendar = Calendar.getInstance();
            int mth = calendar.get(2) + 1;
            String mthStr = new Integer(mth).toString();
            if (mth < 10) {
                mthStr = "0" + mthStr;
            }
            int day = calendar.get(5);
            String dayStr = new Integer(day).toString();
            if (day < 10) {
                dayStr = "0" + dayStr;
            }
            String nameMid = dayStr + mthStr + calendar.get(1);
            while (ldTitleList.contains(newName)) {
                newName = originalTitle + "_" + nameMid + "_" + idx;
                ++idx;
            }
        }
        return newName;
    }

    @Override
    public Long insertSingleActivityLearningDesign(String learningDesignTitle, Long toolID, Long toolContentID, Long learningLibraryID, String contentFolderID, Integer organisationID) {
        Integer userID = AuthoringService.getUserId();
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        LearningDesign learningDesign = new LearningDesign(null, null, null, learningDesignTitle, null, null, Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null, new Date(), Configuration.get((String)ConfigurationKeys.SERVER_VERSION_NUMBER), user, user, null, null, null, null, null, null, null, null, contentFolderID, Boolean.valueOf(false), null, Integer.valueOf(1), null);
        WorkspaceFolder folder = null;
        if (organisationID == null) {
            folder = user.getWorkspaceFolder();
            learningDesign.setCopyTypeID(Integer.valueOf(1));
        } else {
            learningDesign.setCopyTypeID(Integer.valueOf(2));
            int MAX_DEEP_LEVEL_FOLDER = 50;
            Organisation organisation = (Organisation)this.baseDAO.find(Organisation.class, (Serializable)organisationID);
            for (int idx = 0; idx < MAX_DEEP_LEVEL_FOLDER && organisation != null && folder == null; ++idx) {
                folder = organisation.getRunSequencesFolder();
                if (folder != null) continue;
                organisation = organisation.getParentOrganisation();
            }
        }
        learningDesign.setWorkspaceFolder(folder);
        this.learningDesignDAO.insert((Object)learningDesign);
        ToolActivity templateActivity = (ToolActivity)this.activityDAO.getTemplateActivityByLibraryID(learningLibraryID);
        ToolActivity activity = (ToolActivity)templateActivity.createCopy(1);
        activity.setLearningDesign(learningDesign);
        activity.setToolContentId(toolContentID);
        activity.setActivityUIID(Integer.valueOf(1));
        activity.setXcoord(Integer.valueOf(300));
        activity.setYcoord(Integer.valueOf(300));
        this.activityDAO.insert((Object)activity);
        List<ToolOutputDefinitionDTO> defnDTOList = this.getToolOutputDefinitions(toolContentID, 1);
        String gradebookToolOutputDefinitionName = null;
        for (ToolOutputDefinitionDTO definition : defnDTOList) {
            if (!definition.getIsDefaultGradebookMark().booleanValue()) continue;
            gradebookToolOutputDefinitionName = definition.getName();
            break;
        }
        if (gradebookToolOutputDefinitionName != null) {
            ActivityEvaluation evaluation = new ActivityEvaluation();
            evaluation.setToolOutputDefinition(gradebookToolOutputDefinitionName);
            evaluation.setActivity(activity);
            activity.setEvaluation(evaluation);
            this.activityDAO.update((Object)activity);
        }
        learningDesign.getActivities().add(activity);
        learningDesign.setFirstActivity((Activity)activity);
        learningDesign.setValidDesign(Boolean.valueOf(true));
        this.learningDesignDAO.update((Object)learningDesign);
        Long learningDesingID = learningDesign.getLearningDesignId();
        this.insertEventLogEntry(user, learningDesign, learningDesign.getCreateDateTime());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created a single activity LD with ID: " + learningDesingID));
        }
        return learningDesingID;
    }

    @Override
    public Grouping getGroupingById(Long groupingID) {
        return this.groupingDAO.getGroupingById(groupingID);
    }

    @Override
    public String getToolAuthorUrl(Long toolID, Long toolContentID, String contentFolderID) {
        Tool tool = this.toolDAO.getToolByID(toolID);
        if (tool == null) {
            this.log.error((Object)("The toolID " + toolID + " is not valid. A Tool with tool id " + toolID + " does not exist on the database."));
            return null;
        }
        String authorUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL) + tool.getAuthorUrl();
        if (toolContentID != null) {
            authorUrl = WebUtil.appendParameterToURL((String)authorUrl, (String)"toolContentID", (String)toolContentID.toString());
        }
        if (contentFolderID != null) {
            authorUrl = WebUtil.appendParameterToURL((String)authorUrl, (String)"contentFolderID", (String)contentFolderID);
        }
        return authorUrl;
    }

    @Override
    public List<LearningDesignAccess> updateLearningDesignAccessByUser(Integer userId) {
        List accessList = this.learningDesignDAO.getAccessByUser(userId);
        LinkedList<LearningDesignAccess> result = new LinkedList<LearningDesignAccess>();
        for (LearningDesignAccess access : accessList) {
            LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(access.getLearningDesignId());
            if (learningDesign == null) {
                this.log.warn((Object)("When getting recent access list for Author with ID " + userId + " LD with ID " + access.getLearningDesignId() + " was found missing. Deleting access entry."));
                this.baseDAO.delete((Object)access);
                continue;
            }
            if (learningDesign.getWorkspaceFolder() == null) continue;
            access.setTitle(learningDesign.getTitle());
            access.setWorkspaceFolderId(learningDesign.getWorkspaceFolder().getWorkspaceFolderId());
            result.add(access);
        }
        return result;
    }

    @Override
    public void storeLearningDesignAccess(Long learningDesignId, Integer userId) {
        LearningDesignAccess access = new LearningDesignAccess();
        access.setLearningDesignId(learningDesignId);
        access.setUserId(userId);
        access.setAccessDate(new Date());
        this.learningDesignDAO.insertOrUpdate((Object)access);
    }
}

