/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.lamsfoundation.lams.authoring.template.TextUtil;
import org.lamsfoundation.lams.rest.RestTags;
import org.lamsfoundation.lams.util.JsonUtil;

public class SurveyQuestion {
    short type = 1;
    String questionText;
    Boolean allowOtherTextEntry;
    Boolean required;
    Map<Integer, String> answers;

    public SurveyQuestion(String text) {
        this.questionText = text;
        this.allowOtherTextEntry = false;
        this.required = true;
        this.answers = new TreeMap<Integer, String>();
    }

    public Map<Integer, String> getAnswers() {
        return this.answers;
    }

    public void setType(short type) {
        this.type = type;
    }

    public void setQuestionText(String questionText) {
        this.questionText = questionText;
    }

    public void setAllowOtherTextEntry(Boolean allowOtherTextEntry) {
        this.allowOtherTextEntry = allowOtherTextEntry;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getQuestionText() {
        return this.questionText;
    }

    public ObjectNode getAsObjectNode() throws IOException {
        return (ObjectNode)JsonNodeFactory.instance.objectNode().put("type", this.type).put(RestTags.QUESTION_TEXT, this.questionText).put("allowOtherTextEntry", this.allowOtherTextEntry).put("required", this.required).set(RestTags.ANSWERS, (JsonNode)JsonUtil.readArray(this.answers.values()));
    }

    public List<String> validate(ResourceBundle appBundle, MessageFormat formatter, Integer questionNumber) {
        ArrayList<String> errorMessages = null;
        if (this.questionText == null || this.questionText.length() == 0) {
            errorMessages = new ArrayList<String>();
            errorMessages.add(TextUtil.getText(appBundle, formatter, "error.question.num", new Object[]{questionNumber}));
        }
        if (this.answers.size() == 0) {
            if (errorMessages == null) {
                errorMessages = new ArrayList();
            }
            errorMessages.add(TextUtil.getText(appBundle, formatter, "error.question.must.have.answer.num", new Object[]{questionNumber}));
        }
        return errorMessages;
    }
}

