/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.authoring.template.Option;
import org.lamsfoundation.lams.authoring.template.TextUtil;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.rest.RestTags;
import org.lamsfoundation.lams.rest.ToolRestManager;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class LdTemplateAction
extends DispatchAction {
    private static Logger log = Logger.getLogger(LdTemplateAction.class);
    public static final int MAX_OPTION_COUNT = 6;
    public static final int MAX_FLOATING_ACTIVITY_OPTIONS = 6;
    public static final String PARENT_ACTIVITY_TYPE = "parentActivityType";
    private final HttpClient httpClient = new DefaultHttpClient();
    private static ILamsCoreToolService lamsCoreToolService;
    private static IWorkspaceManagementService workspaceManagementService;
    private static IAuthoringService authoringService;
    private static IToolDAO toolDAO;
    protected static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";
    protected static final String ASSESSMENT_TOOL_SIGNATURE = "laasse10";
    protected static final String ASSESSMENT_ICON = "tool/laasse10/images/icon_assessment.swf";
    protected static final String CHAT_TOOL_SIGNATURE = "lachat11";
    protected static final String CHAT_ICON = "tool/lachat11/images/icon_chat.swf";
    protected static final String FORUM_TOOL_SIGNATURE = "lafrum11";
    protected static final String FORUM_ICON = "tool/lafrum11/images/icon_forum.swf";
    protected static final String LEADER_TOOL_SIGNATURE = "lalead11";
    protected static final String LEADER_ICON = "tool/lalead11/images/icon_leaderselection.swf";
    protected static final String MCQ_TOOL_SIGNATURE = "lamc11";
    protected static final String MCQ_ICON = "tool/lamc11/images/icon_mcq.swf";
    protected static final String NOTEBOOK_TOOL_SIGNATURE = "lantbk11";
    protected static final String NOTEBOOK_ICON = "tool/lantbk11/images/icon_notebook.swf";
    protected static final String NOTICEBOARD_TOOL_SIGNATURE = "lanb11";
    protected static final String NOTICEBOARD_ICON = "tool/lanb11/images/icon_htmlnb.swf";
    protected static final String QA_TOOL_SIGNATURE = "laqa11";
    protected static final String QA_ICON = "tool/laqa11/images/icon_questionanswer.swf";
    protected static final String SHARE_RESOURCES_TOOL_SIGNATURE = "larsrc11";
    protected static final String SHARE_RESOURCES_ICON = "tool/larsrc11/images/icon_rsrc.swf";
    protected static final String SCRATCHIE_TOOL_SIGNATURE = "lascrt11";
    protected static final String SCRATCHIE_ICON = "tool/lascrt11/images/icon_scratchie.swf";
    protected static final String SCRIBE_TOOL_SIGNATURE = "lascrb11";
    protected static final String SCRIBE_ICON = "tool/lascrb11/images/icon_scribe.swf";
    protected static final String SUBMIT_TOOL_SIGNATURE = "lasbmt11";
    protected static final String SUBMIT_ICON = "tool/lasbmt11/images/icon_reportsubmission.swf";
    protected static final String SURVEY_TOOL_SIGNATURE = "lasurv11";
    protected static final String SURVEY_ICON = "tool/lasurv11/images/icon_survey.swf";
    protected static final String WIKI_TOOL_SIGNATURE = "lawiki10";
    protected static final String WIKI_ICON = "tool/lawiki10/images/icon_wiki.swf";
    protected static final String MINDMAP_TOOL_SIGNATURE = "lamind10";
    protected static final String MINDMAP_ICON = "tool/lamind10/images/icon_mindmap.swf";
    protected static final String VOTE_TOOL_SIGNATURE = "lavote11";
    protected static final String VOTE_ICON = "tool/lavote11/images/icon_ranking.swf";
    protected static final String PEER_REVIEW_TOOL_SIGNATURE = "laprev11";
    protected static final String PEER_REVIEW_ICON = "tool/laprev11/images/icon_peerreview.svg";
    protected static final String CHAT_SCRIBE_DESC = "Combined Chat and Scribe";
    protected static final String FORUM_SCRIBE_DESC = "Combined Forum and Scribe";
    protected static final String RESOURCES_FORUM_DESC = "Combined Share Resources and Forum";
    protected static final String TOOL_CONTENT_SERVLET_URL_SUFFIX = "/lams/rest/ToolContent";
    protected static final String LEARNING_DESIGN_SERVLET_URL_SUFFIX = "/lams/rest/LearningDesign";
    protected static final int rowHeightSpace = 100;
    protected static final int activityWidthSpace = 185;
    protected static final int gateHeightOffset = 5;
    protected static final int gateWidthOffset = 50;
    public static final short RESOURCE_TYPE_URL = 1;
    public static final short RESOURCE_TYPE_FILE = 2;
    public static final short RESOURCE_TYPE_WEBSITE = 3;
    public static final short RESOURCE_TYPE_LEARNING_OBJECT = 4;

    public final ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectNode responseJSON = null;
        try {
            responseJSON = this.createLearningDesign(request);
            if (!responseJSON.has("learningDesignID") && !responseJSON.has("errors")) {
                log.error((Object)("The Learning Design was not created successfully. ResponseJSON missing both learningDesignID and errors" + responseJSON.toString()));
                responseJSON = JsonNodeFactory.instance.objectNode();
                responseJSON.put("fatal", "The Learning Design was not created successfully. See the server log for more details.");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            responseJSON = JsonNodeFactory.instance.objectNode();
            responseJSON.put("fatal", "The Learning Design was not created successfully. See the server log for more details.\n\n" + e.getMessage());
        }
        response.setContentType(CONTENT_TYPE_JSON);
        response.getWriter().print(responseJSON);
        return null;
    }

    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contentFolderID = FileUtil.generateUniqueContentFolderID();
        request.setAttribute(RestTags.CONTENT_FOLDER_ID, (Object)contentFolderID);
        return mapping.findForward("init");
    }

    protected abstract ObjectNode createLearningDesign(HttpServletRequest var1) throws Exception;

    protected ArrayNode createTransitions(AtomicInteger maxUIID, ArrayNode activities) {
        ArrayNode transitions = JsonNodeFactory.instance.arrayNode();
        return this.createTransitions(transitions, maxUIID, activities);
    }

    protected ArrayNode createTransitions(AtomicInteger maxUIID, Set<ArrayNode> setsOfActivities) {
        ArrayNode transitions = JsonNodeFactory.instance.arrayNode();
        if (setsOfActivities != null) {
            for (ArrayNode activities : setsOfActivities) {
                this.createTransitions(transitions, maxUIID, activities);
            }
        }
        return transitions;
    }

    private ArrayNode createTransitions(ArrayNode transitions, AtomicInteger maxUIID, ArrayNode activities) {
        for (int activityIndex = 1; activityIndex < activities.size(); ++activityIndex) {
            ObjectNode fromActivity = (ObjectNode)activities.get(activityIndex - 1);
            ObjectNode toActivity = (ObjectNode)activities.get(activityIndex);
            Integer parentType = JsonUtil.optInt((JsonNode)toActivity, (String)PARENT_ACTIVITY_TYPE, (Integer)null);
            while (activityIndex < activities.size() && parentType != null && !parentType.equals(8)) {
                toActivity = (ObjectNode)activities.get(++activityIndex);
                parentType = JsonUtil.optInt((JsonNode)toActivity, (String)PARENT_ACTIVITY_TYPE, (Integer)null);
            }
            int fromUIID = JsonUtil.optInt((JsonNode)fromActivity, (String)"activityUIID");
            int toUIID = JsonUtil.optInt((JsonNode)toActivity, (String)"activityUIID");
            ObjectNode transitionJSON = JsonNodeFactory.instance.objectNode();
            transitionJSON.put("transitionUIID", maxUIID.incrementAndGet());
            transitionJSON.put("fromUIID", fromUIID);
            transitionJSON.put("toUIID", toUIID);
            transitionJSON.put("transitionType", 0);
            transitions.add((JsonNode)transitionJSON);
            fromActivity.remove(PARENT_ACTIVITY_TYPE);
        }
        return transitions;
    }

    protected Integer[] calcPosition(int order) {
        Integer[] pos = new Integer[2];
        int activity4space = 740;
        int rawPos = order * 185;
        int rowNum = rawPos / activity4space;
        pos[0] = 20 + rawPos - rowNum * activity4space;
        pos[1] = 100 + 100 * rowNum;
        return pos;
    }

    protected Integer[] calcPositionNextRight(Integer[] currPos) {
        Integer[] newPos = new Integer[2];
        newPos[1] = currPos[1];
        newPos[0] = currPos[0] + 185;
        return newPos;
    }

    protected Integer[] calcPositionBelow(Integer[] currPos) {
        Integer[] newPos = new Integer[]{currPos[0], currPos[1] + 100};
        return newPos;
    }

    protected Integer[] calcGateOffset(Integer[] currPos) {
        Integer[] newPos = new Integer[2];
        newPos[1] = currPos[1] + 5;
        newPos[0] = currPos[0] + 50;
        return newPos;
    }

    private String createTitle(String templateCode, String userEnteredString, Integer workspaceFolderID) {
        String title = WebUtil.removeHTMLtags((String)userEnteredString);
        title = title.replaceAll("[@%<>/^/*/$]", "");
        title = this.getAuthoringService().getUniqueNameForLearningDesign(title, workspaceFolderID);
        if (title.length() > 220) {
            title.substring(0, 220);
        }
        return title;
    }

    protected ObjectNode saveLearningDesign(String templateCode, String userEnteredTitleString, String userEnteredDescription, Integer workspaceFolderID, String contentFolderId, Integer maxUIID, ArrayNode activities, ArrayNode transitions, ArrayNode groupings, ArrayNode branchMappings) throws HttpException, IOException {
        ObjectNode ldJSON = JsonNodeFactory.instance.objectNode();
        ldJSON.put("workspaceFolderID", workspaceFolderID);
        ldJSON.put("copyTypeID", 1);
        ldJSON.put("title", this.createTitle(templateCode, userEnteredTitleString, workspaceFolderID));
        ldJSON.put("description", WebUtil.removeHTMLtags((String)userEnteredDescription));
        ldJSON.put("designType", templateCode.toLowerCase());
        ldJSON.put("maxID", maxUIID);
        ldJSON.put("readOnly", false);
        ldJSON.put("editOverrideLock", false);
        ldJSON.put("contentFolderID", contentFolderId);
        ldJSON.put("saveMode", 0);
        ldJSON.put("validDesign", true);
        ldJSON.set("activities", (JsonNode)activities);
        ldJSON.set("transitions", (JsonNode)transitions);
        ldJSON.set("groupings", (JsonNode)groupings);
        ldJSON.set("branchMappings", (JsonNode)branchMappings);
        LearningDesign learningDesign = null;
        try {
            learningDesign = this.getAuthoringService().saveLearningDesignDetails(ldJSON);
        }
        catch (Exception e) {
            log.error((Object)("Unable to learning design with details " + ldJSON), (Throwable)e);
            throw new HttpException("Unable to learning design with details " + ldJSON);
        }
        ObjectNode responseJSON = JsonNodeFactory.instance.objectNode();
        responseJSON.put("learningDesignID", learningDesign.getLearningDesignId());
        responseJSON.put("title", learningDesign.getTitle());
        return responseJSON;
    }

    protected ObjectNode createGateActivity(AtomicInteger uiid, int order, Integer[] layoutCoords) {
        ObjectNode activityJSON = JsonNodeFactory.instance.objectNode();
        Integer[] pos = layoutCoords;
        if (pos == null) {
            pos = this.calcPosition(order);
            pos[0] = pos[0] + 40;
            pos[1] = pos[1] + 15;
        }
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("xCoord", pos[0]);
        activityJSON.put("yCoord", pos[1]);
        activityJSON.put("activityTitle", "Gate");
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 5);
        activityJSON.put("gateActivityLevelID", 1);
        return activityJSON;
    }

    protected ObjectNode[] createGroupingActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Integer groupingTypeID, Integer numLearners, Integer numGroups, String title, String[] groupNames, ResourceBundle appBundle, MessageFormat formatter) {
        ObjectNode activityJSON;
        ObjectNode groupingJSON;
        ObjectNode[] responseJSONs = new ObjectNode[2];
        responseJSONs[1] = groupingJSON = JsonNodeFactory.instance.objectNode();
        int groupingUIID = uiid.incrementAndGet();
        groupingJSON.put("groupingUIID", groupingUIID);
        groupingJSON.put("groupingTypeID", groupingTypeID);
        if (groupingTypeID.equals(Grouping.CHOSEN_GROUPING_TYPE)) {
            groupingJSON.put("maxNumberOfGroups", numGroups);
        } else {
            groupingJSON.put("numberOfGroups", numGroups);
        }
        groupingJSON.put("learnersPerGroup", numLearners);
        groupingJSON.put("equalNumberOfLearnersPerGroup", Boolean.FALSE);
        ArrayNode groups = JsonNodeFactory.instance.arrayNode();
        if (groupNames != null) {
            int orderId = 0;
            for (String groupName : groupNames) {
                ObjectNode group = JsonNodeFactory.instance.objectNode();
                group.put("groupName", groupName);
                group.put("orderID", orderId++);
                group.put("groupUIID", uiid.incrementAndGet());
                groups.add((JsonNode)group);
            }
        } else {
            Integer useNumGroups = numGroups != null && numGroups > 0 ? numGroups : 2;
            int orderId = 0;
            int groupNum = 1;
            while (orderId < useNumGroups) {
                ObjectNode group = JsonNodeFactory.instance.objectNode();
                group.put("groupName", TextUtil.getText(appBundle, formatter, "label.course.groups.prefix", null) + groupNum);
                group.put("orderID", orderId);
                group.put("groupUIID", uiid.incrementAndGet());
                groups.add((JsonNode)group);
                ++orderId;
                ++groupNum;
            }
        }
        groupingJSON.set("groups", (JsonNode)groups);
        Integer[] pos = layoutCoords != null ? layoutCoords : this.calcPosition(order);
        responseJSONs[0] = activityJSON = JsonNodeFactory.instance.objectNode();
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("xCoord", pos[0]);
        activityJSON.put("yCoord", pos[1]);
        activityJSON.put("activityTitle", title != null ? title : "Grouping");
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 2);
        activityJSON.put("createGroupingUIID", groupingUIID);
        return responseJSONs;
    }

    protected ObjectNode createParallelActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Integer groupingUIID, String activityTitle, String description) {
        ObjectNode activityJSON = JsonNodeFactory.instance.objectNode();
        Integer[] pos = layoutCoords;
        if (pos == null) {
            pos = this.calcPosition(order);
            pos[1] = pos[1] - 50;
        }
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("xCoord", pos[0]);
        activityJSON.put("yCoord", pos[1]);
        activityJSON.put("activityTitle", activityTitle != null ? activityTitle : "Parallel Activity");
        activityJSON.put("activityCategoryID", 5);
        activityJSON.put("activityTypeID", 6);
        activityJSON.put("description", description);
        if (groupingUIID != null) {
            activityJSON.put("groupingUIID", groupingUIID);
            activityJSON.put("applyGrouping", true);
        } else {
            activityJSON.put("applyGrouping", false);
        }
        return activityJSON;
    }

    protected ObjectNode createSupportActivity(AtomicInteger uiid, int order, Integer[] layoutCoords) {
        Integer[] pos = layoutCoords;
        if (pos == null) {
            pos = this.calcPosition(order);
            pos[0] = 20;
            pos[1] = pos[1] + 100;
        }
        ObjectNode activityJSON = JsonNodeFactory.instance.objectNode();
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 1);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("xCoord", pos[0]);
        activityJSON.put("yCoord", pos[1]);
        activityJSON.put("activityTitle", "Support Activity");
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 15);
        activityJSON.put("maxActivities", 6);
        return activityJSON;
    }

    protected ObjectNode createSequenceActivity(Integer reservedUiid, Integer parentUIID, Integer parentActivityType, Integer firstActivityUiid, int orderId, String branchName) {
        ObjectNode activityJSON = JsonNodeFactory.instance.objectNode();
        activityJSON.put("activityUIID", reservedUiid);
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("activityTitle", branchName != null ? branchName : "Branch " + orderId);
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 8);
        activityJSON.put("orderID", orderId);
        activityJSON.put("parentUIID", parentUIID);
        activityJSON.put(PARENT_ACTIVITY_TYPE, parentActivityType);
        activityJSON.put("defaultActivityUIID", firstActivityUiid);
        activityJSON.put("stopAfterActivity", false);
        return activityJSON;
    }

    protected ObjectNode createBranchMapping(AtomicInteger uiid, Integer groupUiid, Integer branchingActivityUiid, Integer sequenceActivityUiid) {
        ObjectNode bmJSON = JsonNodeFactory.instance.objectNode();
        bmJSON.put("entryUIID", uiid.incrementAndGet());
        bmJSON.put("groupUIID", groupUiid);
        bmJSON.put("branchingActivityUIID", branchingActivityUiid);
        bmJSON.put("sequenceActivityUIID", sequenceActivityUiid);
        return bmJSON;
    }

    protected ObjectNode createGroupBranchingActivity(Integer reservedUiid, Integer defaultBranchUiid, Integer groupingUiid, int order, Integer[] layoutCoords, Integer[] startCoords, Integer[] endCoords, String activityTitle) {
        ObjectNode activityJSON = this.createBranchingActivity(reservedUiid, defaultBranchUiid, groupingUiid, order, layoutCoords, startCoords, endCoords, activityTitle, 11);
        return activityJSON;
    }

    private ObjectNode createBranchingActivity(Integer reservedUiid, Integer defaultBranchUiid, Integer groupingUiid, int order, Integer[] layoutCoords, Integer[] startCoords, Integer[] endCoords, String activityTitle, int activityType) {
        ObjectNode activityJSON = JsonNodeFactory.instance.objectNode();
        activityJSON.put("activityUIID", reservedUiid);
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("activityTitle", activityTitle != null ? activityTitle : "Branching");
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", activityType);
        activityJSON.put("maxActivities", 6);
        activityJSON.put("xCoord", layoutCoords[0]);
        activityJSON.put("yCoord", layoutCoords[1]);
        activityJSON.put("startXCoord", startCoords[0]);
        activityJSON.put("startYCoord", startCoords[1]);
        activityJSON.put("endXCoord", endCoords[0]);
        activityJSON.put("endYCoord", endCoords[1]);
        activityJSON.put("stopAfterActivity", false);
        activityJSON.put("defaultActivityUIID", defaultBranchUiid);
        if (groupingUiid != null) {
            activityJSON.put("groupingUIID", groupingUiid);
            activityJSON.put("applyGrouping", true);
        } else {
            activityJSON.put("applyGrouping", false);
        }
        return activityJSON;
    }

    protected Long createToolContent(UserDTO user, String toolSignature, ObjectNode toolContentJSON) throws HttpException, IOException {
        try {
            Tool tool = this.getTool(toolSignature);
            Long toolContentID = this.getAuthoringService().insertToolContentID(tool.getToolId());
            ToolRestManager toolRestService = (ToolRestManager)this.getLamsCoreToolService().findToolService(tool);
            toolRestService.createRestToolContent(user.getUserID(), toolContentID, toolContentJSON);
            return toolContentID;
        }
        catch (Exception e) {
            log.error((Object)("Unable to create tool content for " + toolSignature + " with details " + toolContentJSON + ". \nThe tool probably threw an exception - check the server logs for more details.\nIf the exception is \"Servlet.service() for servlet ToolContentRestServlet threw exception java.lang.ClassCastException: com.sun.proxy.$ProxyXXX cannot be cast to org.lamsfoundation.lams.rest.ToolRestManager)\" then the tool doesn't support the LDTemplate service calls (ie has not implemented the ToolRestManager interface / createRestToolContent() method."));
            throw new HttpException("Unable to create tool content for " + toolSignature + " with details " + toolContentJSON);
        }
    }

    protected ObjectNode createToolActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, String toolSignature, String toolIcon, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle, int activityCategory) {
        ObjectNode activityJSON = JsonNodeFactory.instance.objectNode();
        Tool tool = this.getTool(toolSignature);
        Integer[] pos = layoutCoords != null ? layoutCoords : this.calcPosition(order);
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put(RestTags.CONTENT_FOLDER_ID, contentFolderID);
        activityJSON.put("toolID", tool.getToolId());
        activityJSON.put("learningLibraryID", tool.getLearningLibraryId());
        activityJSON.put("toolContentID", toolContentID);
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("libraryActivityUIImage", toolIcon);
        activityJSON.put("xCoord", pos[0]);
        activityJSON.put("yCoord", pos[1]);
        activityJSON.put("activityTitle", activityTitle != null ? activityTitle : "Activity");
        activityJSON.put("activityCategoryID", activityCategory);
        activityJSON.put("activityTypeID", 1);
        if (parentUIID != null) {
            activityJSON.put("parentUIID", parentUIID);
            activityJSON.put(PARENT_ACTIVITY_TYPE, parentActivityType);
        }
        if (groupingUIID != null) {
            activityJSON.put("groupingUIID", groupingUIID);
            activityJSON.put("applyGrouping", true);
        } else {
            activityJSON.put("applyGrouping", false);
        }
        return activityJSON;
    }

    protected ObjectNode createStandardToolContent(String title, String instructions, String reflectionInstructions, Boolean lockWhenFinished, Boolean allowRichTextEditor, UserDTO user) {
        ObjectNode toolContentJSON = JsonNodeFactory.instance.objectNode();
        toolContentJSON.put(RestTags.TITLE, title != null ? title : "");
        toolContentJSON.put(RestTags.INSTRUCTIONS, instructions != null ? instructions : "");
        if (reflectionInstructions != null) {
            toolContentJSON.put(RestTags.REFLECT_ON_ACTIVITY, true);
            toolContentJSON.put(RestTags.REFLECT_INSTRUCTIONS, reflectionInstructions);
        }
        toolContentJSON.put(RestTags.LOCK_WHEN_FINISHED, lockWhenFinished);
        toolContentJSON.put(RestTags.ALLOW_RICH_TEXT_EDITOR, allowRichTextEditor);
        if (user != null) {
            toolContentJSON.put("firstName", user.getFirstName());
            toolContentJSON.put("lastName", user.getLastName());
            toolContentJSON.put("loginName", user.getLogin());
        }
        return toolContentJSON;
    }

    protected Long createAssessmentToolContent(UserDTO user, String title, String instructions, String reflectionInstructions, boolean selectLeaderToolOutput, ArrayNode questions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, null, null, user);
        toolContentJSON.put(RestTags.USE_SELECT_LEADER_TOOL_OUTPUT, selectLeaderToolOutput);
        toolContentJSON.set(RestTags.QUESTIONS, (JsonNode)questions);
        ArrayNode references = JsonNodeFactory.instance.arrayNode();
        for (int i = 0; i < questions.size(); ++i) {
            Integer questionDisplayOrder = ((ObjectNode)questions.get(i)).get(RestTags.DISPLAY_ORDER).asInt();
            references.add((JsonNode)JsonNodeFactory.instance.objectNode().put(RestTags.DISPLAY_ORDER, questionDisplayOrder).put("questionDisplayOrder", questionDisplayOrder));
        }
        toolContentJSON.set("references", (JsonNode)references);
        return this.createToolContent(user, ASSESSMENT_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createAssessmentActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, ASSESSMENT_TOOL_SIGNATURE, ASSESSMENT_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Assessment", 3);
    }

    protected Long createChatToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, String filterKeywords, String reflectionInstructions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, null);
        toolContentJSON.put("filterKeywords", filterKeywords);
        return this.createToolContent(user, CHAT_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createChatActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, CHAT_TOOL_SIGNATURE, CHAT_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Chat", 2);
    }

    protected Long createForumToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean allowRichTextEditor, boolean allowNewTopic, boolean allowRateMessages, boolean allowUpload, boolean limitedMaxCharacters, Integer maxCharacters, ArrayNode topics) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, allowRichTextEditor, user);
        toolContentJSON.set("topics", (JsonNode)topics);
        toolContentJSON.put("allowNewTopic", allowNewTopic);
        toolContentJSON.put("allowRateMessages", allowRateMessages);
        toolContentJSON.put("allowUpload", allowUpload);
        toolContentJSON.put("limitedMaxCharacters", limitedMaxCharacters);
        if (limitedMaxCharacters && maxCharacters != null) {
            toolContentJSON.put("maxCharacters", maxCharacters);
        }
        return this.createToolContent(user, FORUM_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createForumActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, FORUM_TOOL_SIGNATURE, FORUM_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Forum", 2);
    }

    protected Long createLeaderSelectionToolContent(UserDTO user, String title, String instructions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        return this.createToolContent(user, LEADER_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createLeaderSelectionActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, LEADER_TOOL_SIGNATURE, LEADER_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Leader Selection", 6);
    }

    protected Long createNotebookToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean allowRichTextEditor) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, allowRichTextEditor, null);
        return this.createToolContent(user, NOTEBOOK_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createNotebookActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, NOTEBOOK_TOOL_SIGNATURE, NOTEBOOK_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Notebook", 6);
    }

    protected Long createNoticeboardToolContent(UserDTO user, String title, String content, String reflectionInstructions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, null, reflectionInstructions, null, null, null);
        toolContentJSON.put("content", content != null ? content : "");
        return this.createToolContent(user, NOTICEBOARD_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createNoticeboardActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, NOTICEBOARD_TOOL_SIGNATURE, NOTICEBOARD_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Noticeboard", 4);
    }

    protected Long createQAToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean allowRichTextEditor, boolean oneQuestionPerPage, boolean showOtherLearnersAnswers, boolean showOtherLearnersNames, ArrayNode questions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, allowRichTextEditor, null);
        toolContentJSON.set(RestTags.QUESTIONS, (JsonNode)questions);
        toolContentJSON.put("questionsSequenced", oneQuestionPerPage);
        toolContentJSON.put("showOtherAnswers", showOtherLearnersAnswers);
        toolContentJSON.put("usernameVisible", showOtherLearnersNames);
        return this.createToolContent(user, QA_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createQAActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, QA_TOOL_SIGNATURE, QA_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Q&A", 6);
    }

    protected Long createMCQToolContent(UserDTO user, String title, String instructions, boolean useSelectLeaderToolOuput, ArrayNode questions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        toolContentJSON.put(RestTags.USE_SELECT_LEADER_TOOL_OUTPUT, useSelectLeaderToolOuput);
        toolContentJSON.set(RestTags.QUESTIONS, (JsonNode)questions);
        return this.createToolContent(user, MCQ_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createMCQActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, MCQ_TOOL_SIGNATURE, MCQ_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Multiple Choice", 3);
    }

    protected Long createMindmapToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean multiUserMode, String reflectionInstruction) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, null, null);
        toolContentJSON.put("multiUserMode", multiUserMode);
        return this.createToolContent(user, MINDMAP_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createMindmapActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, MINDMAP_TOOL_SIGNATURE, MINDMAP_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "MindMap", 6);
    }

    protected Long createResourcesToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean runContentAutomatically, boolean allowLearnerAddURL, boolean allowLearnerAddFile, boolean notifyInstructors, Integer minResourcesToView, String reflectionInstructions, ArrayNode resources) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, user);
        toolContentJSON.put("allowAddFiles", allowLearnerAddFile);
        toolContentJSON.put("allowAddUrls", allowLearnerAddURL);
        toolContentJSON.put("notifyTeachersOnAssigmentSumbit", notifyInstructors);
        toolContentJSON.put("runAuto", runContentAutomatically);
        if (minResourcesToView != null) {
            toolContentJSON.put("minViewResourceNumber", minResourcesToView);
        }
        toolContentJSON.set("resources", (JsonNode)resources);
        return this.createToolContent(user, SHARE_RESOURCES_TOOL_SIGNATURE, toolContentJSON);
    }

    private ObjectNode createResourceItem(String title, short type, String[] instructions, File file, int displayOrder) throws IOException {
        ObjectNode item = JsonNodeFactory.instance.objectNode();
        item.put(RestTags.TITLE, title != null ? title : "");
        item.put("type", type);
        item.put(RestTags.DISPLAY_ORDER, displayOrder);
        if (instructions != null) {
            item.set("instructions", (JsonNode)JsonUtil.readArray((Object)instructions));
        } else {
            item.set("instructions", (JsonNode)JsonNodeFactory.instance.arrayNode());
        }
        if (type != 1) {
            log.warn((Object)("LD Templates not handling files yet - file, website & LO resources won't work. Filename " + file.getAbsoluteFile()));
        }
        return item;
    }

    protected ObjectNode createResourceURL(String title, String[] instructions, String URL2, boolean openInNewWindow, int displayOrder) throws IOException {
        ObjectNode obj = this.createResourceItem(title, (short)1, instructions, null, displayOrder);
        obj.put("url", URL2);
        obj.put("openUrlNewWindow", openInNewWindow);
        return obj;
    }

    protected ObjectNode createResourceFile(String title, String description, String[] instructions, File file, int displayOrder) throws IOException {
        ObjectNode obj = this.createResourceItem(title, (short)2, instructions, file, displayOrder);
        obj.put("description", description);
        return obj;
    }

    protected ObjectNode createResourceWebsite(String title, String description, String[] instructions, File file, int displayOrder) throws IOException {
        ObjectNode obj = this.createResourceItem(title, (short)3, instructions, file, displayOrder);
        obj.put("description", description);
        return obj;
    }

    protected ObjectNode createResourceLearningObject(String title, String description, String[] instructions, File file, int displayOrder) throws IOException {
        ObjectNode obj = this.createResourceItem(title, (short)4, instructions, file, displayOrder);
        obj.put("description", description);
        return obj;
    }

    protected ObjectNode createResourcesActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, SHARE_RESOURCES_TOOL_SIGNATURE, SHARE_RESOURCES_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Share Resources", 4);
    }

    protected Long createScratchieToolContent(UserDTO user, String title, String instructions, boolean useSelectLeaderToolOuput, ArrayNode questions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        toolContentJSON.set(RestTags.QUESTIONS, (JsonNode)questions);
        return this.createToolContent(user, SCRATCHIE_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createScratchieActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, SCRATCHIE_TOOL_SIGNATURE, SCRATCHIE_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Scratchie", 4);
    }

    protected Long createScribeToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean autoSelectScribe, boolean showAggregatedReports, String reflectionInstructions, ArrayNode questions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, null);
        toolContentJSON.set(RestTags.QUESTIONS, (JsonNode)questions);
        toolContentJSON.put("autoSelectScribe", autoSelectScribe);
        toolContentJSON.put("showAggregatedReports", showAggregatedReports);
        return this.createToolContent(user, SCRIBE_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createScribeActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, SCRIBE_TOOL_SIGNATURE, SCRIBE_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Scribe", 2);
    }

    protected Long createSubmitToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, Boolean limitUpload, Integer limitUploadNumber, String reflectionInstructions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, user);
        if (limitUploadNumber != null) {
            toolContentJSON.put("limitUpload", limitUpload != null ? limitUpload : true);
            toolContentJSON.put("limitUploadNumber", limitUploadNumber);
        }
        return this.createToolContent(user, SUBMIT_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createSubmitActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, SUBMIT_TOOL_SIGNATURE, SUBMIT_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Submit File", 3);
    }

    protected Long createSurveyToolContent(UserDTO user, String title, String instructions, Boolean lockWhenFinished, ArrayNode questions) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, null, user);
        toolContentJSON.set("questions", (JsonNode)questions);
        return this.createToolContent(user, SURVEY_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createSurveyActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, SURVEY_TOOL_SIGNATURE, SURVEY_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Survey", 6);
    }

    protected Long createVoteToolContent(UserDTO user, String title, String instructions, ArrayNode answers, Boolean showResults) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        toolContentJSON.set(RestTags.ANSWERS, (JsonNode)answers);
        toolContentJSON.put("showResults", showResults);
        return this.createToolContent(user, VOTE_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createVoteActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, VOTE_TOOL_SIGNATURE, VOTE_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Voting", 6);
    }

    protected Long createWikiToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, String reflectionInstruction, ArrayNode pages) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, null, null);
        toolContentJSON.set("pages", (JsonNode)pages);
        return this.createToolContent(user, WIKI_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createWikiActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, WIKI_TOOL_SIGNATURE, WIKI_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Wiki", 2);
    }

    protected Long createPeerReviewToolContent(UserDTO user, String title, String instructions, String reflectionInstructions, ArrayNode criterias) throws HttpException, IOException {
        ObjectNode toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, null, null, user);
        toolContentJSON.set("criterias", (JsonNode)criterias);
        return this.createToolContent(user, PEER_REVIEW_TOOL_SIGNATURE, toolContentJSON);
    }

    protected ObjectNode createPeerReviewActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) {
        return this.createToolActivity(uiid, order, layoutCoords, PEER_REVIEW_TOOL_SIGNATURE, PEER_REVIEW_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Peer Review", 4);
    }

    protected final IAuthoringService getAuthoringService() {
        if (authoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            authoringService = (IAuthoringService)ctx.getBean("authoringService");
        }
        return authoringService;
    }

    protected final Tool getTool(String toolSignature) {
        if (toolDAO == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            toolDAO = (IToolDAO)ctx.getBean("toolDAO");
        }
        return toolDAO.getToolBySignature(toolSignature);
    }

    protected final IWorkspaceManagementService getWorkspaceManagementService() {
        if (workspaceManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            workspaceManagementService = (IWorkspaceManagementService)ctx.getBean("workspaceManagementService");
        }
        return workspaceManagementService;
    }

    private ILamsCoreToolService getLamsCoreToolService() {
        if (lamsCoreToolService == null) {
            lamsCoreToolService = (ILamsCoreToolService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("lamsCoreToolService");
        }
        return lamsCoreToolService;
    }

    public ActionForward createAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("questionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber"));
        String questionType = WebUtil.readStrParam((HttpServletRequest)request, (String)"questionType");
        if (questionType == null || !questionType.equalsIgnoreCase("mcq")) {
            return mapping.findForward("assess");
        }
        return mapping.findForward("assessmcq");
    }

    public ActionForward createQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward;
        request.setAttribute("questionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber"));
        String topicNumber = request.getParameter("topicNumber");
        if (topicNumber != null) {
            request.setAttribute("topicNumber", (Object)topicNumber);
        }
        return mapping.findForward((forward = request.getParameter("forward")) != null && forward.length() > 0 ? forward : "question");
    }

    public ActionForward createForum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("topicNumber", (Object)request.getParameter("topicNumber"));
        return mapping.findForward("forum");
    }

    public ActionForward createOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("questionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber"));
        request.setAttribute("optionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber"));
        boolean useAssessmentVersion = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"assess", (boolean)false);
        return mapping.findForward(useAssessmentVersion ? "assessoption" : "questionoption");
    }

    public ActionForward deleteOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer questionNumber = WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber", (boolean)true);
        Integer delete = WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber");
        boolean useAssessmentVersion = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"assess", (boolean)false);
        TreeMap<Integer, Option> optionsMap = this.getOptions(request, questionNumber, useAssessmentVersion);
        optionsMap.remove(delete);
        LinkedList<Option> options = new LinkedList<Option>();
        int displayOrder = 1;
        for (Option option : optionsMap.values()) {
            option.setDisplayOrder(displayOrder++);
            options.add(option);
        }
        request.setAttribute("questionNumber", (Object)questionNumber);
        request.setAttribute("options", options);
        request.setAttribute("optionCount", (Object)options.size());
        return mapping.findForward(useAssessmentVersion ? "assessredooption" : "redooption");
    }

    public ActionForward swapOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer questionNumber = WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber", (boolean)true);
        int swap1 = WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber1");
        int swap2 = WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber2");
        if (swap2 < swap1) {
            swap1 = swap2;
        }
        boolean useAssessmentVersion = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"assess", (boolean)false);
        TreeMap<Integer, Option> optionsMap = this.getOptions(request, questionNumber, useAssessmentVersion);
        LinkedList<Option> options = new LinkedList<Option>();
        Option swap = null;
        for (Option option : optionsMap.values()) {
            if (swap != null) {
                swap.setDisplayOrder(option.getDisplayOrder());
                option.setDisplayOrder(swap1);
                options.add(option);
                options.add(swap);
                swap = null;
                continue;
            }
            if (option.getDisplayOrder() == swap1) {
                swap = option;
                continue;
            }
            options.add(option);
        }
        if (swap != null) {
            options.add(swap);
        }
        request.setAttribute("questionNumber", (Object)questionNumber);
        request.setAttribute("options", options);
        request.setAttribute("optionCount", (Object)options.size());
        return mapping.findForward(useAssessmentVersion ? "assessredooption" : "redooption");
    }

    private TreeMap<Integer, Option> getOptions(HttpServletRequest request, Integer questionNumber, boolean useAssessmentVersion) {
        String paramPrefix = useAssessmentVersion ? "assmcq" : "question";
        Integer correctDisplayIdInteger = WebUtil.readIntParam((HttpServletRequest)request, (String)(paramPrefix + questionNumber + "correct"), (boolean)true);
        int correctDisplayId = correctDisplayIdInteger != null ? correctDisplayIdInteger : 0;
        TreeMap<Integer, Option> optionDtos = new TreeMap<Integer, Option>();
        for (int i = 1; i <= 6; ++i) {
            String optionText = request.getParameter(paramPrefix + questionNumber + "option" + i);
            if (optionText == null) continue;
            String grade = request.getParameter(paramPrefix + questionNumber + "option" + i + "grade");
            Option option = new Option(i, i == correctDisplayId, optionText, grade);
            optionDtos.put(new Integer(i), option);
        }
        return optionDtos;
    }

    public ActionForward createResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("urlNumber", (Object)request.getParameter("urlNumber"));
        if (request.getParameter("branchNumberUnderscore") != null) {
            request.setAttribute("branchNumberUnderscore", (Object)request.getParameter("branchNumberUnderscore"));
        }
        return mapping.findForward("resource");
    }

    public ActionForward createBranch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("branchNumber", (Object)request.getParameter("branchNumber"));
        return mapping.findForward("branch");
    }

    public ActionForward createRatingCriteria(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("criteriaNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"criteriaNumber"));
        return mapping.findForward("peerreviewstar");
    }

    class ToolDetails {
        String signature;
        String icon;
        int activityType;

        ToolDetails(String signature, String icon, int activityType) {
            this.signature = signature;
            this.icon = icon;
            this.activityType = activityType;
        }
    }
}

