/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.authoring.template.AssessMCAnswer;
import org.lamsfoundation.lams.authoring.template.Assessment;
import org.lamsfoundation.lams.authoring.template.PeerReviewCriteria;
import org.lamsfoundation.lams.authoring.template.TemplateData;
import org.lamsfoundation.lams.authoring.template.web.LdTemplateAction;
import org.lamsfoundation.lams.rest.RestTags;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class TBLTemplateAction
extends LdTemplateAction {
    private static Logger log = Logger.getLogger(TBLTemplateAction.class);
    private static String templateCode = "TBL";

    @Override
    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("questionNumber", (Object)"1");
        return super.init(mapping, form, request, response);
    }

    @Override
    protected ObjectNode createLearningDesign(HttpServletRequest request) throws Exception {
        TBLData data = new TBLData(request);
        if (data.getErrorMessages() != null && data.getErrorMessages().size() > 0) {
            ObjectNode restRequestJSON = JsonNodeFactory.instance.objectNode();
            restRequestJSON.set("errors", (JsonNode)JsonUtil.readArray(data.getErrorMessages()));
            return restRequestJSON;
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        Integer workspaceFolderID = this.getWorkspaceManagementService().getUserWorkspaceFolder(userDTO.getUserID()).getResourceID().intValue();
        AtomicInteger maxUIID = new AtomicInteger();
        int order = 0;
        ArrayNode activities = JsonNodeFactory.instance.arrayNode();
        ArrayNode groupings = JsonNodeFactory.instance.arrayNode();
        Integer[] firstActivityInRowPosition = new Integer[]{20, 125};
        String activityTitle = data.getText("boilerplate.introduction.title");
        Long welcomeToolContentId = this.createNoticeboardToolContent(userDTO, activityTitle, data.getText("boilerplate.introduction.instructions"), null);
        activities.add((JsonNode)this.createNoticeboardActivity(maxUIID, order++, firstActivityInRowPosition, welcomeToolContentId, data.contentFolderID, null, null, null, activityTitle));
        Integer[] currentActivityPosition = this.calcPositionNextRight(firstActivityInRowPosition);
        ObjectNode[] groupingJSONs = this.createGroupingActivity(maxUIID, order++, currentActivityPosition, data.groupingType, data.numLearners, data.numGroups, null, null, data.getUIBundle(), data.getFormatter());
        activities.add((JsonNode)groupingJSONs[0]);
        groupings.add((JsonNode)groupingJSONs[1]);
        Integer groupingUIID = groupingJSONs[1].get("groupingUIID").asInt();
        currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        activities.add((JsonNode)this.createGateActivity(maxUIID, order++, this.calcGateOffset(currentActivityPosition)));
        currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        activityTitle = data.getText("boilerplate.ira.title");
        Long iRAToolContentId = this.createMCQToolContent(userDTO, activityTitle, data.getText("boilerplate.ira.instructions"), false, JsonUtil.readArray(data.testQuestions.values()));
        activities.add((JsonNode)this.createMCQActivity(maxUIID, order++, currentActivityPosition, iRAToolContentId, data.contentFolderID, groupingUIID, null, null, activityTitle));
        currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        activities.add((JsonNode)this.createGateActivity(maxUIID, order++, this.calcGateOffset(currentActivityPosition)));
        firstActivityInRowPosition = this.calcPositionBelow(firstActivityInRowPosition);
        activityTitle = data.getText("boilerplate.leader.title");
        Long leaderSelectionToolContentId = this.createLeaderSelectionToolContent(userDTO, activityTitle, data.getText("boilerplate.leader.instructions"));
        activities.add((JsonNode)this.createLeaderSelectionActivity(maxUIID, order++, firstActivityInRowPosition, leaderSelectionToolContentId, data.contentFolderID, groupingUIID, null, null, activityTitle));
        currentActivityPosition = this.calcPositionNextRight(firstActivityInRowPosition);
        activityTitle = data.getText("boilerplate.tra.title");
        Long tRAToolContentId = this.createScratchieToolContent(userDTO, activityTitle, data.getText("boilerplate.tra.instructions"), false, JsonUtil.readArray(data.testQuestions.values()));
        activities.add((JsonNode)this.createScratchieActivity(maxUIID, order++, currentActivityPosition, tRAToolContentId, data.contentFolderID, groupingUIID, null, null, activityTitle));
        currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        activities.add((JsonNode)this.createGateActivity(maxUIID, order++, this.calcGateOffset(currentActivityPosition)));
        firstActivityInRowPosition = this.calcPositionBelow(firstActivityInRowPosition);
        currentActivityPosition = firstActivityInRowPosition;
        ArrayNode questionsJSONArray = JsonNodeFactory.instance.arrayNode();
        int displayOrder = 1;
        for (Assessment exerciseQuestion : data.applicationExercises.values()) {
            String applicationExerciseTitle = data.getText("boilerplate.ae.application.exercise.num", new String[]{Integer.toString(displayOrder)});
            exerciseQuestion.setTitle(applicationExerciseTitle);
            questionsJSONArray.add((JsonNode)exerciseQuestion.getAsObjectNode(displayOrder));
            ++displayOrder;
        }
        String overallAssessmentTitle = data.getText("boilerplate.ae.application.exercise.num", new String[]{""});
        Long aetoolContentId = this.createAssessmentToolContent(userDTO, overallAssessmentTitle, data.getText("boilerplate.ae.instructions"), null, true, questionsJSONArray);
        activities.add((JsonNode)this.createAssessmentActivity(maxUIID, order++, currentActivityPosition, aetoolContentId, data.contentFolderID, groupingUIID, null, null, overallAssessmentTitle));
        currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        ArrayNode criterias = JsonNodeFactory.instance.arrayNode();
        for (PeerReviewCriteria criteria : data.peerReviewCriteria.values()) {
            if (criteria.getTitle() == null || criteria.getTitle().length() <= 0) continue;
            criterias.add((JsonNode)criteria.getAsObjectNode());
        }
        if (criterias.size() > 0) {
            String peerReviewTitle = data.getText("boilerplate.peerreview");
            Long prtoolContentId = this.createPeerReviewToolContent(userDTO, peerReviewTitle, data.getText("boilerplate.peerreview.instructions"), null, criterias);
            activities.add((JsonNode)this.createPeerReviewActivity(maxUIID, order++, currentActivityPosition, prtoolContentId, data.contentFolderID, groupingUIID, null, null, peerReviewTitle));
            ++displayOrder;
            currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        }
        activities.add((JsonNode)this.createGateActivity(maxUIID, order++, this.calcGateOffset(currentActivityPosition)));
        currentActivityPosition = this.calcPositionNextRight(currentActivityPosition);
        activityTitle = data.getText("boilerplate.individual.reflection.title");
        Long reflectionToolContentId = this.createNotebookToolContent(userDTO, activityTitle, data.getText("boilerplate.individual.reflection.instructions"), false, false);
        activities.add((JsonNode)this.createNotebookActivity(maxUIID, order++, currentActivityPosition, reflectionToolContentId, data.contentFolderID, null, null, null, activityTitle));
        ArrayNode transitions = this.createTransitions(maxUIID, activities);
        return this.saveLearningDesign(templateCode, data.sequenceTitle, "", workspaceFolderID, data.contentFolderID, maxUIID.get(), activities, transitions, groupings, null);
    }

    class TBLData
    extends TemplateData {
        String contentFolderID;
        String sequenceTitle;
        Integer groupingType;
        Integer numLearners;
        Integer numGroups;
        SortedMap<Integer, ObjectNode> testQuestions;
        SortedMap<Integer, Assessment> applicationExercises;
        SortedMap<Integer, PeerReviewCriteria> peerReviewCriteria;
        int questionOffset;
        int assessmentOffset;

        TBLData(HttpServletRequest request) {
            super(request, templateCode);
            this.questionOffset = 8;
            this.assessmentOffset = 10;
            this.contentFolderID = this.getTrimmedString(request, "contentFolderID", false);
            this.sequenceTitle = this.getTrimmedString(request, "sequenceTitle", false);
            this.groupingType = WebUtil.readIntParam((HttpServletRequest)request, (String)"grouping");
            this.numLearners = WebUtil.readIntParam((HttpServletRequest)request, (String)"numLearners", (boolean)true);
            this.numGroups = WebUtil.readIntParam((HttpServletRequest)request, (String)"numGroups", (boolean)true);
            this.testQuestions = new TreeMap<Integer, ObjectNode>();
            this.applicationExercises = new TreeMap<Integer, Assessment>();
            this.peerReviewCriteria = new TreeMap<Integer, PeerReviewCriteria>();
            TreeMap<Integer, Integer> correctAnswers = new TreeMap<Integer, Integer>();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                if (name.startsWith("question")) {
                    Integer questionDisplayOrder;
                    int correctIndex = name.indexOf("correct");
                    if (correctIndex > 0) {
                        Integer questionDisplayOrder2 = Integer.valueOf(name.substring(this.questionOffset, correctIndex));
                        Integer correctValue = WebUtil.readIntParam((HttpServletRequest)request, (String)name);
                        correctAnswers.put(questionDisplayOrder2, correctValue);
                        continue;
                    }
                    int optionIndex = name.indexOf("option");
                    if (optionIndex > 0) {
                        questionDisplayOrder = Integer.valueOf(name.substring(this.questionOffset, optionIndex));
                        Integer optionDisplayOrder = Integer.valueOf(name.substring(optionIndex + 6));
                        this.processTestQuestion(name, null, questionDisplayOrder, optionDisplayOrder, this.getTrimmedString(request, name, true));
                        continue;
                    }
                    questionDisplayOrder = Integer.valueOf(name.substring(this.questionOffset));
                    this.processTestQuestion(name, this.getTrimmedString(request, name, true), questionDisplayOrder, null, null);
                    continue;
                }
                if (!name.startsWith("peerreview")) continue;
                this.processInputPeerReviewRequestField(name, request);
            }
            this.updateCorrectAnswers(correctAnswers);
            this.processAssessments(request);
            this.validate();
        }

        private void processAssessments(HttpServletRequest request) {
            int numAssessments = WebUtil.readIntParam((HttpServletRequest)request, (String)"numAssessments");
            for (int i = 1; i <= numAssessments; ++i) {
                String assessmentPrefix = "assessment" + i;
                String questionText = this.getTrimmedString(request, assessmentPrefix, true);
                Assessment assessment = new Assessment();
                if (questionText == null) continue;
                assessment.setQuestionText(questionText);
                assessment.setType(WebUtil.readStrParam((HttpServletRequest)request, (String)(assessmentPrefix + "type")));
                assessment.setRequired(true);
                if (assessment.getType() == 1) {
                    String optionPrefix = "assmcq" + i;
                    optionPrefix = optionPrefix + "option";
                    int order = 0;
                    for (int o = 1; o <= 6; ++o) {
                        String answer = this.getTrimmedString(request, optionPrefix + o, true);
                        if (answer == null) continue;
                        String grade = request.getParameter(optionPrefix + o + "grade");
                        try {
                            assessment.getAnswers().add(new AssessMCAnswer(order++, answer, Float.valueOf(grade)));
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)("Error parsing " + grade + " for float"), (Throwable)e);
                            this.addValidationErrorMessage("authoring.error.application.exercise.not.blank.and.grade", new Object[i]);
                        }
                    }
                }
                this.applicationExercises.put(i, assessment);
            }
        }

        void processInputPeerReviewRequestField(String name, HttpServletRequest request) {
            log.debug((Object)("process peer review " + name + " order " + name.substring(10)));
            int fieldIndex = name.indexOf("EnableComments");
            if (fieldIndex > 0) {
                Integer criteriaNumber = Integer.valueOf(name.substring(10, fieldIndex));
                this.findCriteriaInMap(criteriaNumber).setCommentsEnabled(WebUtil.readBooleanParam((HttpServletRequest)request, (String)name, (boolean)false));
            } else {
                fieldIndex = name.indexOf("MinWordsLimit");
                if (fieldIndex > 0) {
                    Integer criteriaNumber = Integer.valueOf(name.substring(10, fieldIndex));
                    this.findCriteriaInMap(criteriaNumber).setCommentsMinWordsLimit(WebUtil.readIntParam((HttpServletRequest)request, (String)name, (boolean)true));
                } else {
                    Integer criteriaNumber = Integer.valueOf(name.substring(10));
                    this.findCriteriaInMap(criteriaNumber).setTitle(this.getTrimmedString(request, name, true));
                }
            }
        }

        private PeerReviewCriteria findCriteriaInMap(Integer criteriaNumber) {
            PeerReviewCriteria criteria = (PeerReviewCriteria)this.peerReviewCriteria.get(criteriaNumber);
            if (criteria == null) {
                criteria = new PeerReviewCriteria(criteriaNumber);
                this.peerReviewCriteria.put(criteriaNumber, criteria);
            }
            return criteria;
        }

        void processTestQuestion(String name, String questionText, Integer questionDisplayOrder, Integer optionDisplayOrder, String optionText) {
            ObjectNode question = (ObjectNode)this.testQuestions.get(questionDisplayOrder);
            if (question == null) {
                question = JsonNodeFactory.instance.objectNode();
                question.set(RestTags.ANSWERS, (JsonNode)JsonNodeFactory.instance.arrayNode());
                question.put(RestTags.DISPLAY_ORDER, questionDisplayOrder);
                this.testQuestions.put(questionDisplayOrder, question);
            }
            if (questionText != null) {
                question.put(RestTags.QUESTION_TEXT, questionText);
                question.put(RestTags.QUESTION_TITLE, "Q" + questionDisplayOrder.toString());
            }
            if (optionDisplayOrder != null && optionText != null) {
                ObjectNode newOption = JsonNodeFactory.instance.objectNode();
                newOption.put(RestTags.DISPLAY_ORDER, optionDisplayOrder);
                newOption.put(RestTags.CORRECT, false);
                newOption.put(RestTags.ANSWER_TEXT, optionText);
                ((ArrayNode)question.get(RestTags.ANSWERS)).add((JsonNode)newOption);
            }
        }

        void updateCorrectAnswers(TreeMap<Integer, Integer> correctAnswers) {
            for (Map.Entry<Integer, ObjectNode> entry : this.testQuestions.entrySet()) {
                Integer correctAnswerDisplay;
                Integer questionNumber = entry.getKey();
                ObjectNode question = entry.getValue();
                if (!question.has(RestTags.QUESTION_TEXT)) {
                    this.addValidationErrorMessage("authoring.error.question.num", new Integer[]{questionNumber});
                }
                if ((correctAnswerDisplay = correctAnswers.get(entry.getKey())) == null) {
                    this.addValidationErrorMessage("authoring.error.question.correct.num", new Integer[]{questionNumber});
                    continue;
                }
                ArrayNode answers = (ArrayNode)question.get(RestTags.ANSWERS);
                if (answers == null || answers.size() == 0) {
                    this.addValidationErrorMessage("authoring.error.question.must.have.answer.num", new Integer[]{questionNumber});
                    continue;
                }
                boolean correctAnswerFound = false;
                for (int i = 0; i < answers.size(); ++i) {
                    ObjectNode option = (ObjectNode)answers.get(i);
                    if (!correctAnswerDisplay.equals(option.get(RestTags.DISPLAY_ORDER).asInt())) continue;
                    option.remove(RestTags.CORRECT);
                    option.put(RestTags.CORRECT, true);
                    correctAnswerFound = true;
                }
                if (correctAnswerFound) continue;
                this.addValidationErrorMessage("authoring.error.question.correct.num", new Integer[]{questionNumber});
            }
        }

        void validate() {
            if (this.contentFolderID == null) {
                this.addValidationErrorMessage("authoring.error.content.id", null);
            }
            if (this.sequenceTitle == null) {
                this.addValidationErrorMessage("authoring.error.sequence.title", null);
            }
            if (this.applicationExercises.size() == 0) {
                this.addValidationErrorMessage("authoring.error.application.exercise.num", new Integer[]{1});
            } else {
                for (Map.Entry<Integer, Assessment> assessmentEntry : this.applicationExercises.entrySet()) {
                    List<String> errors = assessmentEntry.getValue().validate(this.appBundle, this.formatter, assessmentEntry.getKey());
                    if (errors == null) continue;
                    this.errorMessages.addAll(errors);
                }
            }
        }
    }
}

