/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.rest.RestServlet;
import org.lamsfoundation.lams.rest.ToolRestManager;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.JsonUtil;

public class ToolContentRestServlet
extends RestServlet {
    private static final Logger log = Logger.getLogger(ToolContentRestServlet.class);

    @Override
    protected void doPostInternal(ObjectNode requestJSON, UserDTO userDTO, HttpServletResponse response) throws Exception {
        String toolSignature = JsonUtil.optString((JsonNode)requestJSON, (String)"toolSignature");
        Tool tool = this.getToolDAO().getToolBySignature(toolSignature);
        Long toolContentID = this.getAuthoringService().insertToolContentID(tool.getToolId());
        ObjectNode toolContentJSON = JsonUtil.optObject((JsonNode)requestJSON, (String)"toolContent");
        ToolRestManager toolRestService = (ToolRestManager)this.getLamsCoreToolService().findToolService(tool);
        toolRestService.createRestToolContent(userDTO.getUserID(), toolContentID, toolContentJSON);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print("{\"toolContentID\":" + toolContentID + "}");
    }
}

