/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.HashUtil;

public class DatabaseAuthenticator {
    private static Logger log = Logger.getLogger(DatabaseAuthenticator.class);
    private static DataSource dataSource;
    private static final String GET_PASSWORD_QUERY = "SELECT password FROM lams_user WHERE login=?";
    private static final String GET_SALT_QUERY = "SELECT salt FROM lams_user WHERE login=?";
    private static final String UPDATE_PASSWORD_QUERY = "UPDATE lams_user SET password=?, salt=? WHERE login=?";

    public DatabaseAuthenticator(String dsJndiName) throws NamingException {
        if (dataSource == null) {
            InitialContext ctx = new InitialContext();
            dataSource = (DataSource)ctx.lookup(dsJndiName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate(String userName, String inputPassword) {
        try (Connection conn = dataSource.getConnection();){
            String databasePassword = DatabaseAuthenticator.getDatabasePassword(conn, userName);
            if (StringUtils.isBlank((String)databasePassword)) {
                log.warn((Object)("Password in database is blank for user: " + userName));
                boolean bl = false;
                return bl;
            }
            if (databasePassword.length() == 40) {
                String inputPasswordHash = HashUtil.sha1((String)inputPassword);
                if (inputPasswordHash.equals(databasePassword)) {
                    boolean bl = DatabaseAuthenticator.convertPasswordToSha256(conn, userName, inputPassword);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (databasePassword.length() == 64) {
                String salt = DatabaseAuthenticator.getDatabaseSalt(conn, userName);
                if (!StringUtils.isBlank((String)salt) && salt.length() == 64) {
                    String inputPasswordHash = HashUtil.sha256((String)inputPassword, (String)salt);
                    boolean bl = inputPasswordHash.equals(databasePassword);
                    return bl;
                }
                log.error((Object)("Salt does not have correct format for user: " + userName));
                boolean bl = false;
                return bl;
            }
            log.error((Object)("Password in database does not have correct format for user: " + userName));
            return false;
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private static String getDatabasePassword(Connection conn, String userName) throws SQLException {
        ResultSet resultSet = null;
        try {
            try (PreparedStatement preparedStatement = conn.prepareStatement(GET_PASSWORD_QUERY);){
                preparedStatement.setString(1, userName);
                resultSet = preparedStatement.executeQuery();
                String string = resultSet.next() ? resultSet.getString(1).trim() : null;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private static String getDatabaseSalt(Connection conn, String userName) throws SQLException {
        ResultSet resultSet = null;
        try {
            try (PreparedStatement preparedStatement = conn.prepareStatement(GET_SALT_QUERY);){
                preparedStatement.setString(1, userName);
                resultSet = preparedStatement.executeQuery();
                String string = resultSet.next() ? resultSet.getString(1).trim() : null;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    private static boolean convertPasswordToSha256(Connection conn, String userName, String inputPassword) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converting password to SHA256 for user: " + userName));
        }
        String salt = HashUtil.salt();
        String inputPasswordHash = HashUtil.sha256((String)inputPassword, (String)salt);
        try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_PASSWORD_QUERY);){
            preparedStatement.setString(1, inputPasswordHash);
            preparedStatement.setString(2, salt);
            preparedStatement.setString(3, userName);
            int result = preparedStatement.executeUpdate();
            if (result == 1) {
                boolean bl = true;
                return bl;
            }
            log.error((Object)("Error while converting password to SHA256 for user: " + userName + ". The update query returned result: " + result));
        }
        return false;
    }
}

