/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.lamsfoundation.lams.security.SimplePrincipal;

public class SimpleGroup
extends SimplePrincipal
implements Group {
    private static final long serialVersionUID = -875843422197596410L;
    private Map<Principal, Principal> members = new HashMap<Principal, Principal>(3);

    public SimpleGroup(String groupName) {
        super(groupName);
    }

    public boolean addMember(Principal user) {
        boolean isMember = this.members.containsKey(user);
        if (!isMember) {
            this.members.put(user, user);
        }
        return !isMember;
    }

    public boolean isMember(Principal member) {
        return false;
    }

    public Enumeration<Principal> members() {
        return Collections.enumeration(this.members.values());
    }

    public boolean removeMember(Principal user) {
        Principal prev = this.members.remove(user);
        return prev != null;
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        for (Principal principal : this.members.keySet()) {
            tmp.append(principal);
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }
}

