/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.security.DatabaseAuthenticator;
import org.lamsfoundation.lams.security.LDAPAuthenticator;
import org.lamsfoundation.lams.security.SimpleGroup;
import org.lamsfoundation.lams.security.SimplePrincipal;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.dto.ThemeDTO;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.service.LdapService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UniversalLoginModule
implements LoginModule {
    private static Logger log = Logger.getLogger(UniversalLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean loginOK;
    private Principal identity;
    private char[] credential;
    private static String dsJndiName;
    private static final Map<String, Long> internalAuthenticationTokens;
    private static DatabaseAuthenticator databaseAuthenticator;
    private static IThemeService themeService;
    private static IUserManagementService userManagementService;
    private static final long INTERNAL_AUTHENTICATION_TIMEOUT = 10000L;
    private static final String ROLES_QUERY = "SELECT DISTINCT r.name,'Roles' FROM lams_user u LEFT OUTER JOIN lams_user_organisation uo USING(user_id) LEFT OUTER JOIN lams_user_organisation_role urr USING(user_organisation_id) LEFT OUTER JOIN lams_role r USING (role_id) WHERE u.login=?";

    @Override
    public boolean commit() throws LoginException {
        if (!this.loginOK) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(this.identity);
        for (Group group : this.getRoleSets()) {
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        log.info((Object)("User logged in: " + this.getUserName()));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        log.info((Object)("Abort log in for user: " + this.getUserName()));
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        log.info((Object)("User logged out: " + this.getUserName()));
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.identity);
        return true;
    }

    private Group createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal principal : principals) {
            Group grp;
            if (!(principal instanceof Group) || !(grp = (Group)principal).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add(roles);
        }
        return roles;
    }

    @Override
    public boolean login() throws LoginException {
        this.loginOK = false;
        String[] info = this.getUsernameAndPassword();
        String userName = info[0];
        String password = info[1];
        log.info((Object)("Authenticate user: " + userName));
        if (this.identity == null) {
            try {
                this.identity = new SimplePrincipal(userName);
            }
            catch (Exception e) {
                throw new LoginException("Failed to create principal: " + e.getMessage());
            }
            if (!this.validatePassword(password)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Bad password for user: " + userName));
                }
                throw new FailedLoginException("Incorrect password");
            }
        }
        this.loginOK = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("User authenticated: " + this.identity));
        }
        return true;
    }

    private String getUserName() {
        return this.identity == null ? null : this.identity.getName();
    }

    private String[] getUsernameAndPassword() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        return new String[]{username, password};
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        if (dsJndiName == null) {
            dsJndiName = (String)options.get("dsJndiName");
        }
    }

    private boolean validatePassword(String inputPassword) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
        if (userManagementService == null) {
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
            themeService = (IThemeService)ctx.getBean("themeService");
        }
        if (SessionManager.getSession() != null && userManagementService.isUserSysAdmin()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authenticated sysadmin");
            }
            return true;
        }
        String userName = this.getUserName();
        if (StringUtils.isBlank((String)inputPassword)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entered password is blank for user: " + userName));
            }
            return false;
        }
        if (inputPassword.startsWith("#LAMS")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authenticating internally user: " + userName));
            }
            Long internalAuthenticationTime = internalAuthenticationTokens.get(inputPassword);
            internalAuthenticationTokens.remove(inputPassword);
            return internalAuthenticationTime != null && System.currentTimeMillis() - internalAuthenticationTime < 10000L;
        }
        boolean isValid = false;
        try {
            UserDTO userDTO;
            ThemeDTO userTheme;
            User user = userManagementService.getUserByLogin(userName);
            if (user == null) {
                LDAPAuthenticator ldap;
                if (!Configuration.getAsBoolean((String)ConfigurationKeys.LDAP_PROVISIONING_ENABLED)) {
                    return false;
                }
                LdapService ldapService = null;
                try {
                    ldapService = (LdapService)ctx.getBean("ldapService");
                }
                catch (NoSuchBeanDefinitionException e) {
                    log.warn((Object)"No ldapService bean found, trying another method to fetch it.", (Throwable)e);
                    ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/lamsfoundation/lams/usermanagement/ldapContext.xml");
                    ldapService = (LdapService)context.getBean("ldapService");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LDAP provisioning is enabled, checking user " + userName + " against LDAP server."));
                }
                if (!(isValid = (ldap = new LDAPAuthenticator(userManagementService)).authenticate(userName, inputPassword))) {
                    return false;
                }
                log.info((Object)("Creating new user using LDAP: " + userName));
                if (ldapService.createLDAPUser(ldap.getAttrs())) {
                    user = userManagementService.getUserByLogin(userName);
                    if (!ldapService.addLDAPUser(ldap.getAttrs(), user.getUserId())) {
                        log.error((Object)("Could not add LDAP user " + userName + " to organisation."));
                    }
                } else {
                    log.error((Object)("Could not create new user for LDAP user: " + userName));
                    return false;
                }
            }
            if (!isValid) {
                String type = user.getAuthenticationMethod().getAuthenticationMethodType().getDescription();
                if ("LDAP".equals(type)) {
                    LDAPAuthenticator authenticator = new LDAPAuthenticator(userManagementService);
                    isValid = authenticator.authenticate(userName, inputPassword);
                    user = userManagementService.getUserByLogin(userName);
                } else if ("LAMS".equals(type)) {
                    if (databaseAuthenticator == null) {
                        databaseAuthenticator = new DatabaseAuthenticator(dsJndiName);
                    }
                    isValid = databaseAuthenticator.authenticate(userName, inputPassword);
                } else {
                    log.error((Object)("Unexpected authentication type: " + type));
                    return false;
                }
            }
            if (user.getDisabledFlag().booleanValue()) {
                log.debug((Object)("User is disabled: " + user.getLogin()));
                return false;
            }
            if (isValid && (userTheme = (userDTO = user.getUserDTO()).getTheme()) != null) {
                boolean themeExists = false;
                for (Theme theme : themeService.getAllThemes()) {
                    if (!userTheme.getId().equals(theme.getThemeId())) continue;
                    themeExists = true;
                    break;
                }
                if (!themeExists) {
                    userDTO.setTheme(new ThemeDTO(themeService.getDefaultTheme()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while validating password", (Throwable)e);
            return false;
        }
        return isValid;
    }

    private Group[] getRoleSets() throws LoginException {
        String userName = this.getUserName();
        HashMap<String, Group> setsMap = new HashMap<String, Group>();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(ROLES_QUERY);
            ps.setString(1, userName);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("No matching user name found in roles: " + userName);
            }
            ArrayList<String> groupMembers = new ArrayList<String>();
            do {
                Group group;
                String name = rs.getString(1);
                String groupName = rs.getString(2);
                if (groupName == null || groupName.length() == 0) {
                    groupName = "Roles";
                }
                if ((group = (Group)setsMap.get(groupName)) == null) {
                    group = new SimpleGroup(groupName);
                    setsMap.put(groupName, group);
                }
                try {
                    SimplePrincipal p = null;
                    if (name == null) {
                        name = "LEARNER";
                        log.info((Object)("Found no roles for user: " + userName + ", assigning: " + name));
                    }
                    p = new SimplePrincipal(name);
                    if (!groupMembers.contains(name)) {
                        log.info((Object)("Assign user: " + userName + " to role " + p.getName()));
                        group.addMember((Principal)p);
                        groupMembers.add(name);
                    }
                    if (!name.equals("SYSADMIN")) continue;
                    p = new SimplePrincipal("AUTHOR");
                    log.info((Object)("Found role " + name));
                    if (groupMembers.contains("AUTHOR")) continue;
                    log.info((Object)("Assign user: " + userName + " to role " + "AUTHOR"));
                    group.addMember((Principal)p);
                    groupMembers.add("AUTHOR");
                }
                catch (Exception e) {
                    log.info((Object)("Failed to create principal: " + name + " for user: " + userName), (Throwable)e);
                }
            } while (rs.next());
        }
        catch (NamingException e) {
            throw new LoginException(e.toString(true));
        }
        catch (SQLException e) {
            throw new LoginException(e.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    public static void setAuthenticationToken(String token) {
        internalAuthenticationTokens.put(token, System.currentTimeMillis());
    }

    static {
        internalAuthenticationTokens = new TreeMap<String, Long>();
    }
}

