/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Emailer;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.ValidationUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.EmailForm;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmailUserAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(EmailUserAction.class);
    private static final EmailValidator emailValidator = EmailValidator.getInstance();
    private static IUserManagementService userManagementService;
    private static IEventNotificationService eventNotificationService;
    private static MessageService messageService;

    public ActionForward composeMail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserDTO currentUser = (UserDTO)SessionManager.getSession().getAttribute("user");
        if (this.canSend(request, currentUser)) {
            Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
            User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userId);
            request.setAttribute("user", (Object)user);
            if (!emailValidator.isValid(user.getEmail())) {
                log.error((Object)("Recipient " + user.getLogin() + " does not have a valid email"));
                this.saveError(request, "error.valid.email.required", true);
            }
        } else {
            log.error((Object)("User " + currentUser.getLogin() + " is not allowed to send email"));
            this.saveError(request, "error.authorisation", true);
        }
        return mapping.findForward("emailuser");
    }

    public ActionForward send(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserDTO currentUser = (UserDTO)SessionManager.getSession().getAttribute("user");
        if (!this.canSend(request, currentUser)) {
            log.error((Object)("User " + currentUser.getLogin() + " is not allowed to send email"));
            response.setContentType("text/plain;charset=utf-8");
            response.getWriter().write(this.getMessageService().getMessage("error.authorisation"));
            return null;
        }
        EmailForm emailForm = (EmailForm)form;
        Long userId = emailForm.getUserId();
        String subject = emailForm.getSubject();
        String body = WebUtil.removeHTMLtags((String)emailForm.getBody());
        if (log.isDebugEnabled()) {
            log.debug((Object)("User " + currentUser.getLogin() + " (" + currentUser.getEmail() + ")  sent email to user ID " + userId + ": \n[subject] " + subject + "\n[message] " + body));
        }
        boolean IS_HTML_FORMAT = false;
        this.getEventNotificationService().sendMessage(currentUser.getUserID(), Integer.valueOf(userId.intValue()), (AbstractDeliveryMethod)IEventNotificationService.DELIVERY_METHOD_MAIL, subject, body, IS_HTML_FORMAT);
        String ccEmail = emailForm.getCcEmail();
        if (StringUtils.isNotBlank((String)ccEmail) && ValidationUtil.isEmailValid((String)ccEmail, (boolean)false)) {
            Emailer.sendFromSupportEmail((String)subject, (String)ccEmail, (String)body, (boolean)IS_HTML_FORMAT);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + currentUser.getLogin() + " (" + currentUser.getEmail() + ")  sent email to user ID " + userId + ": \n[subject] " + subject + "\n[message] " + body));
            }
        }
        return null;
    }

    private void saveError(HttpServletRequest request, String error, boolean sendDisabled) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(error));
        this.saveErrors(request, errors);
        request.setAttribute("errorsPresent", (Object)true);
        request.setAttribute("sendDisabled", (Object)sendDisabled);
    }

    private IEventNotificationService getEventNotificationService() {
        if (eventNotificationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            eventNotificationService = (IEventNotificationService)ctx.getBean("eventNotificationService");
        }
        return eventNotificationService;
    }

    private MessageService getMessageService() {
        if (messageService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            messageService = (MessageService)ctx.getBean("centralMessageService");
        }
        return messageService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private boolean canSend(HttpServletRequest request, UserDTO currentUser) {
        boolean result;
        if (currentUser == null) {
            currentUser = (UserDTO)SessionManager.getSession().getAttribute("user");
        }
        boolean bl = result = request.isUserInRole("SYSADMIN") || this.getUserManagementService().isUserGlobalGroupAdmin();
        if (!result) {
            Lesson lesson;
            String lessonId;
            String orgId = request.getParameter("organisationID");
            if (StringUtils.isBlank((String)orgId) && !StringUtils.isBlank((String)(lessonId = request.getParameter("lessonID"))) && (lesson = (Lesson)this.getUserManagementService().findById(Lesson.class, (Serializable)new Long(lessonId))) != null) {
                orgId = lesson.getOrganisation().getOrganisationId().toString();
            }
            if (!StringUtils.isBlank((String)orgId)) {
                result = this.getUserManagementService().isUserInRole(currentUser.getUserID(), new Integer(orgId), "MONITOR") || this.getUserManagementService().isUserInRole(currentUser.getUserID(), new Integer(orgId), "GROUP MANAGER");
            }
        }
        return result;
    }
}

