/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FindUserLessonsAction
extends DispatchAction {
    private static IUserManagementService userManagementService;
    private static ILessonService lessonService;
    private static ISecurityService securityService;

    public ActionForward getResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer courseID = WebUtil.readIntParam((HttpServletRequest)request, (String)"courseID");
        User viewer = (User)this.getUserManagementService().findById(User.class, (Serializable)this.getUserId());
        if (!this.getSecurityService().isGroupMonitor(courseID, viewer.getUserId(), "find user lessons", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        String query = null;
        List<Object> users = new LinkedList<User>();
        Organisation group = (Organisation)this.getUserManagementService().findById(Organisation.class, (Serializable)courseID);
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)true);
        if (userID != null) {
            User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userID);
            users.add(user);
            query = user.getFirstName() + " " + user.getLastName();
        } else {
            query = WebUtil.readStrParam((HttpServletRequest)request, (String)"query", (boolean)true);
            if (query != null) {
                users = this.getUserManagementService().findUsers(query, group.getOrganisationId(), true);
            }
        }
        HashMap userLessonsMap = new HashMap();
        for (User user : users) {
            List lessons = this.getLessonService().getLessonsByGroupAndUser(user.getUserId(), group.getOrganisationId());
            ArrayList<LessonDTO> lessonDTOs = new ArrayList<LessonDTO>();
            for (Lesson lesson : lessons) {
                LessonDTO dto = new LessonDTO(lesson);
                dto.setDisplayMonitor(Boolean.valueOf(lesson.getLessonClass().isStaffMember(viewer)));
                lessonDTOs.add(dto);
            }
            userLessonsMap.put(user, lessonDTOs);
        }
        request.setAttribute("userLessonsMap", userLessonsMap);
        request.setAttribute("courseID", (Object)courseID);
        request.setAttribute("originalQuery", (Object)query);
        return mapping.findForward("success-getResults");
    }

    public ActionForward autocomplete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer courseID = WebUtil.readIntParam((HttpServletRequest)request, (String)"courseID", (boolean)true);
        if (!this.getSecurityService().isGroupMonitor(courseID, this.getUserId(), "autocomplete for find user lessons", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        String query = WebUtil.readStrParam((HttpServletRequest)request, (String)"term", (boolean)true);
        Organisation rootOrg = (Organisation)this.getUserManagementService().findById(Organisation.class, (Serializable)courseID);
        List userSet = this.getUserManagementService().findUsers(query, rootOrg.getOrganisationId(), true);
        ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
        for (User user : userSet) {
            ObjectNode jsonObject = JsonNodeFactory.instance.objectNode();
            jsonObject.put("label", user.getFirstName() + " " + user.getLastName());
            jsonObject.put("value", user.getUserId());
            jsonArray.add((JsonNode)jsonObject);
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(jsonArray);
        return null;
    }

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)wac.getBean("userManagementService");
        }
        return userManagementService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }
}

