/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.contentrepository.exception.RepositoryCheckedException;
import org.lamsfoundation.lams.learningdesign.GroupUser;
import org.lamsfoundation.lams.learningdesign.dao.IGroupUserDAO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.LearningDesignService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.util.LessonDTOComparator;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HomeAction
extends DispatchAction {
    private static Logger log = Logger.getLogger(HomeAction.class);
    private static IUserManagementService userManagementService;
    private static ILessonService lessonService;
    private static ILearningDesignService learningDesignService;
    private static IGroupUserDAO groupUserDAO;
    private static IWorkspaceManagementService workspaceManagementService;
    private static ISecurityService securityService;

    public ActionForward sysadmin(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request sysadmin");
            int orgId = new Integer(req.getParameter("orgId"));
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"admin: User missing from session. ");
                return mapping.findForward("error");
            }
            if (this.getUserManagementService().isUserInRole(user.getUserID(), Integer.valueOf(orgId), "SYSADMIN")) {
                log.debug((Object)"user is sysadmin");
                return mapping.findForward("sysadmin");
            }
            log.error((Object)("User " + user.getLogin() + " tried to get sysadmin screen but isn't sysadmin in organisation: " + orgId));
            return this.displayMessage(mapping, req, "error.authorisation");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load sysadmin", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String serverURLContextPath;
            GroupUser groupUser;
            Lesson lesson;
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"learner: User missing from session. ");
                return mapping.findForward("error");
            }
            if (!this.getSecurityService().isLessonLearner(lessonId, user.getUserID(), "access lesson", false)) {
                res.sendError(403, "User is not a learner in the lesson");
                return null;
            }
            String mode = WebUtil.readStrParam((HttpServletRequest)req, (String)"mode", (boolean)true);
            Lesson lesson2 = lesson = lessonId != null ? this.getLessonService().getLesson(lessonId) : null;
            if (!lesson.isLessonStarted()) {
                return this.displayMessage(mapping, req, "message.lesson.not.started.cannot.participate");
            }
            if (!this.getLessonService().checkLessonReleaseConditions(lessonId, user.getUserID())) {
                return this.displayMessage(mapping, req, "message.preceding.lessons.not.finished.cannot.participate");
            }
            if (lesson.isScheduledToCloseForIndividuals() && (groupUser = this.getGroupUserDAO().getGroupUser(lesson, user.getUserID())) != null && groupUser.getScheduledLessonEndDate() != null && groupUser.getScheduledLessonEndDate().before(new Date())) {
                log.error((Object)("learner: User " + user.getLogin() + " cannot access the lesson due to lesson end date has passed."));
                return this.displayMessage(mapping, req, "error.finish.date.passed");
            }
            if (!lesson.isLessonAccessibleForLearner()) {
                return this.displayMessage(mapping, req, "error.lesson.not.accessible.for.learners");
            }
            boolean isLessonIntroWatched = WebUtil.readBooleanParam((HttpServletRequest)req, (String)"isLessonIntroWatched", (boolean)false);
            if (lesson.isEnableLessonIntro().booleanValue() && !isLessonIntroWatched) {
                req.setAttribute("learnerURL", (Object)"learnerURL");
                req.setAttribute("lesson", (Object)lesson);
                req.setAttribute("displayDesignImage", (Object)lesson.isDisplayDesignImage());
                if (lesson.isDisplayDesignImage().booleanValue()) {
                    Long learningDesignId = lesson.getLearningDesign().getLearningDesignId();
                    req.setAttribute("learningDesignID", (Object)learningDesignId);
                }
                return mapping.findForward("lessonIntro");
            }
            if (mode != null) {
                req.setAttribute("mode", (Object)mode);
            }
            serverURLContextPath = (serverURLContextPath = Configuration.get((String)ConfigurationKeys.SERVER_URL_CONTEXT_PATH)).startsWith("/") ? serverURLContextPath : "/" + serverURLContextPath;
            serverURLContextPath = serverURLContextPath + (serverURLContextPath.endsWith("/") ? "" : "/");
            this.getServlet().getServletContext().getContext(serverURLContextPath + "learning").getRequestDispatcher("/content.do?lessonID=" + lessonId).forward((ServletRequest)req, (ServletResponse)res);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Failed to load learner", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward author(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String url = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "authoring/author.do?method=openAuthoring";
        Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)req, (String)"learningDesignID", (boolean)true);
        if (learningDesignID != null) {
            url = url + "&learningDesignID=" + learningDesignID;
        }
        res.sendRedirect(url);
        return null;
    }

    public ActionForward monitorLesson(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Lesson lesson;
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
        UserDTO user = this.getUser();
        if (user == null) {
            log.error((Object)"User missing from session. Can not open Lesson Monitor.");
            return mapping.findForward("error");
        }
        Lesson lesson2 = lesson = lessonId == null ? null : this.getLessonService().getLesson(lessonId);
        if (lesson == null) {
            log.error((Object)("Lesson " + lessonId + " does not exist. Can not open Lesson Monitor."));
            return mapping.findForward("error");
        }
        String url = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "monitoring/monitoring.do?method=monitorLesson&lessonID=" + lessonId;
        res.sendRedirect(url);
        return null;
    }

    public ActionForward addLesson(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        UserDTO userDTO = this.getUser();
        Integer organisationID = new Integer(WebUtil.readIntParam((HttpServletRequest)req, (String)"organisationID"));
        if (!this.getSecurityService().isGroupMonitor(organisationID, userDTO.getUserID(), "add lesson", false)) {
            res.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        String folderContentsJSON = this.getWorkspaceManagementService().getFolderContentsJSON(null, userDTO.getUserID(), false);
        req.setAttribute("folderContents", (Object)folderContentsJSON);
        ObjectNode users = JsonNodeFactory.instance.objectNode();
        Vector learners = this.getUserManagementService().getUsersFromOrganisationByRole(organisationID, "LEARNER", true);
        for (Object user : learners) {
            ObjectNode userJSON = JsonNodeFactory.instance.objectNode();
            userJSON.put("userID", user.getUserId());
            userJSON.put("firstName", user.getFirstName());
            userJSON.put("lastName", user.getLastName());
            userJSON.put("login", user.getLogin());
            users.withArray("selectedLearners").add((JsonNode)userJSON);
        }
        Vector monitors = this.getUserManagementService().getUsersFromOrganisationByRole(organisationID, "MONITOR", true);
        for (User user : monitors) {
            ObjectNode userJSON = JsonNodeFactory.instance.objectNode();
            userJSON.put("userID", user.getUserId());
            userJSON.put("firstName", user.getFirstName());
            userJSON.put("lastName", user.getLastName());
            userJSON.put("login", user.getLogin());
            if (userDTO.getUserID().equals(user.getUserId())) {
                users.withArray("selectedMonitors").add((JsonNode)userJSON);
                continue;
            }
            users.withArray("unselectedMonitors").add((JsonNode)userJSON);
        }
        req.setAttribute("users", (Object)users.toString());
        Organisation organisation = (Organisation)this.getUserManagementService().findById(Organisation.class, (Serializable)organisationID);
        TreeSet<LessonDTO> availableLessons = new TreeSet<LessonDTO>((Comparator<LessonDTO>)new LessonDTOComparator());
        for (Lesson availableLesson : organisation.getLessons()) {
            Integer availableLessonState = availableLesson.getLessonStateId();
            if (Lesson.REMOVED_STATE.equals(availableLessonState) || Lesson.FINISHED_STATE.equals(availableLessonState)) continue;
            availableLessons.add(new LessonDTO(availableLesson));
        }
        req.setAttribute("availablePrecedingLessons", availableLessons);
        return mapping.findForward("addLesson");
    }

    public ActionForward getFolderContents(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws UserAccessDeniedException, IOException, RepositoryCheckedException {
        Integer folderID = WebUtil.readIntParam((HttpServletRequest)req, (String)"folderID", (boolean)true);
        boolean allowInvalidDesigns = WebUtil.readBooleanParam((HttpServletRequest)req, (String)"allowInvalidDesigns", (boolean)false);
        String folderContentsJSON = this.getWorkspaceManagementService().getFolderContentsJSON(folderID, this.getUser().getUserID(), allowInvalidDesigns);
        res.setContentType("application/json;charset=UTF-8");
        res.getWriter().print(folderContentsJSON);
        return null;
    }

    public ActionForward getLearningDesignThumbnail(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)req, (String)"ldId");
        String imagePath = LearningDesignService.getLearningDesignSVGPath((long)learningDesignId);
        File imageFile = new File(imagePath);
        if (!imageFile.canRead()) {
            res.sendError(404);
            return null;
        }
        boolean download = WebUtil.readBooleanParam((HttpServletRequest)req, (String)"download", (boolean)false);
        if (download) {
            String name = this.getLearningDesignService().getLearningDesignDTO(learningDesignId, this.getUser().getLocaleLanguage()).getTitle();
            name = name + ".svg";
            name = FileUtil.encodeFilenameForDownload((HttpServletRequest)req, (String)name);
            res.setContentType("application/x-download");
            res.setHeader("Content-Disposition", "attachment;filename=" + name);
        } else {
            res.setContentType("image/svg+xml");
        }
        FileInputStream input = new FileInputStream(imagePath);
        ServletOutputStream output = res.getOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)output);
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
        return null;
    }

    public ActionForward logout(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.getSession().invalidate();
        return mapping.findForward("index");
    }

    private ActionForward displayMessage(ActionMapping mapping, HttpServletRequest req, String messageKey) {
        req.setAttribute("messageKey", (Object)messageKey);
        return mapping.findForward("message");
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private ILearningDesignService getLearningDesignService() {
        if (learningDesignService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignService");
        }
        return learningDesignService;
    }

    private IGroupUserDAO getGroupUserDAO() {
        if (groupUserDAO == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            groupUserDAO = (IGroupUserDAO)ctx.getBean("groupUserDAO");
        }
        return groupUserDAO;
    }

    private IWorkspaceManagementService getWorkspaceManagementService() {
        if (workspaceManagementService == null) {
            WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            workspaceManagementService = (IWorkspaceManagementService)webContext.getBean("workspaceManagementService");
        }
        return workspaceManagementService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)webContext.getBean("securityService");
        }
        return securityService;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser(UserDTO dto) {
        return this.getUserManagementService().getUserByLogin(dto.getLogin());
    }
}

