/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.security.UniversalLoginModule;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginAsAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        IUserManagementService service = (IUserManagementService)ctx.getBean("userManagementService");
        MessageService messageService = (MessageService)ctx.getBean("centralMessageService");
        IntegrationService integrationService = (IntegrationService)ctx.getBean("integrationService");
        String login = WebUtil.readStrParam((HttpServletRequest)request, (String)"login", (boolean)false);
        if (service.isUserSysAdmin()) {
            User user;
            if (login != null && login.trim().length() > 0 && (user = service.getUserByLogin(login)) != null) {
                boolean isIntegrationUser;
                Boolean allowDirectAccessIntegrationLearner = Configuration.getAsBoolean((String)ConfigurationKeys.ALLOW_DIRECT_ACCESS_FOR_INTEGRATION_LEARNERS);
                if (!allowDirectAccessIntegrationLearner.booleanValue() && (isIntegrationUser = integrationService.isIntegrationUser(user.getUserId())) && this.isOnlyLearner(service, user.getUserId())) {
                    request.setAttribute("errorName", (Object)"Login As");
                    request.setAttribute("errorMessage", (Object)messageService.getMessage("error.cannot.login.as.with.not.allow.direct.access"));
                    return mapping.findForward("error");
                }
                UserDTO sysadmin = (UserDTO)SessionManager.getSession().getAttribute("user");
                ILogEventService logEventService = (ILogEventService)ctx.getBean("logEventService");
                Object[] args = new String[]{sysadmin.getLogin() + " (" + sysadmin.getUserID() + ")", login};
                String message = messageService.getMessage("audit.admin.loginas", args);
                logEventService.logEvent(Integer.valueOf(12), sysadmin.getUserID(), user.getUserId(), null, null, message);
                request.setAttribute("login", (Object)login);
                String token = "#LAMS" + RandomPasswordGenerator.nextPassword((int)10);
                request.setAttribute("password", (Object)token);
                UniversalLoginModule.setAuthenticationToken(token);
                return new ActionForward("/login.jsp?redirectURL=/lams/index.jsp");
            }
        } else {
            request.setAttribute("errorName", (Object)"Login As");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        return mapping.findForward("usersearch");
    }

    private boolean isOnlyLearner(IUserManagementService service, Integer userId) {
        Map orgRoleSets = service.getRolesForUser(userId);
        for (Set orgRoleSet : orgRoleSets.values()) {
            for (Integer role : orgRoleSet) {
                if (!role.equals(Role.ROLE_AUTHOR) && !role.equals(Role.ROLE_MONITOR) && !role.equals(Role.ROLE_GROUP_MANAGER) && !role.equals(Role.ROLE_GROUP_ADMIN) && !role.equals(Role.ROLE_SYSADMIN)) continue;
                return false;
            }
        }
        return true;
    }
}

