/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.imsglobal.lti.launch.LtiLaunch;
import org.imsglobal.lti.launch.LtiOauthVerifier;
import org.imsglobal.lti.launch.LtiVerificationException;
import org.imsglobal.lti.launch.LtiVerificationResult;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtServerLessonMap;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.integration.util.LtiUtils;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.HashUtil;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginRequestLtiServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LoginRequestLtiServlet.class);
    private static IntegrationService integrationService = null;
    private static IUserManagementService userManagementService = null;
    private final String DEFAULT_FIRST_NAME = "John";
    private final String DEFAULT_LAST_NAME = "Doe";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initServices();
        String extUsername = request.getParameter("user_id");
        String roles = request.getParameter("roles");
        String firstName = request.getParameter("lis_person_name_given");
        String lastName = request.getParameter("lis_person_name_family");
        String email = request.getParameter("lis_person_contact_email_primary");
        String locale = request.getParameter("launch_presentation_locale");
        String countryIsoCode = LoginRequestLtiServlet.getCountry(locale);
        String langIsoCode = LoginRequestLtiServlet.getLanguage(locale);
        String consumerKey = request.getParameter("oauth_consumer_key");
        String resourceLinkId = request.getParameter("resource_link_id");
        String contextId = request.getParameter("context_id");
        String contextLabel = request.getParameter("context_label");
        if (extUsername == null || consumerKey == null) {
            response.sendError(400, "Login Failed - login parameters missing");
            return;
        }
        ExtServer extServer = integrationService.getExtServer(consumerKey);
        String secret = extServer.getServerkey();
        LtiVerificationResult ltiResult = null;
        try {
            LtiOauthVerifier ltiVerifier = new LtiOauthVerifier();
            ltiResult = ltiVerifier.verify(request, secret);
        }
        catch (LtiVerificationException e) {
            log.error((Object)"Authentication error: ", (Throwable)e);
            response.sendError(401, "Login Failed - authentication error. " + e.getMessage());
            return;
        }
        LtiLaunch ltiLaunch = ltiResult.getLtiLaunchResult();
        if (!ltiResult.getSuccess().booleanValue()) {
            log.warn((Object)("Authentication error: " + ltiResult.getMessage()));
            response.sendError(401, "Login Failed - authentication error. " + ltiResult.getMessage());
            return;
        }
        if (StringUtils.isBlank((String)firstName)) {
            firstName = "John";
        }
        if (StringUtils.isBlank((String)firstName)) {
            lastName = "Doe";
        }
        ExtServerLessonMap lesson = integrationService.getLtiConsumerLesson(consumerKey, resourceLinkId);
        boolean isCustomMonitorRole = LtiUtils.isToolConsumerCustomRole((String)roles, (String)extServer.getLtiToolConsumerMonitorRoles());
        String method = LtiUtils.isStaff((String)roles) || LtiUtils.isAdmin((String)roles) || isCustomMonitorRole ? (lesson == null ? "author" : "monitor") : "learnerStrictAuth";
        String lessonId = lesson == null ? "" : lesson.getLessonId().toString();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String plaintext = timestamp.toLowerCase().trim() + extUsername.toLowerCase().trim() + method.toLowerCase().trim() + ("learnerStrictAuth".equals(method) ? lessonId : "") + consumerKey.toLowerCase().trim() + secret.toLowerCase().trim();
        String hash = HashUtil.sha1((String)plaintext);
        try {
            URIBuilder redirectUrl = new URIBuilder("lti.do");
            redirectUrl.addParameter("_method", method);
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String paramName = (String)e.nextElement();
                if (!"oauth_consumer_key".equals(paramName) && paramName.startsWith("oauth_")) continue;
                redirectUrl.addParameter(paramName, request.getParameter(paramName));
            }
            URIBuilder url = new URIBuilder("LoginRequest");
            url.addParameter("uid", URLEncoder.encode(extUsername, "UTF8"));
            url.addParameter("method", method);
            url.addParameter("ts", timestamp);
            url.addParameter("sid", consumerKey);
            url.addParameter("hash", hash);
            url.addParameter("courseid", contextId);
            url.addParameter("courseName", contextLabel);
            url.addParameter("country", countryIsoCode);
            url.addParameter("lang", langIsoCode);
            url.addParameter("firstName", firstName);
            url.addParameter("lastName", lastName);
            url.addParameter("lsid", lessonId);
            url.addParameter("email", email);
            url.addParameter("redirectURL", redirectUrl.build().toString());
            response.sendRedirect(response.encodeRedirectURL(url.build().toString()));
        }
        catch (URISyntaxException e) {
            throw new ServletException("Error creating URL for LoginRequest", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static String getLanguage(String localeStr) {
        if (localeStr == null) {
            return "xx";
        }
        String[] split = localeStr.split("_");
        return split[0];
    }

    private static String getCountry(String localeStr) {
        if (localeStr == null) {
            return "XX";
        }
        String[] split = localeStr.split("_");
        String country = split.length > 1 ? split[1] : "AU";
        return country;
    }

    private void initServices() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        }
        if (userManagementService == null) {
            userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
        }
    }
}

