/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NotificationAction
extends DispatchAction {
    private static IEventNotificationService eventNotificationService;

    public ActionForward getNotificationSubscriptions(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Integer limit = WebUtil.readIntParam((HttpServletRequest)req, (String)"limit", (boolean)true);
        Integer offset = WebUtil.readIntParam((HttpServletRequest)req, (String)"offset", (boolean)true);
        List subscriptions = this.getEventNotificationService().getNotificationSubscriptions(null, this.getUser().getUserID(), false, limit, offset);
        ArrayNode responseJSON = JsonNodeFactory.instance.arrayNode();
        for (Subscription subscription : subscriptions) {
            Event event = subscription.getEvent();
            ObjectNode subscriptionJSON = JsonNodeFactory.instance.objectNode();
            subscriptionJSON.put("subscriptionUid", subscription.getUid());
            subscriptionJSON.put("message", event.getMessage());
            subscriptionJSON.put("pending", subscription.getLastOperationMessage() == null);
            responseJSON.add((JsonNode)subscriptionJSON);
        }
        if (responseJSON.size() > 0) {
            res.setContentType("application/json;charset=UTF-8");
            res.getWriter().print(responseJSON.toString());
        }
        return null;
    }

    public ActionForward markNotificationAsRead(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) {
        long subscriptionUid = WebUtil.readLongParam((HttpServletRequest)req, (String)"subscriptionUid");
        this.getEventNotificationService().triggerForSingleUser(Long.valueOf(subscriptionUid), null, null);
        return null;
    }

    public ActionForward getPendingNotificationCount(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException {
        long count = this.getEventNotificationService().getNotificationPendingCount(null, this.getUser().getUserID());
        res.setContentType("text/plain;charset=UTF-8");
        res.getWriter().print(count);
        return null;
    }

    private IEventNotificationService getEventNotificationService() {
        if (eventNotificationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            eventNotificationService = (IEventNotificationService)ctx.getBean("eventNotificationService");
        }
        return eventNotificationService;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }
}

