/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.contentrepository.exception.InvalidParameterException;
import org.lamsfoundation.lams.integration.dto.ExtGroupDTO;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationGroup;
import org.lamsfoundation.lams.usermanagement.OrganisationGrouping;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationGroupingDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.AlphanumComparator;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OrganisationGroupAction
extends DispatchAction {
    private static Logger log = Logger.getLogger(OrganisationGroupAction.class);
    private static IUserManagementService userManagementService;
    private static ICoreLearnerService learnerService;
    private static ILessonService lessonService;
    private static ISecurityService securityService;
    private static IIntegrationService integrationService;
    private static final String MAPPING_VIEW_GROUPINGS = "viewGroupings";
    private static final String MAPPING_VIEW_GROUPS = "viewGroups";
    private static final String MAPPING_VIEW_EXT_GROUPS = "viewExtGroups";

    public ActionForward viewGroupings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean lessonGroupsExist;
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID", (boolean)true);
        Integer userId = this.getUserDTO().getUserID();
        Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)true);
        Organisation organisation = null;
        if (organisationId == null) {
            organisation = ((Lesson)this.getUserManagementService().findById(Lesson.class, (Serializable)lessonId)).getOrganisation();
            organisationId = organisation.getOrganisationId();
        }
        if (organisation == null) {
            organisation = (Organisation)this.getUserManagementService().findById(Organisation.class, (Serializable)organisationId);
        }
        if (OrganisationType.CLASS_TYPE.equals(organisation.getOrganisationType().getOrganisationTypeId())) {
            organisation = organisation.getParentOrganisation();
            organisationId = organisation.getOrganisationId();
        }
        if (!this.getSecurityService().hasOrgRole(organisationId, userId, new String[]{"GROUP ADMIN", "GROUP MANAGER", "MONITOR", "AUTHOR"}, "view organisation groupings", false)) {
            response.sendError(403, "User is not a participant in the organisation");
            return null;
        }
        List orgGroupings = this.getUserManagementService().findByProperty(OrganisationGrouping.class, "organisationId", (Object)organisationId);
        Grouping grouping = this.getLessonGrouping(activityID);
        boolean bl = lessonGroupsExist = grouping != null && grouping.getGroups() != null && !grouping.getGroups().isEmpty() && !this.isDefaultChosenGrouping(grouping);
        if (lessonGroupsExist || activityID != null && orgGroupings.isEmpty()) {
            return this.viewGroups(mapping, form, request, response);
        }
        boolean isUsedForBranching = grouping != null && grouping.isUsedForBranching();
        request.setAttribute("usedForBranching", (Object)isUsedForBranching);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Displaying course groupings for user " + userId + " and organisation " + organisationId));
        }
        request.setAttribute("organisationID", (Object)organisationId);
        if (!isUsedForBranching && this.getIntegrationService().isIntegratedServerGroupFetchingAvailable(lessonId)) {
            if (lessonId == null) {
                Activity activity = this.getLearnerService().getActivity(activityID);
                lessonId = this.getLearnerService().getLessonByActivity(activity).getLessonId();
                request.setAttribute("lessonID", (Object)lessonId);
            }
            List extGroups = this.getIntegrationService().getExtGroups(lessonId, null);
            request.setAttribute("extGroups", (Object)extGroups);
            return mapping.findForward(MAPPING_VIEW_EXT_GROUPS);
        }
        boolean isGroupSuperuser = this.getUserManagementService().isUserInRole(userId, organisationId, "GROUP ADMIN") || this.getUserManagementService().isUserInRole(userId, organisationId, "GROUP MANAGER");
        request.setAttribute("canEdit", (Object)(isGroupSuperuser || activityID != null ? 1 : 0));
        TreeSet<OrganisationGroupingDTO> orgGroupingDTOs = new TreeSet<OrganisationGroupingDTO>();
        for (OrganisationGrouping orgGrouping : orgGroupings) {
            orgGroupingDTOs.add(new OrganisationGroupingDTO(orgGrouping));
        }
        request.setAttribute("groupings", orgGroupingDTOs);
        return mapping.findForward(MAPPING_VIEW_GROUPINGS);
    }

    public ActionForward viewGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set lessonGroups;
        String[] extGroupIds;
        boolean isGroupSuperuser;
        Integer userId = this.getUserDTO().getUserID();
        Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)true);
        Lesson lesson = null;
        if (organisationId == null) {
            lesson = (Lesson)this.getUserManagementService().findById(Lesson.class, (Serializable)lessonId);
            organisationId = lesson.getOrganisation().getOrganisationId();
        }
        request.setAttribute("lessonID", (Object)lessonId);
        if (!this.getSecurityService().hasOrgRole(organisationId, userId, new String[]{"GROUP ADMIN", "GROUP MANAGER", "MONITOR", "AUTHOR"}, "view organisation groups", false)) {
            response.sendError(403, "User is not a participant in the organisation");
            return null;
        }
        boolean bl = isGroupSuperuser = this.getUserManagementService().isUserInRole(userId, organisationId, "GROUP ADMIN") || this.getUserManagementService().isUserInRole(userId, organisationId, "GROUP MANAGER");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Displaying course groups for user " + userId + " and organisation " + organisationId));
        }
        Long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID", (boolean)true);
        request.setAttribute("canEdit", (Object)(isGroupSuperuser || activityId != null ? 1 : 0));
        ObjectNode orgGroupingJSON = JsonNodeFactory.instance.objectNode();
        orgGroupingJSON.put("organisationId", organisationId);
        Long orgGroupingId = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupingId", (boolean)true);
        OrganisationGrouping orgGrouping = null;
        if (orgGroupingId != null && (orgGrouping = (OrganisationGrouping)this.getUserManagementService().findById(OrganisationGrouping.class, (Serializable)orgGroupingId)) != null) {
            orgGroupingJSON.put("groupingId", orgGroupingId);
            orgGroupingJSON.put("name", orgGrouping.getName());
        }
        boolean isExternalGroupsSelected = (extGroupIds = request.getParameterValues("extGroupIds")) != null && extGroupIds.length > 0;
        Grouping lessonGrouping = this.getLessonGrouping(activityId);
        Set set = lessonGroups = lessonGrouping == null ? null : lessonGrouping.getGroups();
        if (activityId != null && lessonGrouping != null && (isExternalGroupsSelected || orgGroupingId != null) && this.isDefaultChosenGrouping(lessonGrouping)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing default groups for grouping " + orgGroupingId));
            }
            HashSet<Long> groupIDs = new HashSet<Long>(lessonGroups.size());
            for (Group group : lessonGroups) {
                groupIDs.add(group.getGroupId());
            }
            for (Long groupId : groupIDs) {
                this.getLessonService().removeGroup(lessonGrouping, groupId);
            }
            lessonGroups = null;
        }
        boolean isUsedForBranching = lessonGrouping != null && lessonGrouping.isUsedForBranching();
        request.setAttribute("usedForBranching", (Object)isUsedForBranching);
        ArrayNode orgGroupsJSON = JsonNodeFactory.instance.arrayNode();
        Collection learners = null;
        if (isExternalGroupsSelected) {
            if (lesson == null) {
                lesson = (Lesson)this.getUserManagementService().findById(Lesson.class, (Serializable)lessonId);
            }
            learners = lesson.getLessonClass().getLearners();
            List extGroups = this.getIntegrationService().getExtGroups(lessonId, extGroupIds);
            if (extGroups != null) {
                ArrayList allDuplicates = new ArrayList();
                for (ExtGroupDTO groupA : extGroups) {
                    for (ExtGroupDTO groupB : extGroups) {
                        List usersA = groupA.getUsers();
                        List usersB = groupB.getUsers();
                        if (usersA == null || usersB == null || groupA.getGroupId().equals(groupB.getGroupId())) continue;
                        Collection duplicates = CollectionUtils.intersection((Collection)usersA, (Collection)usersB);
                        allDuplicates.addAll(duplicates);
                        usersA.removeAll(duplicates);
                        usersB.removeAll(duplicates);
                    }
                }
                Collections.sort(extGroups);
                for (ExtGroupDTO extGroup : extGroups) {
                    ObjectNode groupJSON = JsonNodeFactory.instance.objectNode();
                    groupJSON.put("name", extGroup.getGroupName());
                    groupJSON.put("groupId", extGroup.getGroupId());
                    if (extGroup.getUsers() != null) {
                        for (User groupUser : extGroup.getUsers()) {
                            ObjectNode groupUserJSON = WebUtil.userToJSON((User)groupUser);
                            groupJSON.withArray("users").add((JsonNode)groupUserJSON);
                            learners.remove(groupUser);
                        }
                    }
                    orgGroupsJSON.add((JsonNode)groupJSON);
                }
            }
        } else if (lessonGroups == null || lessonGroups.isEmpty()) {
            learners = this.getUserManagementService().getUsersFromOrganisationByRole(organisationId, "LEARNER", true);
            Set orgGroups = orgGrouping == null ? null : orgGrouping.getGroups();
            orgGroupsJSON = this.getOrgGroupsDetails(orgGroups, learners);
        } else {
            if (lesson == null) {
                lesson = (Lesson)this.getUserManagementService().findById(Lesson.class, (Serializable)lessonId);
            }
            learners = lesson.getLessonClass().getLearners();
            orgGroupsJSON = this.getLessonGroupsDetails(lessonGroups, learners);
            request.setAttribute("skipInitialAssigning", (Object)true);
        }
        orgGroupingJSON.set("groups", (JsonNode)orgGroupsJSON);
        request.setAttribute("grouping", (Object)orgGroupingJSON);
        ArrayNode unassignedUsersJSON = JsonNodeFactory.instance.arrayNode();
        for (User unassignedUser : learners) {
            ObjectNode unassignedUserJSON = WebUtil.userToJSON((User)unassignedUser);
            unassignedUsersJSON.add((JsonNode)unassignedUserJSON);
        }
        request.setAttribute("unassignedUsers", (Object)unassignedUsersJSON);
        return mapping.findForward(MAPPING_VIEW_GROUPS);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InvalidParameterException, IOException {
        ObjectNode orgGroupingJSON;
        Long orgGroupingId;
        Integer userId = this.getUserDTO().getUserID();
        int organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        if (!this.getSecurityService().hasOrgRole(Integer.valueOf(organisationId), userId, new String[]{"GROUP ADMIN", "GROUP MANAGER"}, "save organisation grouping", false)) {
            response.sendError(403, "User is not a manager or admin in the organisation");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving course groups for user " + userId + " and organisation " + organisationId));
        }
        if ((orgGroupingId = Long.valueOf((orgGroupingJSON = (ObjectNode)new ObjectMapper().readValue(request.getParameter("grouping"), ObjectNode.class)).get("groupingId").asLong())) == 0L) {
            orgGroupingId = null;
        }
        LinkedList<OrganisationGroup> orgGroups = new LinkedList<OrganisationGroup>();
        ArrayNode orgGroupsJSON = JsonUtil.optArray((JsonNode)orgGroupingJSON, (String)"groups");
        if (orgGroupsJSON != null) {
            for (JsonNode orgGroupNode : orgGroupsJSON) {
                HashSet<User> users = new HashSet<User>();
                ObjectNode orgGroupJSON = (ObjectNode)orgGroupNode;
                ArrayNode usersJSON = JsonUtil.optArray((JsonNode)orgGroupJSON, (String)"users");
                if (usersJSON != null) {
                    for (JsonNode learnerId : usersJSON) {
                        User user = (User)this.getUserManagementService().findById(User.class, (Serializable)Integer.valueOf(learnerId.asInt()));
                        users.add(user);
                    }
                }
                OrganisationGroup orgGroup = new OrganisationGroup();
                Long orgGroupId = JsonUtil.optLong((JsonNode)orgGroupJSON, (String)"groupId");
                if (orgGroupId > 0L) {
                    orgGroup.setGroupId(orgGroupId);
                    orgGroup.setGroupingId(orgGroupingId);
                }
                orgGroup.setName(JsonUtil.optString((JsonNode)orgGroupJSON, (String)"name"));
                orgGroup.setUsers(users);
                orgGroups.add(orgGroup);
            }
        }
        OrganisationGrouping orgGrouping = null;
        if (orgGroupingId != null) {
            orgGrouping = (OrganisationGrouping)this.getUserManagementService().findById(OrganisationGrouping.class, (Serializable)orgGroupingId);
        }
        if (orgGrouping == null) {
            orgGrouping = new OrganisationGrouping();
            orgGrouping.setOrganisationId(Integer.valueOf(organisationId));
        }
        String orgGroupingName = JsonUtil.optString((JsonNode)orgGroupingJSON, (String)"name");
        orgGrouping.setName(orgGroupingName);
        this.getUserManagementService().saveOrganisationGrouping(orgGrouping, orgGroups);
        return null;
    }

    public ActionForward removeGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId = this.getUserDTO().getUserID();
        int organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        if (!this.getSecurityService().hasOrgRole(Integer.valueOf(organisationId), userId, new String[]{"GROUP ADMIN", "GROUP MANAGER"}, "remove organisation grouping", false)) {
            response.sendError(403, "User is not a manager or admin in the organisation");
            return null;
        }
        Long groupingId = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupingId");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing grouping " + groupingId + " for user " + userId + " and organisation " + organisationId));
        }
        this.getUserManagementService().deleteById(OrganisationGrouping.class, (Serializable)groupingId);
        return this.viewGroupings(mapping, form, request, response);
    }

    public ActionForward getGroupsForMapping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long orgGroupingId = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupingId");
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        OrganisationGrouping orgGrouping = (OrganisationGrouping)this.getUserManagementService().findById(OrganisationGrouping.class, (Serializable)orgGroupingId);
        ArrayNode groupsJSON = JsonNodeFactory.instance.arrayNode();
        TreeSet orgGroups = new TreeSet(orgGrouping.getGroups());
        for (OrganisationGroup group : orgGroups) {
            ObjectNode groupJSON = JsonNodeFactory.instance.objectNode();
            groupJSON.put("id", group.getGroupId());
            groupJSON.put("name", group.getName());
            groupsJSON.add((JsonNode)groupJSON);
        }
        Activity activity = (Activity)this.getUserManagementService().findById(Activity.class, (Serializable)activityID);
        Grouping grouping = activity.isGroupingActivity() ? ((GroupingActivity)activity).getCreateGrouping() : ((BranchingActivity)activity).getGrouping();
        ArrayNode branchesJSON = JsonNodeFactory.instance.arrayNode();
        TreeSet groups = new TreeSet(grouping.getGroups());
        for (Group group : groups) {
            ObjectNode groupJSON = JsonNodeFactory.instance.objectNode();
            groupJSON.put("id", group.getGroupId());
            groupJSON.put("name", group.getGroupName());
            branchesJSON.add((JsonNode)groupJSON);
        }
        ObjectNode responseJSON = JsonNodeFactory.instance.objectNode();
        responseJSON.set("branches", (JsonNode)branchesJSON);
        responseJSON.set("groups", (JsonNode)groupsJSON);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward saveGroupMappings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ArrayNode groupMapping = JsonUtil.readArray((String)request.getParameter("mapping"));
        for (JsonNode entryNode : groupMapping) {
            ObjectNode entry = (ObjectNode)entryNode;
            Long orgGroupID = JsonUtil.optLong((JsonNode)entry, (String)"groupID");
            Long branchingGroupID = JsonUtil.optLong((JsonNode)entry, (String)"branchID");
            OrganisationGroup orgGroup = (OrganisationGroup)this.getUserManagementService().findById(OrganisationGroup.class, (Serializable)orgGroupID);
            Group branchingGroup = (Group)this.getUserManagementService().findById(Group.class, (Serializable)branchingGroupID);
            branchingGroup.getUsers().addAll(orgGroup.getUsers());
            this.getUserManagementService().save((Object)branchingGroup);
        }
        response.setContentType("text/plain;charset=utf-8");
        response.getWriter().write("OK");
        return null;
    }

    private ArrayNode getLessonGroupsDetails(Set<Group> groups, Collection<User> learners) {
        ArrayNode groupsJSON = JsonNodeFactory.instance.arrayNode();
        if (groups != null) {
            LinkedList<Group> groupList = new LinkedList<Group>(groups);
            Collections.sort(groupList, new GroupComparator());
            for (Group group : groupList) {
                ObjectNode groupJSON = JsonNodeFactory.instance.objectNode();
                groupJSON.put("name", group.getGroupName());
                groupJSON.put("groupId", group.getGroupId());
                groupJSON.put("locked", !group.mayBeDeleted());
                if (group.getUsers() != null) {
                    for (User groupUser : group.getUsers()) {
                        ObjectNode groupUserJSON = WebUtil.userToJSON((User)groupUser);
                        groupJSON.withArray("users").add((JsonNode)groupUserJSON);
                        learners.remove(groupUser);
                    }
                }
                groupsJSON.add((JsonNode)groupJSON);
            }
        }
        return groupsJSON;
    }

    private ArrayNode getOrgGroupsDetails(Set<OrganisationGroup> groups, Collection<User> learners) {
        Comparator<OrganisationGroup> ORG_GROUP_COMPARATOR = new Comparator<OrganisationGroup>(){

            @Override
            public int compare(OrganisationGroup o1, OrganisationGroup o2) {
                String grp1Name = o1 != null ? o1.getName() : "";
                String grp2Name = o2 != null ? o2.getName() : "";
                AlphanumComparator comparator = new AlphanumComparator();
                return comparator.compare(grp1Name, grp2Name);
            }
        };
        ArrayNode groupsJSON = JsonNodeFactory.instance.arrayNode();
        if (groups != null) {
            LinkedList<OrganisationGroup> groupList = new LinkedList<OrganisationGroup>(groups);
            Collections.sort(groupList, ORG_GROUP_COMPARATOR);
            for (OrganisationGroup group : groupList) {
                ObjectNode groupJSON = JsonNodeFactory.instance.objectNode();
                groupJSON.put("name", group.getName());
                groupJSON.put("groupId", group.getGroupId());
                for (User groupUser : group.getUsers()) {
                    ObjectNode groupUserJSON = WebUtil.userToJSON((User)groupUser);
                    groupJSON.withArray("users").add((JsonNode)groupUserJSON);
                    learners.remove(groupUser);
                }
                groupsJSON.add((JsonNode)groupJSON);
            }
        }
        return groupsJSON;
    }

    private Grouping getLessonGrouping(Long activityID) {
        if (activityID != null) {
            Activity activity = (Activity)this.getUserManagementService().findById(Activity.class, (Serializable)activityID);
            Grouping grouping = activity.isChosenBranchingActivity() ? activity.getGrouping() : ((GroupingActivity)this.getUserManagementService().findById(GroupingActivity.class, (Serializable)activityID)).getCreateGrouping();
            return grouping;
        }
        return null;
    }

    private boolean isDefaultChosenGrouping(Grouping grouping) {
        Set groups = grouping.getGroups();
        for (Group group : groups) {
            if (group.getUsers().isEmpty()) continue;
            return false;
        }
        return groups != null && (grouping.getMaxNumberOfGroups() == null || grouping.getMaxNumberOfGroups().equals(groups.size()));
    }

    private UserDTO getUserDTO() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private ICoreLearnerService getLearnerService() {
        if (learnerService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learnerService = (ICoreLearnerService)ctx.getBean("learnerService");
        }
        return learnerService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }

    private IIntegrationService getIntegrationService() {
        if (integrationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            integrationService = (IIntegrationService)ctx.getBean("integrationService");
        }
        return integrationService;
    }
}

