/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.security.Principal;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.jboss.security.CacheableManager;
import org.lamsfoundation.lams.security.SimplePrincipal;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class SessionListener
implements HttpSessionListener {
    private static int timeout;
    private static CacheableManager<?, Principal> authenticationManager;
    private static Logger log;

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        if (sessionEvent == null) {
            return;
        }
        HttpSession session = sessionEvent.getSession();
        session.setMaxInactiveInterval(timeout);
        if (session != null) {
            String[] defaults = LanguageUtil.getDefaultLangCountry();
            Locale preferredLocale = new Locale(defaults[0] == null ? "" : defaults[0], defaults[1] == null ? "" : defaults[1]);
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)preferredLocale);
            Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)preferredLocale);
        }
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        HttpSession session;
        if (authenticationManager == null) {
            try {
                InitialContext initialContext = new InitialContext();
                authenticationManager = (CacheableManager)initialContext.lookup("java:jboss/jaas/lams/authenticationMgr");
            }
            catch (NamingException e) {
                log.error((Object)"Error while getting authentication manager.", (Throwable)e);
            }
        }
        if ((session = sessionEvent.getSession()) != null) {
            SessionManager.removeSessionByID((String)session.getId(), (boolean)false, (boolean)true);
            UserDTO userDTO = (UserDTO)session.getAttribute("user");
            if (userDTO != null) {
                String login = userDTO.getLogin();
                SimplePrincipal principal = new SimplePrincipal(login);
                authenticationManager.flushCache((Object)principal);
                SessionManager.removeSessionByLogin((String)login, (boolean)false);
            }
        }
    }

    static {
        log = Logger.getLogger(SessionListener.class);
        timeout = Configuration.getAsInt((String)ConfigurationKeys.INACTIVE_TIME);
    }
}

