/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TutorialAction
extends DispatchAction {
    private static Logger log = Logger.getLogger(TutorialAction.class);
    private static IUserManagementService service;

    public ActionForward disableSingleTutorialVideo(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) {
        String pageString = WebUtil.readStrParam((HttpServletRequest)req, (String)"pageString");
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        User user = this.getService().getUserByLogin(userDTO.getLogin());
        user.getPagesWithDisabledTutorials().add(pageString);
        this.getService().saveUser(user);
        ss.setAttribute("user", (Object)user.getUserDTO());
        return null;
    }

    public ActionForward enableSingleTutorialVideo(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) {
        String pageString = WebUtil.readStrParam((HttpServletRequest)req, (String)"pageString");
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        User user = this.getService().getUserByLogin(userDTO.getLogin());
        user.getPagesWithDisabledTutorials().remove(pageString);
        this.getService().saveUser(user);
        ss.setAttribute("user", (Object)user.getUserDTO());
        return null;
    }

    public ActionForward getDoNotShowAgainValue(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String pageString = WebUtil.readStrParam((HttpServletRequest)req, (String)"pageString");
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        Boolean doNotShowAgain = userDTO.getPagesWithDisabledTutorials() != null && userDTO.getPagesWithDisabledTutorials().contains(pageString);
        res.setContentType("text/plain");
        PrintWriter writer = res.getWriter();
        writer.println(doNotShowAgain.toString());
        return null;
    }

    public ActionForward disableAllTutorialVideos(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException {
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        User user = this.getService().getUserByLogin(userDTO.getLogin());
        user.setTutorialsDisabled(Boolean.valueOf(true));
        this.getService().saveUser(user);
        ss.setAttribute("user", (Object)user.getUserDTO());
        return null;
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }
}

