/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.imsglobal.lti.BasicLTIUtil;
import org.lamsfoundation.lams.contentrepository.exception.RepositoryCheckedException;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtServerLessonMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LtiAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(LtiAction.class);
    private static IIntegrationService integrationService = null;
    private static IMonitoringService monitoringService = null;
    private static IUserManagementService userManagementService = null;
    private static ILearningDesignService learningDesignService;
    private static ILessonService lessonService;
    private static IWorkspaceManagementService workspaceManagementService;
    private static ISecurityService securityService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, UserAccessDeniedException, RepositoryCheckedException, UserInfoFetchException, UserInfoValidationException {
        String method;
        this.initServices();
        String consumerKey = request.getParameter("oauth_consumer_key");
        String resourceLinkId = request.getParameter("resource_link_id");
        String tcGradebookId = request.getParameter("lis_result_sourcedid");
        String extUserId = request.getParameter("user_id");
        ExtServerLessonMap lesson = integrationService.getLtiConsumerLesson(consumerKey, resourceLinkId);
        boolean isContentItemSelection = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"custom_isContentItemSelection", (boolean)false);
        if (lesson == null && isContentItemSelection) {
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"custom_lessonId");
            lesson = integrationService.getExtServerLessonMap(lessonId);
            lesson.setResourceLinkId(resourceLinkId);
            userManagementService.save((Object)lesson);
        }
        String lessonFinishCallbackUrl = request.getParameter("lis_outcome_service_url");
        ExtServer extServer = integrationService.getExtServer(consumerKey);
        if (StringUtils.isNotBlank((String)lessonFinishCallbackUrl) && StringUtils.isBlank((String)extServer.getLessonFinishUrl())) {
            extServer.setLessonFinishUrl(lessonFinishCallbackUrl);
            userManagementService.save((Object)extServer);
        }
        if ("learnerStrictAuth".equals(method = request.getParameter("_method")) && lesson == null) {
            String errorMsg = "Learner tries to access the link that hasn't been authored by teacher yet. resource_link_id: " + tcGradebookId;
            log.debug((Object)errorMsg);
            request.setAttribute("error", (Object)errorMsg);
            request.setAttribute("javax.servlet.error.exception", (Object)new UserAccessDeniedException(errorMsg));
            return mapping.findForward("error");
        }
        if (lesson == null) {
            return this.addLesson(mapping, form, request, response);
        }
        ExtUserUseridMap extUserMap = integrationService.getExistingExtUserUseridMap(extServer, extUserId);
        extUserMap.setTcGradebookId(tcGradebookId);
        userManagementService.save((Object)extUserMap);
        return this.learnerMonitor(mapping, form, request, response);
    }

    private ActionForward addLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, UserAccessDeniedException, RepositoryCheckedException, UserInfoFetchException, UserInfoValidationException {
        this.initServices();
        Integer userId = this.getUser().getUserID();
        String contextId = request.getParameter("context_id");
        String consumerKey = request.getParameter("oauth_consumer_key");
        String resourceLinkId = request.getParameter("resource_link_id");
        String resourceLinkTitle = request.getParameter("resource_link_title");
        String resourceLinkDescription = request.getParameter("resource_link_description");
        ExtServer extServer = integrationService.getExtServer(consumerKey);
        ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer.getSid(), contextId);
        Integer organisationId = orgMap.getOrganisation().getOrganisationId();
        if (!securityService.isGroupMonitor(organisationId, userId, "add lesson", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        String folderContentsJSON = workspaceManagementService.getFolderContentsJSON(null, userId, false);
        request.setAttribute("folderContents", (Object)folderContentsJSON);
        request.setAttribute("oauth_consumer_key", (Object)consumerKey);
        request.setAttribute("resource_link_id", (Object)resourceLinkId);
        request.setAttribute("courseId", (Object)organisationId);
        request.setAttribute("context_id", (Object)contextId);
        request.setAttribute("title", (Object)resourceLinkTitle);
        request.setAttribute("desc", (Object)resourceLinkDescription);
        String ltiMessageType = request.getParameter("lti_message_type");
        if ("ContentItemSelectionRequest".equals(ltiMessageType)) {
            String contentItemReturnUrl = request.getParameter("content_item_return_url");
            if (StringUtils.isEmpty((String)contentItemReturnUrl)) {
                response.sendError(400, "ContentItemSelectionRequest is missing content_item_return_url parameter");
                return null;
            }
            request.setAttribute("lti_message_type", (Object)ltiMessageType);
            request.setAttribute("content_item_return_url", (Object)contentItemReturnUrl);
            request.setAttribute("title", (Object)request.getParameter("title"));
            request.setAttribute("desc", (Object)request.getParameter("text").replaceAll("\\<[^>]*>", ""));
            request.setAttribute("data", (Object)request.getParameter("data"));
        }
        return mapping.findForward("addLesson");
    }

    public ActionForward startLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, UserAccessDeniedException, RepositoryCheckedException, UserInfoValidationException, UserInfoFetchException {
        this.initServices();
        Integer userId = this.getUser().getUserID();
        User user = this.getRealUser(this.getUser());
        String consumerKey = request.getParameter("oauth_consumer_key");
        String resourceLinkId = request.getParameter("resource_link_id");
        String title = request.getParameter("title");
        String desc = request.getParameter("desc");
        String ldIdStr = request.getParameter("ldId");
        String contextId = request.getParameter("context_id");
        Integer organisationId = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"courseId"));
        boolean enableLessonIntro = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"enableLessonIntro", (boolean)false);
        if (!securityService.isGroupMonitor(organisationId, userId, "add lesson", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        ExtServer extServer = integrationService.getExtServer(consumerKey);
        Organisation organisation = monitoringService.getOrganisation(organisationId);
        Lesson lesson = monitoringService.initializeLesson(title, desc, new Long(ldIdStr).longValue(), organisation.getOrganisationId(), user.getUserId(), null, Boolean.valueOf(false), Boolean.valueOf(enableLessonIntro), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null);
        LinkedList<User> staffList = new LinkedList<User>();
        staffList.add(user);
        LinkedList learnerList = new LinkedList();
        Vector learnerVector = userManagementService.getUsersFromOrganisationByRole(organisation.getOrganisationId(), "LEARNER", true);
        learnerList.addAll(learnerVector);
        monitoringService.createLessonClassForLesson(lesson.getLessonId().longValue(), organisation, organisation.getName() + "Learners", learnerList, organisation.getName() + "Staff", staffList, user.getUserId());
        monitoringService.startLesson(lesson.getLessonId().longValue(), user.getUserId());
        integrationService.createExtServerLessonMap(lesson.getLessonId(), resourceLinkId, extServer);
        String ltiMessageType = request.getParameter("lti_message_type");
        String contentItemReturnUrl = request.getParameter("content_item_return_url");
        if ("ContentItemSelectionRequest".equals(ltiMessageType)) {
            String opaqueTCData = request.getParameter("data");
            String returnValues = this.postLaunchHTML(extServer, lesson, contentItemReturnUrl, opaqueTCData);
            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("utf-8");
            response.addDateHeader("Expires", System.currentTimeMillis() - 31536000000L);
            response.addDateHeader("Last-Modified", System.currentTimeMillis());
            response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
            response.addHeader("Pragma", "no-cache");
            ServletOutputStream out = response.getOutputStream();
            out.println("<!DOCTYPE html>");
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">");
            out.println("<html>\n<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            out.println("</head>\n<body>");
            out.println(returnValues);
            out.println("</body>\n</html>");
            return null;
        }
        ActionRedirect redirect = new ActionRedirect(mapping.findForwardConfig("learnerMonitorRedirect"));
        redirect.addParameter("oauth_consumer_key", (Object)consumerKey);
        redirect.addParameter("resource_link_id", (Object)resourceLinkId);
        redirect.addParameter("context_id", (Object)contextId);
        return redirect;
    }

    private String postLaunchHTML(ExtServer extServer, Lesson lesson, String contentItemReturnUrl, String opaqueTCData) throws UnsupportedEncodingException {
        String key = extServer.getServerid();
        String secret = extServer.getServerkey();
        Properties properties = new Properties();
        properties.put("lti_message_type", "ContentItemSelection");
        properties.put("lti_version", "LTI-1p0");
        if (StringUtils.isNotBlank((String)opaqueTCData)) {
            properties.put("data", opaqueTCData);
        }
        properties.put("lti_msg", "Information about LAMS lesson has been imported successfully.");
        properties.put("oauth_version", "1.0");
        properties.put("oauth_callback", "about:blank");
        properties.put("oauth_signature_method", "HMAC-SHA1");
        ObjectNode contentItemJSON = JsonNodeFactory.instance.objectNode();
        contentItemJSON.put("@type", "LtiLinkItem");
        contentItemJSON.put("mediaType", "application/vnd.ims.lti.v1.ltilink");
        contentItemJSON.put("title", lesson.getLessonName());
        contentItemJSON.put("text", lesson.getLessonDescription());
        ObjectNode customJSON = JsonNodeFactory.instance.objectNode();
        customJSON.put("lessonId", lesson.getLessonId().toString());
        customJSON.put("isContentItemSelection", "true");
        contentItemJSON.set("custom", (JsonNode)customJSON);
        ObjectNode responseJSON = JsonNodeFactory.instance.objectNode();
        responseJSON.set("@graph", (JsonNode)contentItemJSON);
        responseJSON.put("@context", "http://purl.imsglobal.org/ctx/lti/v1/ContentItem");
        String content_items = URLEncoder.encode(responseJSON.toString(), "UTF-8");
        properties.put("content_items", content_items);
        properties = BasicLTIUtil.signProperties((Properties)properties, (String)contentItemReturnUrl, (String)"POST", (String)key, (String)secret, null, null, null);
        boolean dodebug = false;
        String postData = BasicLTIUtil.postLaunchHTML((Properties)properties, (String)contentItemReturnUrl, (boolean)dodebug);
        return postData;
    }

    public ActionForward learnerMonitor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, UserAccessDeniedException, RepositoryCheckedException, UserInfoValidationException, UserInfoFetchException {
        this.initServices();
        Integer userId = this.getUser().getUserID();
        String consumerKey = request.getParameter("oauth_consumer_key");
        String resourceLinkId = request.getParameter("resource_link_id");
        ExtServerLessonMap extLesson = integrationService.getLtiConsumerLesson(consumerKey, resourceLinkId);
        Long lessonId = extLesson.getLessonId();
        Lesson lesson = (Lesson)userManagementService.findById(Lesson.class, (Serializable)lessonId);
        request.setAttribute("lessonId", (Object)lessonId);
        request.setAttribute("ldId", (Object)lesson.getLearningDesign().getLearningDesignId());
        request.setAttribute("title", (Object)lesson.getLessonName());
        request.setAttribute("description", (Object)lesson.getLessonDescription());
        request.setAttribute("isDisplayDesignImage", (Object)lesson.isDisplayDesignImage());
        boolean isMonitor = securityService.isLessonMonitor(lessonId, userId, "learner monitor", false);
        request.setAttribute("isMonitor", (Object)isMonitor);
        LearnerProgress learnProg = lessonService.getUserProgressForLesson(userId, lessonId);
        if (learnProg != null) {
            LearnerProgressDTO learnerProgress = learnProg.getLearnerProgressData();
            request.setAttribute("learnerProgressDto", (Object)learnerProgress);
        }
        return mapping.findForward("learnerMonitor");
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser(UserDTO dto) {
        return userManagementService.getUserByLogin(dto.getLogin());
    }

    private void initServices() {
        WebApplicationContext webContext;
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("integrationService");
        }
        if (monitoringService == null) {
            monitoringService = (IMonitoringService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("monitoringService");
        }
        if (userManagementService == null) {
            userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("userManagementService");
        }
        if (learningDesignService == null) {
            learningDesignService = (ILearningDesignService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("learningDesignService");
        }
        if (lessonService == null) {
            lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("lessonService");
        }
        if (workspaceManagementService == null) {
            webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            workspaceManagementService = (IWorkspaceManagementService)webContext.getBean("workspaceManagementService");
        }
        if (securityService == null) {
            webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)webContext.getBean("securityService");
        }
    }

    static {
        lessonService = null;
    }
}

