/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.action;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.policies.Policy;
import org.lamsfoundation.lams.policies.PolicyConsent;
import org.lamsfoundation.lams.policies.PolicyDTO;
import org.lamsfoundation.lams.policies.service.IPolicyService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PolicyConsentsAction
extends Action {
    private static IPolicyService policyService = null;
    private static IUserManagementService userManagementService = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method;
        WebApplicationContext wac;
        if (policyService == null) {
            wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            policyService = (IPolicyService)wac.getBean("policyService");
        }
        if (userManagementService == null) {
            wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)wac.getBean("userManagementService");
        }
        if (StringUtils.equals((String)(method = WebUtil.readStrParam((HttpServletRequest)request, (String)"method", (boolean)true)), (String)"consent") || this.isCancelled(request)) {
            return this.consent(mapping, form, request, response);
        }
        Integer loggedUserId = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        List policyDtos = policyService.getPolicyDtosByUser(loggedUserId);
        request.setAttribute("policies", (Object)policyDtos);
        return mapping.findForward("policyConsents");
    }

    private ActionForward consent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        UserDTO userDto = (UserDTO)SessionManager.getSession().getAttribute("user");
        User user = userManagementService.getUserByLogin(userDto.getLogin());
        List policyDtos = policyService.getPolicyDtosByUser(user.getUserId());
        for (PolicyDTO policyDto : policyDtos) {
            if (policyDto.isConsentedByUser()) continue;
            PolicyConsent consent = new PolicyConsent();
            Policy policy = policyService.getPolicyByUid(policyDto.getUid());
            consent.setPolicy(policy);
            consent.setUser(user);
            userManagementService.save((Object)consent);
        }
        return mapping.findForward("index");
    }
}

