/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.util.HelpUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HelpTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(HelpTag.class);
    private String module = null;
    private String page = null;
    private String toolSignature = null;
    private String style = null;

    public int doStartTag() throws JspException {
        try {
            boolean div = false;
            String helpWord = "";
            JspWriter writer = this.pageContext.getOut();
            if (StringUtils.equals((String)this.style, (String)"no-tabs")) {
                writer.println("<div class='help-no-tabs'>");
                div = true;
            }
            if (!StringUtils.equals((String)this.style, (String)"small")) {
                MessageService msgService = (MessageService)this.getContext().getBean("centralMessageService");
                helpWord = msgService.getMessage("label.help");
            }
            try {
                String languageCode;
                HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
                Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
                String string = languageCode = locale != null ? locale.getLanguage() : "";
                if (this.toolSignature != null && this.module != null) {
                    ILamsToolService toolService = (ILamsToolService)this.getContext().getBean("lamsToolService");
                    IToolVO tool = toolService.getToolBySignature(this.toolSignature);
                    String fullURL = HelpUtil.constructToolURL((String)tool.getHelpUrl(), (String)this.toolSignature, (String)this.module, (String)languageCode);
                    if (fullURL == null) {
                        return 0;
                    }
                    writer.println("<span onclick=\"window.open('" + fullURL + "', 'help')\" id=\"help-tag\"><i class=\"fa fa-question-circle\" ></i> " + helpWord + "</span>");
                } else if (this.page != null) {
                    String fullURL = HelpUtil.constructPageURL((String)this.page, (String)languageCode);
                    writer.println("<span onclick=\"window.open('" + fullURL + "', 'help')\" id=\"help-tag\"><i class=\"fa fa-question-circle\" ></i> " + helpWord + "</span>");
                } else {
                    log.error((Object)"HelpTag unable to write out due to unspecified values.");
                    writer.println("<i class=\"fa fa-times-circle\"></i>");
                }
            }
            catch (NullPointerException npe) {
                log.error((Object)"HelpTag unable to write out due to NullPointerException. Most likely a required paramater was unspecified or incorrect.", (Throwable)npe);
            }
            if (div) {
                writer.println("</div>");
            }
        }
        catch (IOException e) {
            log.error((Object)"HelpTag unable to write out due to IOException.", (Throwable)e);
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    private WebApplicationContext getContext() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
        return ctx;
    }

    public String getToolSignature() {
        return this.toolSignature;
    }

    public void setToolSignature(String toolSignature) {
        this.toolSignature = toolSignature;
    }

    public String getPage() {
        return this.module;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

