/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupUser;
import org.lamsfoundation.lams.learningdesign.dao.IGroupUserDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RegisterAction
extends HttpServlet {
    private static Logger logger = Logger.getLogger(RegisterAction.class);
    private static IntegrationService integrationService = null;
    private static ILearnerProgressDAO learnerProgressDAO = null;
    private static ILessonService lessonService = null;
    private static ICoreLearnerService learnerService = null;
    private static IGroupUserDAO groupUserDAO = null;
    private static IUserManagementService userManagementService = null;
    private static IEventNotificationService eventNotificationService = null;
    private static MessageService messageService = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getParameter("method");
        if (method.equals("addUserToGroupLessons")) {
            this.addUserToGroupLessons(request, response);
        } else if (method.equals("removeUserFromGroup")) {
            this.removeUserFromGroup(request, response);
        } else if (method.equals("resetUserTimeLimit")) {
            this.resetUserTimeLimit(request, response);
        }
    }

    public void init() throws ServletException {
        learnerProgressDAO = (ILearnerProgressDAO)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("learnerProgressDAO");
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lessonService");
        learnerService = (ICoreLearnerService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("learnerService");
        groupUserDAO = (IGroupUserDAO)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("groupUserDAO");
        userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
        eventNotificationService = (IEventNotificationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("eventNotificationService");
        messageService = (MessageService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("centralMessageService");
    }

    public void addUserToGroupLessons(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean serverToServerEnable = Configuration.getAsBoolean((String)ConfigurationKeys.ENABLE_SERVER_REGISTRATION);
            if (!serverToServerEnable) {
                String msg = "Server to server registration is not enabled";
                logger.error((Object)msg);
                response.sendError(405, msg);
                return;
            }
            String method = request.getParameter("method");
            String serverId = request.getParameter("serverId");
            String datetime = request.getParameter("datetime");
            String hashValue = request.getParameter("hashValue");
            String groupName = request.getParameter("courseId");
            String lessonId = request.getParameter("lessonId");
            String username = request.getParameter("username");
            String usePrefix = request.getParameter("usePrefix");
            String firstName = request.getParameter("firstName");
            String lastName = request.getParameter("lastName");
            String email = request.getParameter("email");
            String isJoinLesson = request.getParameter("isJoinLesson");
            String isEmailParticipant = request.getParameter("isEmailParticipant");
            String isEmailCoordinator = request.getParameter("isEmailCoordinator");
            if (serverId == null || datetime == null || hashValue == null || username == null) {
                String msg = "Parameters missing";
                logger.error((Object)msg);
                response.sendError(400, "Parameters missing");
            }
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)method, (String)hashValue);
            String password = RandomPasswordGenerator.nextPassword((int)8);
            String salt = HashUtil.salt();
            String passwordHash = HashUtil.sha256((String)password, (String)salt);
            if ("1".equals(usePrefix)) {
                username = extServer.getPrefix() + "_" + username.trim();
                logger.debug((Object)("Adding prefix to username:" + username));
            }
            ExtUserUseridMap userMap = integrationService.getImplicitExtUserUseridMap(extServer, username, passwordHash, salt, firstName, lastName, email);
            User user = userMap.getUser();
            HashSet<Object> lessonsToJoin = new HashSet<Object>();
            HashSet<Organisation> organisationsToJoin = new HashSet<Organisation>();
            if (StringUtils.isNotBlank((String)groupName)) {
                Organisation org = this.getOrganisationByName(groupName);
                organisationsToJoin.add(org);
                lessonsToJoin.addAll(org.getLessons());
            }
            if (StringUtils.isNotBlank((String)lessonId)) {
                Long lessonIdLong = Long.parseLong(lessonId);
                Lesson lesson = lessonService.getLesson(lessonIdLong);
                organisationsToJoin.add(lesson.getOrganisation());
                lessonsToJoin.add(lesson);
            }
            ArrayList<String> learnerRole = new ArrayList<String>();
            learnerRole.add(Role.ROLE_LEARNER.toString());
            for (Organisation organisation : organisationsToJoin) {
                userManagementService.setRolesForUserOrganisation(user, organisation.getOrganisationId(), learnerRole);
            }
            for (Lesson lesson : lessonsToJoin) {
                boolean isAdded = lessonService.addLearner(lesson.getLessonId(), user.getUserId());
                if (!isAdded) continue;
                logger.debug((Object)("Added user:" + user.getLogin() + " to lesson:" + lesson.getLessonName() + " as a learner"));
            }
            if ("1".equals(isJoinLesson)) {
                for (Lesson lesson : lessonsToJoin) {
                    LearnerProgress learnerProgress = learnerProgressDAO.getLearnerProgressByLearner(user.getUserId(), lesson.getLessonId());
                    if (learnerProgress == null) {
                        logger.debug((Object)("The learner:" + user.getLogin() + " is joining the lesson:" + lesson.getLessonId()));
                        learnerService.joinLesson(user.getUserId(), lesson.getLessonId());
                        continue;
                    }
                    this.resetUserTimeLimit(lesson, user);
                }
            }
            if ("1".equals(isEmailParticipant)) {
                boolean isHtmlFormat = false;
                eventNotificationService.sendMessage(null, user.getUserId(), (AbstractDeliveryMethod)IEventNotificationService.DELIVERY_METHOD_MAIL, messageService.getMessage("register.user.email.subject"), messageService.getMessage("register.user.email.body", new Object[]{username, password}), isHtmlFormat);
            }
            if (StringUtils.isNotBlank((String)isEmailCoordinator)) {
                boolean isHtmlFormat = false;
                List list = userManagementService.getAllUsersWithEmail(isEmailCoordinator);
                if (list == null || list.size() == 0) {
                    throw new RuntimeException("There are no coordinators with email: " + isEmailCoordinator);
                }
                User coordinator = (User)list.get(0);
                String registeredUserName = firstName + " " + lastName + " (" + username + ")";
                eventNotificationService.sendMessage(null, coordinator.getUserId(), (AbstractDeliveryMethod)IEventNotificationService.DELIVERY_METHOD_MAIL, messageService.getMessage("notify.coordinator.register.user.email.subject"), messageService.getMessage("notify.coordinator.register.user.email.body", new Object[]{registeredUserName}), isHtmlFormat);
            }
            this.writeAJAXOKResponse(response);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.writeAJAXResponse(response, "ERROR: " + e.getMessage());
        }
    }

    public void removeUserFromGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean serverToServerEnable = Configuration.getAsBoolean((String)ConfigurationKeys.ENABLE_SERVER_REGISTRATION);
            if (!serverToServerEnable) {
                String msg = "Server to server registration is not enabled";
                logger.error((Object)msg);
                response.sendError(405, msg);
                return;
            }
            String method = request.getParameter("method");
            String serverId = request.getParameter("serverId");
            String datetime = request.getParameter("datetime");
            String hashValue = request.getParameter("hashValue");
            String groupName = request.getParameter("courseId");
            String username = request.getParameter("username");
            String isRemoveFromAllCourses = request.getParameter("isRemoveFromAllCourses");
            String usePrefix = request.getParameter("usePrefix");
            if (serverId == null || datetime == null || hashValue == null || username == null) {
                String msg = "Parameters missing";
                logger.error((Object)msg);
                response.sendError(400, "Parameters missing");
            }
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)method, (String)hashValue);
            if ("1".equals(usePrefix)) {
                username = extServer.getPrefix() + "_" + username.trim();
                logger.debug((Object)("Adding prefix to username:" + username));
            }
            ExtUserUseridMap userMap = this.getExtUserUseridMap(extServer, username);
            User user = userMap.getUser();
            ArrayList<Lesson> lessons = new ArrayList<Lesson>();
            if ("1".equals(isRemoveFromAllCourses)) {
                Set userOrganisations = user.getUserOrganisations();
                ArrayList<OrganisationDTO> organisationDtos = new ArrayList<OrganisationDTO>();
                for (UserOrganisation userOrganisation : userOrganisations) {
                    Organisation organisation = userOrganisation.getOrganisation();
                    OrganisationDTO organisationDto = organisation.getOrganisationDTO();
                    organisationDtos.add(organisationDto);
                    lessons.addAll(organisation.getLessons());
                }
                for (OrganisationDTO organisationDto : organisationDtos) {
                    this.removeGroupMembership(user, organisationDto.getOrganisationID());
                }
            } else {
                Organisation organisation = this.getOrganisationByName(groupName);
                this.removeGroupMembership(user, organisation.getOrganisationId());
                lessons.addAll(organisation.getLessons());
            }
            this.removeUserFromLessons(user, lessons);
            this.writeAJAXOKResponse(response);
        }
        catch (Exception e) {
            this.writeAJAXResponse(response, "ERROR: " + e.getMessage());
        }
    }

    public void resetUserTimeLimit(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean serverToServerEnable = Configuration.getAsBoolean((String)ConfigurationKeys.ENABLE_SERVER_REGISTRATION);
            if (!serverToServerEnable) {
                String msg = "Server to server registration is not enabled";
                logger.error((Object)msg);
                response.sendError(405, msg);
                return;
            }
            String method = request.getParameter("method");
            String serverId = request.getParameter("serverId");
            String datetime = request.getParameter("datetime");
            String hashValue = request.getParameter("hashValue");
            String courseId = request.getParameter("courseId");
            String username = request.getParameter("username");
            String usePrefix = request.getParameter("usePrefix");
            if (serverId == null || datetime == null || hashValue == null || username == null || courseId == null) {
                String msg = "Parameters missing";
                logger.error((Object)msg);
                response.sendError(400, "Parameters missing");
            }
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)method, (String)hashValue);
            if ("1".equals(usePrefix)) {
                username = extServer.getPrefix() + "_" + username.trim();
                logger.debug((Object)("Adding prefix to username:" + username));
            }
            ExtUserUseridMap userMap = this.getExtUserUseridMap(extServer, username);
            User user = userMap.getUser();
            Organisation org = this.getOrganisationByName(courseId);
            if (org.getLessons() != null) {
                for (Lesson lesson : org.getLessons()) {
                    this.resetUserTimeLimit(lesson, user);
                }
            }
            this.writeAJAXOKResponse(response);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.writeAJAXResponse(response, "ERROR: " + e.getMessage());
        }
    }

    private void resetUserTimeLimit(Lesson lesson, User user) {
        GroupUser groupUser;
        if (lesson.isScheduledToCloseForIndividuals() && (groupUser = groupUserDAO.getGroupUser(lesson, user.getUserId())) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, lesson.getScheduledNumberDaysToLessonFinish());
            Date endDate = calendar.getTime();
            groupUser.setScheduledLessonEndDate(endDate);
            logger.debug((Object)("Reset time limit for user:" + user.getLogin() + "in lesson:" + lesson.getLessonId() + " to " + endDate));
        }
    }

    private ExtUserUseridMap getExtUserUseridMap(ExtServer extServer, String extUsername) throws UserInfoFetchException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServer.sid", extServer.getSid());
        properties.put("extUsername", extUsername);
        List list = userManagementService.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            throw new RuntimeException("There is no user with username: " + extUsername + " assossiated with external server " + extServer.getSid());
        }
        return (ExtUserUseridMap)list.get(0);
    }

    private Organisation getOrganisationByName(String name) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", name);
        properties.put("organisationState.organisationStateId", OrganisationState.ACTIVE);
        List list = userManagementService.findByProperties(Organisation.class, properties);
        if (list == null || list.size() == 0) {
            throw new RuntimeException("There is no active course with courseId: " + name);
        }
        Organisation organisation = (Organisation)list.get(0);
        return organisation;
    }

    private ExtCourseClassMap getExtCourseClassMap(ExtServer extServer, ExtUserUseridMap userMap, String extCourseId, Boolean isTeacher) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("courseid", extCourseId);
        properties.put("extServer.sid", extServer.getSid());
        List list = userManagementService.findByProperties(ExtCourseClassMap.class, properties);
        if (list == null || list.size() == 0) {
            throw new RuntimeException("There is no course with courseId: " + extCourseId);
        }
        ExtCourseClassMap map = (ExtCourseClassMap)list.get(0);
        return map;
    }

    private void removeGroupMembership(User user, Integer organisationId) {
        UserOrganisation userOrganisation = userManagementService.getUserOrganisation(user.getUserId(), organisationId);
        Set userOrganisations = user.getUserOrganisations();
        userOrganisations.remove(userOrganisation);
        userManagementService.saveUser(user);
    }

    private void removeUserFromLessons(User user, Collection<Lesson> lessons) {
        for (Lesson lesson : lessons) {
            LessonClass grouping = lesson.getLessonClass();
            Group group = grouping.getLearnersGroup();
            boolean isSuccefullyRemoved = group.getUsers().remove(user);
            if (!isSuccefullyRemoved) continue;
            logger.debug((Object)("Removed user:" + user.getLogin() + " from lesson:" + lesson.getLessonName()));
        }
    }

    protected void writeAJAXResponse(HttpServletResponse response, String output) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = response.getWriter();
        if (output.length() > 0) {
            out.println(output);
        }
        out.flush();
        out.close();
    }

    protected void writeAJAXOKResponse(HttpServletResponse response) throws IOException {
        this.writeAJAXResponse(response, "OK");
    }
}

