/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.HashUtil;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UserRoleServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(UserRoleServlet.class);
    private static IntegrationService integrationService = null;
    private static IUserManagementService userManagementService = null;
    private static ISecurityService securityService = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        String method = request.getParameter("method");
        String targetUsername = request.getParameter("targetUsername");
        String role = request.getParameter("role");
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + targetUsername.toLowerCase().trim() + method.toLowerCase().trim() + role.toLowerCase().trim() + extServer.getServerid().toLowerCase().trim() + extServer.getServerkey().toLowerCase().trim();
            if (!hashValue.equals(HashUtil.sha1((String)plaintext))) {
                log.error((Object)("Hash check failed while trying to set role for user: " + targetUsername));
                response.sendError(401, "Authentication failed, invalid hash");
                return;
            }
            ExtUserUseridMap sysadminUserMap = integrationService.getExtUserUseridMap(extServer, username);
            if (!securityService.isSysadmin(sysadminUserMap.getUser().getUserId(), "set user role", false)) {
                log.error((Object)("Sysadmin role check failed while trying to set role for user: " + targetUsername));
                response.sendError(401, "Authentication failed, user is not sysadmin");
                return;
            }
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, targetUsername);
            User targetUser = userMap.getUser();
            if ("grant".equalsIgnoreCase(method)) {
                this.grant(targetUser, role);
            } else if ("revoke".equalsIgnoreCase(method)) {
                this.revoke(targetUser, role);
            } else {
                log.error((Object)("Unknown method: " + method));
                response.sendError(400, "Unknown method: " + method);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while setting user roles", (Throwable)e);
            response.sendError(500, "Error while setting user roles");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
        securityService = (ISecurityService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("securityService");
    }

    private void grant(User user, String role) throws IOException {
        switch (role) {
            case "SYSADMIN": {
                Organisation rootOrganisation = userManagementService.getRootOrganisation();
                ArrayList<String> roles = new ArrayList<String>(Arrays.asList(Role.ROLE_SYSADMIN.toString()));
                userManagementService.setRolesForUserOrganisation(user, rootOrganisation.getOrganisationId(), roles);
                break;
            }
            default: {
                throw new IOException("Unknown role: " + role);
            }
        }
    }

    private void revoke(User user, String role) throws IOException {
        switch (role) {
            case "SYSADMIN": {
                Organisation rootOrganisation = userManagementService.getRootOrganisation();
                ArrayList roles = new ArrayList();
                userManagementService.setRolesForUserOrganisation(user, rootOrganisation.getOrganisationId(), roles);
                break;
            }
            default: {
                throw new IOException("Unknown role: " + role);
            }
        }
    }
}

