/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.contentrepository.exception.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.lamsfoundation.lams.workspace.web.WorkspaceAction;
import org.springframework.web.util.HtmlUtils;

public class WorkspaceManagementService
implements IWorkspaceManagementService {
    protected Logger log = Logger.getLogger((String)WorkspaceManagementService.class.getName());
    public static final Integer AUTHORING = new Integer(1);
    public static final Integer MONITORING = new Integer(2);
    protected IBaseDAO baseDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected IAuthoringService authoringService;
    protected IRepositoryService repositoryService;
    protected IUserManagementService userMgmtService;
    protected MessageService messageService;
    protected static final String DEFAULT_DESIGN_TYPE = "default";
    protected static final String ALL_DESIGN_TYPES = "all";

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setUserMgmtService(IUserManagementService userMgmtService) {
        this.userMgmtService = userMgmtService;
    }

    @Override
    public void deleteResource(Long resourceID, String resourceType, Integer userID) throws IOException {
        if ("LearningDesign".equals(resourceType)) {
            this.deleteLearningDesign(resourceID, userID);
        } else if ("Folder".equals(resourceType)) {
            this.deleteFolder(new Integer(resourceID.intValue()), userID);
        } else if ("File".equals(resourceType)) {
            this.deleteWorkspaceFolderContent(resourceID);
        }
    }

    private void deleteFolder(Integer folderID, Integer userID) throws IOException {
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)folderID);
        User user = (User)this.userMgmtService.findById(User.class, (Serializable)userID);
        this.deleteFolder(workspaceFolder, user, this.isSysAuthorAdmin(user));
    }

    private void deleteFolder(WorkspaceFolder workspaceFolder, User user, boolean isSysAuthorAdmin) throws IOException {
        if (!this.getPermissions(workspaceFolder, user).equals(WorkspaceFolder.OWNER_ACCESS)) {
            throw new IOException("User is not authorised to delete a folder");
        }
        this.deleteFolderContents(workspaceFolder, user, isSysAuthorAdmin);
    }

    private void deleteFolderContents(WorkspaceFolder folder, User user, boolean isSysAuthorAdmin) throws IOException {
        boolean isDeleteSuccessful = true;
        if (!folder.isEmpty()) {
            if (folder.hasSubFolders()) {
                Set subFolders = folder.getChildWorkspaceFolders();
                for (WorkspaceFolder subFolder : subFolders) {
                    this.deleteFolder(subFolder, user, isSysAuthorAdmin);
                }
            } else {
                Set folderContents = folder.getFolderContent();
                for (WorkspaceFolderContent folderContent : folderContents) {
                    folderContent.setWorkspaceFolder(null);
                    folder.getFolderContent().remove(folderContent);
                }
                Set learningDesigns = folder.getLearningDesigns();
                for (LearningDesign learningDesign : learningDesigns) {
                    if (learningDesign == null || !isSysAuthorAdmin && !learningDesign.getUser().getUserId().equals(user.getUserId())) continue;
                    if (learningDesign.getReadOnly().booleanValue()) {
                        isDeleteSuccessful = false;
                        continue;
                    }
                    folder.getLearningDesigns().remove(learningDesign);
                    learningDesign.setWorkspaceFolder(null);
                }
                this.baseDAO.update((Object)folder);
            }
        }
        if (isDeleteSuccessful) {
            this.baseDAO.delete((Object)folder);
        }
    }

    @Override
    public WorkspaceFolder getWorkspaceFolder(Integer workspaceFolderID) {
        return (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
    }

    @Override
    public Vector<FolderContentDTO> getFolderContentsExcludeHome(Integer userID, WorkspaceFolder folder, Integer mode) throws UserAccessDeniedException, RepositoryCheckedException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        return this.getFolderContentsInternal(user, folder, mode, "getFolderContentsExcludeHome", user.getWorkspaceFolder());
    }

    @Override
    public Vector<FolderContentDTO> getFolderContents(Integer userID, WorkspaceFolder folder, Integer mode) throws UserAccessDeniedException, RepositoryCheckedException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        return this.getFolderContentsInternal(user, folder, mode, "getFolderContents", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector<FolderContentDTO> getFolderContentsInternal(User user, WorkspaceFolder workspaceFolder, Integer mode, String methodName, WorkspaceFolder skipFolder) throws UserAccessDeniedException, RepositoryCheckedException {
        Vector<FolderContentDTO> contentDTO = new Vector<FolderContentDTO>();
        if (user == null) throw new UserAccessDeniedException(user);
        Integer permissions = this.getPermissions(workspaceFolder, user);
        if (permissions == WorkspaceFolder.NO_ACCESS) throw new UserAccessDeniedException(user);
        this.getFolderContent(workspaceFolder, permissions, mode, contentDTO, user);
        if (workspaceFolder.hasSubFolders()) {
            this.getSubFolderDetails(workspaceFolder, user, contentDTO, skipFolder);
        }
        Collections.sort(contentDTO);
        return contentDTO;
    }

    private void getFolderContent(WorkspaceFolder workspaceFolder, Integer folderPermissions, Integer mode, Vector<FolderContentDTO> contentDTO, User user) {
        List designs = null;
        designs = AUTHORING.equals(mode) ? this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId()) : this.learningDesignDAO.getAllValidLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        this.getFolderContentDTO(designs, folderPermissions, contentDTO, user);
    }

    private void getSubFolderDetails(WorkspaceFolder workspaceFolder, User user, Vector<FolderContentDTO> subFolderContent, WorkspaceFolder skipFolder) {
        Integer skipFolderID = skipFolder != null ? skipFolder.getWorkspaceFolderId() : null;
        for (WorkspaceFolder subFolder : workspaceFolder.getChildWorkspaceFolders()) {
            Integer permissions;
            if (skipFolderID != null && skipFolderID.equals(subFolder.getWorkspaceFolderId()) || (permissions = this.getPermissions(subFolder, user)) == WorkspaceFolder.NO_ACCESS) continue;
            subFolderContent.add(new FolderContentDTO(subFolder, permissions, user));
        }
    }

    @Override
    public String getFolderContentsJSON(Integer folderID, Integer userID, boolean allowInvalidDesigns) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        return this.getFolderContentsJSON(folderID, userID, allowInvalidDesigns, false, ALL_DESIGN_TYPES);
    }

    @Override
    public String getFolderContentsJSON(Integer folderID, Integer userID, boolean allowInvalidDesigns, String designType) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        return this.getFolderContentsJSON(folderID, userID, allowInvalidDesigns, false, designType);
    }

    public String getFolderContentsJSON(Integer folderID, Integer userID, boolean allowInvalidDesigns, boolean designsOnly, String designType) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        WorkspaceFolder folder;
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        Vector<FolderContentDTO> folderContents = null;
        if (folderID == null || folderID == -1) {
            FolderContentDTO userFolder = this.getUserWorkspaceFolder(userID);
            if (folderID == null) {
                folderContents = new Vector<FolderContentDTO>(3);
                if (userFolder != null) {
                    folderContents.add(userFolder);
                }
                FolderContentDTO myGroupsFolder = new FolderContentDTO(this.messageService.getMessage("organisations"), this.messageService.getMessage("folder"), null, null, "Folder", Long.valueOf(WorkspaceAction.ORG_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
                folderContents.add(myGroupsFolder);
                FolderContentDTO publicFolder = this.getPublicWorkspaceFolder(userID);
                if (publicFolder != null) {
                    folderContents.add(publicFolder);
                }
            } else if (userFolder != null) {
                return this.getFolderContentsJSON(userFolder.getResourceID().intValue(), userID, allowInvalidDesigns, true, designType);
            }
        } else if (folderID.equals(WorkspaceAction.ORG_FOLDER_ID)) {
            folderContents = this.getAccessibleOrganisationWorkspaceFolders(userID);
            Collections.sort(folderContents);
            if (folderContents.size() == 1 && (folder = (FolderContentDTO)folderContents.firstElement()).getResourceID().equals(WorkspaceAction.ROOT_ORG_FOLDER_ID)) {
                return this.getFolderContentsJSON(WorkspaceAction.ROOT_ORG_FOLDER_ID, userID, allowInvalidDesigns);
            }
        } else {
            folder = this.getWorkspaceFolder(folderID);
            Integer mode = allowInvalidDesigns ? AUTHORING : MONITORING;
            folderContents = this.getFolderContents(userID, folder, mode);
            Collections.sort(folderContents);
        }
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        for (FolderContentDTO folderContent : folderContents) {
            String contentType = folderContent.getResourceType();
            if ("Folder".equals(contentType) && !designsOnly) {
                ObjectNode subfolderJSON = JsonNodeFactory.instance.objectNode();
                subfolderJSON.put("name", folderContent.getName() == null ? "" : folderContent.getName());
                subfolderJSON.put("isRunSequencesFolder", WorkspaceFolder.RUN_SEQUENCES.equals(folderContent.getResourceTypeID() == null ? null : Integer.valueOf(folderContent.getResourceTypeID().intValue())));
                subfolderJSON.put("folderID", folderContent.getResourceID().intValue());
                subfolderJSON.put("canModify", WorkspaceFolder.OWNER_ACCESS.equals(folderContent.getPermissionCode()) || user != null && this.isSysAuthorAdmin(user));
                result.withArray("folders").add((JsonNode)subfolderJSON);
                continue;
            }
            if ("LearningDesign".equals(contentType)) {
                if (folderContent.getDesignType() == null) {
                    folderContent.setDesignType(DEFAULT_DESIGN_TYPE);
                }
                if (!(designType == null ? folderContent.getDesignType().equals(DEFAULT_DESIGN_TYPE) : designType.equals(ALL_DESIGN_TYPES) || designType.equals(folderContent.getDesignType()))) continue;
                ObjectNode learningDesignJSON = JsonNodeFactory.instance.objectNode();
                learningDesignJSON.put("name", folderContent.getName() == null ? "" : folderContent.getName());
                learningDesignJSON.put("learningDesignId", folderContent.getResourceID());
                JsonUtil.putOpt((ObjectNode)learningDesignJSON, (String)"type", (Object)folderContent.getDesignType());
                learningDesignJSON.put("date", folderContent.getLastModifiedDateTime().toString());
                learningDesignJSON.put("canModify", WorkspaceFolder.OWNER_ACCESS.equals(folderContent.getPermissionCode()) || user != null && this.isSysAuthorAdmin(user));
                result.withArray("learningDesigns").add((JsonNode)learningDesignJSON);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Unsupported folder content found, named \"" + folderContent.getName() + "\""));
        }
        return result.toString();
    }

    @Override
    public String getPagedLearningDesignsJSON(Integer userID, boolean allowInvalidDesigns, String searchString, int page, int size, String sortName, String sortDate) throws IOException {
        ArrayNode resultJSON = JsonNodeFactory.instance.arrayNode();
        Pattern searchPattern = searchString != null ? Pattern.compile(Pattern.quote(searchString), 2) : null;
        FolderContentDTO userFolder = this.getUserWorkspaceFolder(userID);
        long numDesigns = 0L;
        if (userFolder != null) {
            Integer mode = allowInvalidDesigns ? AUTHORING : MONITORING;
            int folderId = userFolder.getResourceID().intValue();
            List designs = null;
            designs = AUTHORING.equals(mode) ? (searchPattern != null ? this.learningDesignDAO.getAllPagedLearningDesigns(Integer.valueOf(folderId), null, null, sortName, sortDate) : this.learningDesignDAO.getAllPagedLearningDesigns(Integer.valueOf(folderId), Integer.valueOf(page), Integer.valueOf(size), sortName, sortDate)) : (searchPattern != null ? this.learningDesignDAO.getValidPagedLearningDesigns(Integer.valueOf(folderId), null, null, sortName, sortDate) : this.learningDesignDAO.getValidPagedLearningDesigns(Integer.valueOf(folderId), Integer.valueOf(page), Integer.valueOf(size), sortName, sortDate));
            for (LearningDesign design : designs) {
                if (searchPattern != null && !searchPattern.matcher(design.getTitle()).find()) continue;
                ObjectNode learningDesignJSON = JsonNodeFactory.instance.objectNode();
                learningDesignJSON.put("name", HtmlUtils.htmlEscape((String)design.getTitle()));
                learningDesignJSON.put("learningDesignId", design.getLearningDesignId());
                learningDesignJSON.put("type", design.getDesignType() != null ? design.getDesignType() : DEFAULT_DESIGN_TYPE);
                learningDesignJSON.put("date", design.getLastModifiedDateTime().toString());
                resultJSON.add((JsonNode)learningDesignJSON);
            }
            numDesigns = searchPattern != null ? (long)resultJSON.size() : this.learningDesignDAO.countAllLearningDesigns(Integer.valueOf(folderId), !allowInvalidDesigns);
        }
        ObjectNode completeResult = JsonNodeFactory.instance.objectNode();
        completeResult.put("total_rows", numDesigns);
        if (resultJSON.size() > 0) {
            completeResult.set("rows", (JsonNode)resultJSON);
        }
        return completeResult.toString();
    }

    private Integer getPermissions(WorkspaceFolder workspaceFolder, User user) {
        Integer permission = null;
        if (workspaceFolder == null || user == null) {
            this.log.debug((Object)"no access due to null value(s) in user or workspaceFolder");
            permission = WorkspaceFolder.NO_ACCESS;
        } else {
            permission = WorkspaceFolder.RUN_SEQUENCES.equals(workspaceFolder.getWorkspaceFolderType()) ? WorkspaceFolder.READ_ACCESS : (WorkspaceFolder.PUBLIC_SEQUENCES.equals(workspaceFolder.getWorkspaceFolderType()) ? WorkspaceFolder.MEMBERSHIP_ACCESS : (workspaceFolder.getUserID().equals(user.getUserId()) ? WorkspaceFolder.OWNER_ACCESS : (this.isSysAuthorAdmin(user) ? WorkspaceFolder.OWNER_ACCESS : (user.hasMemberAccess(workspaceFolder) ? WorkspaceFolder.MEMBERSHIP_ACCESS : WorkspaceFolder.NO_ACCESS))));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(user.getLogin() + " has " + permission + " access to " + workspaceFolder.getName()));
            }
        }
        return permission;
    }

    private boolean isSysAuthorAdmin(User user) {
        return this.userMgmtService.hasRoleInOrganisation(user, Role.ROLE_SYSADMIN);
    }

    private Vector getFolderContentDTO(List designs, Integer folderPermissions, Vector<FolderContentDTO> folderContent, User user) {
        for (LearningDesign design : designs) {
            FolderContentDTO folder = design.getUser() != null && design.getUser().equals((Object)user) ? new FolderContentDTO(design, WorkspaceFolder.OWNER_ACCESS, user) : new FolderContentDTO(design, folderPermissions, user);
            folderContent.add(folder);
        }
        return folderContent;
    }

    @Override
    public void copyResource(Long resourceID, String resourceType, Integer copyType, Integer targetFolderID, Integer userID) throws LearningDesignException, UserException, WorkspaceFolderException, IOException {
        if ("LearningDesign".equals(resourceType)) {
            this.authoringService.copyLearningDesign(resourceID, copyType != null ? copyType : new Integer(1), userID, targetFolderID, false);
        } else if ("Folder".equals(resourceType)) {
            this.copyFolder(new Integer(resourceID.intValue()), targetFolderID, userID);
        }
    }

    @Override
    public void moveResource(Long resourceID, String resourceType, Integer targetFolderID) throws WorkspaceFolderException {
        WorkspaceFolder targetFolder = this.getWorkspaceFolder(targetFolderID);
        if ("LearningDesign".equals(resourceType)) {
            LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(resourceID);
            learningDesign.setWorkspaceFolder(targetFolder);
            this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
        } else if ("Folder".equals(resourceType)) {
            WorkspaceFolder folder = this.getWorkspaceFolder(resourceID.intValue());
            for (WorkspaceFolder parent = targetFolder.getParentWorkspaceFolder(); parent != null; parent = parent.getParentWorkspaceFolder()) {
                if (!parent.equals((Object)folder)) continue;
                throw new WorkspaceFolderException("Can not move a folder into its descendant");
            }
            folder.setParentWorkspaceFolder(targetFolder);
            this.baseDAO.update((Object)folder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFolder(Integer folderID, Integer targetFolderID, Integer userID) throws IOException, WorkspaceFolderException, LearningDesignException, UserAccessDeniedException, UserException {
        if (!this.isUserAuthorizedToModifyFolderContents(targetFolderID, userID)) throw new IOException("User " + userID + " is not authorized to copy folder " + targetFolderID);
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)folderID);
        if (workspaceFolder == null) throw new WorkspaceFolderException("Workspace folder not found, ID: " + folderID);
        WorkspaceFolder newFolder = this.createFolder(targetFolderID, workspaceFolder.getName(), userID);
        this.copyRootContent(workspaceFolder, newFolder, userID);
        if (!workspaceFolder.hasSubFolders()) return;
        this.createSubFolders(workspaceFolder, newFolder, userID);
    }

    @Override
    public boolean isUserAuthorizedToModifyFolderContents(Integer folderID, Integer userID) throws UserException, WorkspaceFolderException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user != null) {
            WorkspaceFolder targetParent = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)folderID);
            if (targetParent != null) {
                Integer permissions = this.getPermissions(targetParent, user);
                return !permissions.equals(WorkspaceFolder.NO_ACCESS) && !permissions.equals(WorkspaceFolder.READ_ACCESS);
            }
            throw new WorkspaceFolderException();
        }
        throw new UserException();
    }

    public void copyRootContent(WorkspaceFolder workspaceFolder, WorkspaceFolder targetWorkspaceFolder, Integer userID) throws UserException, LearningDesignException, UserAccessDeniedException, WorkspaceFolderException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user", new Object[]{userID}));
        }
        List designs = this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        if (designs != null && designs.size() != 0) {
            for (LearningDesign design : designs) {
                this.authoringService.copyLearningDesign(design, new Integer(1), user, targetWorkspaceFolder, false, null, null);
            }
        }
    }

    @Override
    public WorkspaceFolder createFolder(Integer parentFolderID, String name, Integer userID) throws UserException, WorkspaceFolderException {
        WorkspaceFolder parentFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)parentFolderID);
        if (parentFolder != null) {
            boolean nameExists = true;
            while (nameExists && (nameExists = this.ifNameExists(parentFolder, name))) {
                name = name + "C";
            }
            Integer newWorkspaceFolderType = parentFolder.getWorkspaceFolderType().equals(WorkspaceFolder.PUBLIC_SEQUENCES) ? WorkspaceFolder.PUBLIC_SEQUENCES : WorkspaceFolder.NORMAL;
            User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
            if (user != null) {
                WorkspaceFolder workspaceFolder = new WorkspaceFolder(name, parentFolder, userID, new Date(), new Date(), newWorkspaceFolderType);
                this.baseDAO.insert((Object)workspaceFolder);
                return workspaceFolder;
            }
            throw new UserException(this.messageService.getMessage("no.such.user", new Object[]{userID}));
        }
        throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace", new Object[]{parentFolderID}));
    }

    private boolean ifNameExists(WorkspaceFolder targetFolder, String folderName) {
        List folders = this.baseDAO.findByProperty(WorkspaceFolder.class, "parentWorkspaceFolder.workspaceFolderId", (Object)targetFolder.getWorkspaceFolderId());
        if (folders != null && folders.size() != 0) {
            for (WorkspaceFolder folder : folders) {
                if (!folder.getName().equalsIgnoreCase(folderName)) continue;
                return true;
            }
        }
        return false;
    }

    public void createSubFolders(WorkspaceFolder workspaceFolder, WorkspaceFolder newFolder, Integer userID) throws UserException, WorkspaceFolderException {
        for (WorkspaceFolder subFolder : workspaceFolder.getChildWorkspaceFolders()) {
            WorkspaceFolder newSubFolder = this.createFolder(newFolder.getWorkspaceFolderId(), subFolder.getName(), userID);
            this.copyRootContent(subFolder, newSubFolder, userID);
            if (!subFolder.hasSubFolders()) continue;
            this.createSubFolders(subFolder, newSubFolder, userID);
        }
    }

    private void deleteLearningDesign(Long learningDesignID, Integer userID) throws IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new IOException("User could not be found, ID: " + userID);
        }
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        if (learningDesign == null) {
            throw new IOException("Learning Design could not be found, ID: " + learningDesignID);
        }
        if (learningDesign.getUser().getUserId().equals(user.getUserId()) || this.isSysAuthorAdmin(user)) {
            if (learningDesign.getReadOnly().booleanValue()) {
                throw new IOException("Learning Design is read-only, ID: " + learningDesignID);
            }
        } else {
            throw new IOException("User is not authorized to delete Learning Design, ID: " + learningDesignID);
        }
        this.learningDesignDAO.delete((Object)learningDesign);
    }

    private void deleteWorkspaceFolderContent(Long folderContentID) throws IOException {
        WorkspaceFolderContent workspaceFolderContent = (WorkspaceFolderContent)this.baseDAO.find(WorkspaceFolderContent.class, (Serializable)folderContentID);
        if (workspaceFolderContent != null) {
            this.baseDAO.delete((Object)workspaceFolderContent);
        }
    }

    @Override
    public Vector getAccessibleOrganisationWorkspaceFolders(Integer userID) throws IOException {
        this.log.debug((Object)("User - " + userID));
        User user = (User)this.userMgmtService.findById(User.class, (Serializable)userID);
        return this.getAccessibleOrganisationWorkspaceFolders(user);
    }

    @Override
    public Vector getAccessibleOrganisationWorkspaceFolders(User user) throws IOException {
        Vector<FolderContentDTO> folders = new Vector<FolderContentDTO>();
        if (user != null) {
            Set userMemberships = user.getUserOrganisations();
            if (userMemberships != null) {
                for (UserOrganisation member : userMemberships) {
                    Integer permission;
                    Set roles;
                    WorkspaceFolder orgFolder;
                    Integer orgStateId;
                    Organisation org = member.getOrganisation();
                    if (org == null || OrganisationState.HIDDEN.equals(orgStateId = org.getOrganisationState().getOrganisationStateId()) || OrganisationState.REMOVED.equals(orgStateId) || (orgFolder = org.getNormalFolder()) == null || !this.hasWriteAccess(roles = member.getUserOrganisationRoles()) || (permission = this.getPermissions(orgFolder, user)).equals(WorkspaceFolder.NO_ACCESS)) continue;
                    folders.add(new FolderContentDTO(orgFolder, permission, user));
                }
            } else {
                this.log.warn((Object)("getAccessibleOrganisationWorkspaceFolders: Trying to get user memberships for user " + user.getUserId() + ". User doesn't belong to any organisations. Returning no folders."));
            }
        } else {
            this.log.warn((Object)("getAccessibleOrganisationWorkspaceFolders: User " + user.getUserId() + " does not exist. Returning no folders."));
        }
        Collections.sort(folders);
        return folders;
    }

    @Override
    public FolderContentDTO getUserWorkspaceFolder(Integer userID) throws IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user != null) {
            WorkspaceFolder workspaceFolder = user.getWorkspaceFolder();
            if (workspaceFolder != null) {
                Integer permissions = this.getPermissions(workspaceFolder, user);
                return new FolderContentDTO(workspaceFolder, permissions, user);
            }
            this.log.warn((Object)("getUserWorkspaceFolder: User " + userID + " does not have a root folder. Returning no folders."));
        } else {
            this.log.warn((Object)("getUserWorkspaceFolder: User " + userID + " does not exist. Returning no folders."));
        }
        return null;
    }

    @Override
    public FolderContentDTO getPublicWorkspaceFolder(Integer userID) throws IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user != null) {
            WorkspaceFolder publicFolder = null;
            List list = this.baseDAO.findByProperty(WorkspaceFolder.class, "workspaceFolderType", (Object)WorkspaceFolder.PUBLIC_SEQUENCES);
            if (list != null && list.size() > 0) {
                publicFolder = (WorkspaceFolder)list.get(0);
            }
            if (publicFolder != null) {
                Integer permissions = this.getPermissions(publicFolder, user);
                return new FolderContentDTO(publicFolder, permissions, user);
            }
        }
        return null;
    }

    private boolean hasWriteAccess(Set roles) {
        for (UserOrganisationRole userOrganisationRole : roles) {
            Role role = userOrganisationRole.getRole();
            if (!role.isAuthor() && !role.isSysAdmin() && !role.isGroupManager()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renameResource(Long resourceID, String resourceType, String newName, Integer userID) throws IOException, UserException, WorkspaceFolderException {
        if ("LearningDesign".equals(resourceType)) {
            this.renameLearningDesign(resourceID, newName, userID);
        } else if ("Folder".equals(resourceType)) {
            this.renameWorkspaceFolder(new Integer(resourceID.intValue()), newName, userID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameWorkspaceFolder(Integer workspaceFolderID, String newName, Integer userID) throws IOException, UserException, WorkspaceFolderException {
        WorkspaceFolder folder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
        if (folder == null) throw new IOException("Could not find folder, ID: " + workspaceFolderID);
        WorkspaceFolder parent = folder.getParentWorkspaceFolder();
        if (parent == null || !this.isUserAuthorizedToModifyFolderContents(workspaceFolderID, userID)) throw new IOException("User " + userID + " is not authorized to modify folder contents " + workspaceFolderID);
        if (this.ifNameExists(parent, newName)) {
            throw new IOException("Name already exists");
        }
        folder.setName(newName);
        this.baseDAO.update((Object)folder);
    }

    public void renameLearningDesign(Long learningDesignID, String title, Integer userID) throws IOException, UserException, WorkspaceFolderException {
        LearningDesign design = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        Integer folderID = null;
        if (design != null) {
            folderID = design.getWorkspaceFolder().getWorkspaceFolderId();
            if (!this.isUserAuthorizedToModifyFolderContents(folderID, userID)) {
                throw new IOException("User " + userID + " + is not authorized to modify folder " + folderID);
            }
        } else {
            throw new IOException("Could not find Learning Design, ID: " + learningDesignID);
        }
        design.setTitle(title);
        this.learningDesignDAO.update((Object)design);
    }
}

