/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.events.ResendMessagesJob;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.events.dao.EventDAO;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

class EventNotificationService
implements IEventNotificationService {
    private static EventNotificationService instance;
    protected static final Set<AbstractDeliveryMethod> availableDeliveryMethods;
    protected static final Set<Event> eventPool;
    protected static final Logger log;
    private static final long RESEND_FREQUENCY = 3600000L;
    protected EventDAO eventDAO;
    protected IUserManagementService userManagementService;
    protected MessageService messageService;
    protected ILessonService lessonService;
    protected ILamsToolService toolService;
    private Scheduler scheduler;
    private static final String RESEND_MESSAGES_JOB_NAME = "Resend Messages Job";
    private static final String RESEND_MESSAGES_TRIGGER_NAME = "Resend Messages Job trigger";

    public EventNotificationService(Scheduler scheduler) {
        if (instance == null) {
            instance = this;
            this.scheduler = scheduler;
            availableDeliveryMethods.add(IEventNotificationService.DELIVERY_METHOD_MAIL);
            try {
                JobDetail resendMessagesJobDetail = this.getScheduler().getJobDetail(RESEND_MESSAGES_JOB_NAME, "DEFAULT");
                if (resendMessagesJobDetail == null) {
                    resendMessagesJobDetail = new JobDetail(RESEND_MESSAGES_JOB_NAME, "DEFAULT", ResendMessagesJob.class);
                    resendMessagesJobDetail.setDescription("");
                    SimpleTrigger resendMessageTrigger = new SimpleTrigger(RESEND_MESSAGES_TRIGGER_NAME, "DEFAULT", SimpleTrigger.REPEAT_INDEFINITELY, 3600000L);
                    this.getScheduler().scheduleJob(resendMessagesJobDetail, (Trigger)resendMessageTrigger);
                }
                this.getScheduler().start();
            }
            catch (SchedulerException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public static EventNotificationService getInstance() {
        return instance;
    }

    public boolean addDeliveryMethod(AbstractDeliveryMethod deliveryMethod) {
        return availableDeliveryMethods.add(deliveryMethod);
    }

    @Override
    public boolean createEvent(String scope, String name, Long eventSessionId, String defaultSubject, String defaultMessage, boolean isHtmlFormat) throws InvalidParameterException {
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event != null) {
            this.saveEvent(event);
            return false;
        }
        event = new Event(scope, name, eventSessionId, defaultSubject, defaultMessage, isHtmlFormat);
        ++event.referenceCounter;
        this.saveEvent(event);
        return true;
    }

    @Override
    public boolean deleteEvent(String scope, String name, Long eventSessionId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            return false;
        }
        event.deleted = true;
        this.saveEvent(event);
        return true;
    }

    @Override
    public boolean eventExists(String scope, String name, Long eventSessionId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            return false;
        }
        this.saveEvent(event);
        return true;
    }

    @Override
    public Set<AbstractDeliveryMethod> getAvailableDeliveryMethods() {
        return availableDeliveryMethods;
    }

    @Override
    public boolean isSubscribed(String scope, String name, Long eventSessionId, Long userId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        boolean isSubscribed = false;
        if (event != null) {
            for (Subscription subscription : event.getSubscriptions()) {
                if (!subscription.getUserId().equals(userId)) continue;
                isSubscribed = true;
                break;
            }
            this.saveEvent(event);
        }
        return isSubscribed;
    }

    @Override
    public boolean sendMessage(Integer fromUserId, Integer toUserId, AbstractDeliveryMethod deliveryMethod, String subject, String message, boolean isHtmlFormat) throws InvalidParameterException {
        Event eventFailCopy = new Event("SINGLE_MESSAGE", String.valueOf(System.currentTimeMillis()), null, subject, message, isHtmlFormat);
        String result = deliveryMethod.send(fromUserId, toUserId, subject, message, isHtmlFormat);
        if (result != null) {
            log.warn((Object)("Error occured while sending message: " + result));
            eventFailCopy.subscribe(toUserId, deliveryMethod, null);
        }
        if (!eventFailCopy.subscriptions.isEmpty()) {
            eventFailCopy.setFailTime(new Date());
            ++eventFailCopy.referenceCounter;
            this.saveEvent(eventFailCopy);
            return false;
        }
        return true;
    }

    @Override
    public boolean sendMessage(final Integer fromUserId, final Integer[] toUserIds, final AbstractDeliveryMethod deliveryMethod, final String subject, final String message, final boolean isHtmlFormat) throws InvalidParameterException {
        if (toUserIds == null) {
            throw new InvalidParameterException("User IDs array must not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method must not be null.");
        }
        if (toUserIds.length > 0) {
            if (toUserIds.length == 1) {
                return this.sendMessage(fromUserId, toUserIds[0], deliveryMethod, subject, message, isHtmlFormat);
            }
            final Event event = new Event("SINGLE_MESSAGE", String.valueOf(System.currentTimeMillis()), null, subject, message, isHtmlFormat);
            ++event.referenceCounter;
            event.notificationThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Integer id : toUserIds) {
                        String result = deliveryMethod.send(fromUserId, id, subject, message, isHtmlFormat);
                        if (result == null) continue;
                        log.warn((Object)("Error occured while sending message: " + result));
                        event.subscribe(id, deliveryMethod, null);
                    }
                    if (!event.subscriptions.isEmpty()) {
                        event.setFailTime(new Date());
                        event.setTriggered(true);
                        EventNotificationService.this.saveEvent(event);
                    }
                }
            }, "LAMS_single_message_send_thread");
            event.notificationThread.start();
        }
        return true;
    }

    @Override
    public boolean notifyLessonMonitors(Long sessionId, String message, boolean isHtmlFormat) {
        String NEW_LINE_CHARACTER = "\r\n";
        List<User> monitoringUsers = this.lessonService.getMonitorsByToolSessionId(sessionId);
        if (monitoringUsers == null || monitoringUsers.isEmpty()) {
            return true;
        }
        Integer[] monitoringUsersIds = new Integer[monitoringUsers.size()];
        for (int i = 0; i < monitoringUsersIds.length; ++i) {
            monitoringUsersIds[i] = monitoringUsers.get(i).getUserId();
        }
        ToolSession toolSession = this.toolService.getToolSession(sessionId);
        Lesson lesson = toolSession.getLesson();
        ToolActivity toolActivity = toolSession.getToolActivity();
        String lessonName = lesson.getLessonName();
        String activityTitle = toolActivity.getTitle();
        String toolName = toolActivity.getTool().getToolDisplayName();
        String emailSubject = toolName + " " + this.messageService.getMessage("email.notifications.tool") + ": " + activityTitle + " " + this.messageService.getMessage("email.notifications.activity") + " - " + lessonName + " " + this.messageService.getMessage("email.notifications.lesson");
        String courseName = lesson.getOrganisation().getName();
        String serverUrl = Configuration.get(ConfigurationKeys.SERVER_URL).trim();
        String emailBody = this.messageService.getMessage("email.notifications.course") + ": " + courseName + "\r\n" + this.messageService.getMessage("email.notifications.lesson.caption") + ": " + lessonName + "\r\n" + "\r\n" + message + "\r\n" + "\r\n" + serverUrl;
        return this.sendMessage(null, monitoringUsersIds, IEventNotificationService.DELIVERY_METHOD_MAIL, emailSubject, emailBody, isHtmlFormat);
    }

    @Override
    public boolean subscribe(String scope, String name, Long eventSessionId, Integer userId, AbstractDeliveryMethod deliveryMethod, Long periodicity) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        boolean newSubscription = true;
        try {
            newSubscription = event.subscribe(userId, deliveryMethod, periodicity);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.saveEvent(event);
        return newSubscription;
    }

    @Override
    public boolean trigger(String scope, String name, Long eventSessionId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        try {
            event.trigger(event.getDefaultSubject(), event.getDefaultMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return true;
    }

    @Override
    public boolean trigger(String scope, String name, Long eventSessionId, Object[] parameterValues) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        String body = event.getDefaultMessage();
        if (parameterValues != null && parameterValues.length > 0) {
            for (int index = 0; index < parameterValues.length; ++index) {
                Object value = parameterValues[index];
                String replacement = value == null ? "" : value.toString();
                body = body.replace("{" + index + "}", replacement);
            }
        }
        try {
            event.trigger(event.getDefaultSubject(), body);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return true;
    }

    @Override
    public boolean trigger(String scope, String name, Long eventSessionId, String title, String message) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        try {
            event.trigger(title, message);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return true;
    }

    @Override
    public boolean triggerForSingleUser(String scope, String name, Long eventSessionId, Integer userId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        boolean notificationSuccessful = false;
        try {
            notificationSuccessful = event.triggerForSingleUser(userId, event.getDefaultSubject(), event.getDefaultMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        this.saveEvent(event);
        return notificationSuccessful;
    }

    @Override
    public boolean triggerForSingleUser(String scope, String name, Long eventSessionId, Integer userId, Object[] parameterValues) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        String body = event.getDefaultMessage();
        if (parameterValues != null && parameterValues.length > 0) {
            for (int index = 0; index < parameterValues.length; ++index) {
                Object value = parameterValues[index];
                String replacement = value == null ? "" : value.toString();
                body = body.replace("{" + index + "}", replacement);
            }
        }
        boolean notificationSuccessful = false;
        try {
            notificationSuccessful = event.triggerForSingleUser(userId, event.getDefaultSubject(), body);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        this.saveEvent(event);
        return notificationSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerForSingleUser(String scope, String name, Long eventSessionId, Integer userId, String subject, String message) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        boolean notificationSuccessful = false;
        try {
            notificationSuccessful = event.triggerForSingleUser(userId, subject, message);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.saveEvent(event);
        }
        return notificationSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unsubscribe(String scope, String name, Long eventSessionId, Integer userId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        boolean subscriptionFound = false;
        try {
            subscriptionFound = event.unsubscribe(userId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.saveEvent(event);
        }
        return subscriptionFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unsubscribe(String scope, String name, Long eventSessionId, Integer userId, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery nethod should not be null.");
        }
        Event event = this.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        boolean subscriptionFound = false;
        try {
            subscriptionFound = event.unsubscribe(userId, deliveryMethod);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.saveEvent(event);
        }
        return subscriptionFound;
    }

    protected Event getEvent(String scope, String name, Long eventSessionId) {
        String fullSignature = Event.createFullSignature(scope, name, eventSessionId);
        for (Event event : eventPool) {
            if (!event.equals(fullSignature)) continue;
            if (event.deleted) {
                return null;
            }
            ++event.referenceCounter;
            return event;
        }
        Event result = this.getEventDAO().getEvent(scope, name, eventSessionId);
        if (result == null) {
            return null;
        }
        ++result.referenceCounter;
        eventPool.add(result);
        return result;
    }

    protected void saveEvent(Event event) {
        --event.referenceCounter;
        if (event.referenceCounter <= 0) {
            eventPool.remove(event);
            if (event.deleted) {
                this.getEventDAO().deleteEvent(event);
            } else {
                this.getEventDAO().saveEvent(event);
            }
        }
    }

    public EventDAO getEventDAO() {
        return this.eventDAO;
    }

    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    protected IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    private Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    protected MessageService getMessageService() {
        return this.messageService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    protected ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    protected ILamsToolService getToolService() {
        return this.toolService;
    }

    static {
        availableDeliveryMethods = new HashSet<AbstractDeliveryMethod>(2);
        eventPool = new HashSet<Event>();
        log = Logger.getLogger(EventNotificationService.class);
    }
}

