/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.NullActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.strategy.ComplexActivityStrategy;

public class SequenceActivityStrategy
extends ComplexActivityStrategy {
    protected Logger log = Logger.getLogger(SequenceActivityStrategy.class);
    protected SequenceActivity sequenceActivity = null;

    public SequenceActivityStrategy(SequenceActivity sequenceActivity) {
        this.sequenceActivity = sequenceActivity;
    }

    @Override
    public Activity getNextActivityByParent(ComplexActivity parent, Activity currentChild) {
        Activity firstActivity = this.sequenceActivity.getDefaultActivity();
        if (firstActivity != null) {
            return currentChild == null || currentChild.isNull() ? firstActivity : new NullActivity();
        }
        if (this.sequenceActivity.getActivities().size() > 0) {
            this.log.warn((Object)("getNextActivityByParent: child activities exist but no firstActivity is set up. Trying to work it out based on transitions. SequenceActivity " + this.sequenceActivity));
            Activity inputChild = currentChild;
            if (inputChild == null) {
                inputChild = new NullActivity();
            }
            boolean pastCurrentChild = false;
            for (Activity curChild : this.sequenceActivity.getActivities()) {
                if ((inputChild.isNull() || pastCurrentChild) && curChild.getTransitionTo() == null) {
                    return curChild;
                }
                if (!inputChild.equals(curChild)) continue;
                pastCurrentChild = true;
            }
        }
        return new NullActivity();
    }

    @Override
    protected boolean isComplete(int numOfCompletedActivities) {
        if (this.sequenceActivity != null) {
            return numOfCompletedActivities == this.sequenceActivity.getActivities().size();
        }
        return true;
    }

    @Override
    protected ComplexActivity getComplexActivity() {
        return this.sequenceActivity;
    }
}

