/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class LessonDAO
extends BaseDAO
implements ILessonDAO {
    private static final String FIND_LESSON_BY_CREATOR = "from " + Lesson.class.getName() + " lesson where lesson.user.userId=? and lesson.lessonStateId <= 6 and " + " lesson.learningDesign.copyTypeID=" + 2;
    private static final String FIND_PREVIEW_BEFORE_START_DATE = "from " + Lesson.class.getName() + " lesson where lesson.learningDesign.copyTypeID=" + 3 + "and lesson.startDateTime is not null and lesson.startDateTime < ?";
    private static final String COUNT_ACTIVE_LEARNERS = "select count(distinct progress.user.id) from " + LearnerProgress.class.getName() + " progress" + " where progress.lesson.id = :lessonId";
    private static final String FIND_LESSON_FOR_ACTIVITY = "select lesson from " + Lesson.class.getName() + " lesson, " + Activity.class.getName() + " activity " + " where activity.activityId=:activityId and activity.learningDesign=lesson.learningDesign";
    private static final String LESSONS_WITH_ORIGINAL_LEARNING_DESIGN = "select l from " + Lesson.class.getName() + " l " + "where l.learningDesign.originalLearningDesign.learningDesignId = ? " + "and l.learningDesign.copyTypeID != " + 3 + " " + "and l.lessonStateId = " + Lesson.STARTED_STATE + " " + "and l.organisation.organisationId = ? " + " order by l.lessonName";
    private static final String LESSONS_BY_GROUP = "from " + Lesson.class.getName() + " where organisation.organisationId=? and lessonStateId <= 6";
    private static final String LESSON_BY_SESSION_ID = "select lesson from Lesson lesson, ToolSession session where session.lesson=lesson and session.toolSessionId=:toolSessionID";

    @Override
    public Lesson getLesson(Long lessonId) {
        Lesson lesson = (Lesson)this.getHibernateTemplate().get(Lesson.class, (Serializable)lessonId);
        return lesson;
    }

    @Override
    public Lesson getLessonWithJoinFetchedProgress(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(Lesson.class).add((Criterion)Restrictions.like((String)"lessonId", (Object)lessonId)).setFetchMode("learnerProgresses", FetchMode.JOIN).uniqueResult();
            }
        });
    }

    @Override
    public List getAllLessons() {
        return this.getHibernateTemplate().loadAll(Lesson.class);
    }

    @Override
    public List getActiveLessonsForLearner(final User learner) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLessonsAllOrganisations");
                query.setInteger("userId", learner.getUserId().intValue());
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    @Override
    public List<Lesson> getActiveLessonsForLearner(final Integer learnerId, final Integer organisationId) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLessons");
                query.setInteger("userId", learnerId.intValue());
                query.setInteger("organisationId", organisationId.intValue());
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    @Override
    public List getActiveLearnerByLesson(final long lessonId) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLearners");
                query.setLong("lessonId", lessonId);
                List result = query.list();
                return result;
            }
        });
        return learners;
    }

    @Override
    public List getActiveLearnerByLessonAndGroup(final long lessonId, final long groupId) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLearnersByGroup");
                query.setLong("lessonId", lessonId);
                query.setLong("groupId", groupId);
                List result = query.list();
                return result;
            }
        });
        return learners;
    }

    @Override
    public Integer getCountActiveLearnerByLesson(final long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(COUNT_ACTIVE_LEARNERS);
                query.setLong("lessonId", lessonId);
                Object value = query.uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }

    @Override
    public void saveLesson(Lesson lesson) {
        this.getHibernateTemplate().save((Object)lesson);
    }

    @Override
    public void deleteLesson(Lesson lesson) {
        this.getHibernateTemplate().delete((Object)lesson);
    }

    @Override
    public void updateLesson(Lesson lesson) {
        this.getHibernateTemplate().update((Object)lesson);
    }

    @Override
    public List getLessonsCreatedByUser(Integer userID) {
        List lessons = this.getHibernateTemplate().find(FIND_LESSON_BY_CREATOR, (Object)userID);
        return lessons;
    }

    @Override
    public List getLessonsForMonitoring(final int userID, final int organisationID) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("lessonsForMonitoring");
                query.setInteger("userId", userID);
                query.setInteger("organisationId", organisationID);
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    @Override
    public List getPreviewLessonsBeforeDate(Date startDate) {
        List lessons = this.getHibernateTemplate().find(FIND_PREVIEW_BEFORE_START_DATE, (Object)startDate);
        return lessons;
    }

    @Override
    public Lesson getLessonForActivity(final long activityId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(FIND_LESSON_FOR_ACTIVITY);
                query.setLong("activityId", activityId);
                return query.uniqueResult();
            }
        });
    }

    @Override
    public List getLessonsByOrgAndUserWithCompletedFlag(final Integer userId, final Integer orgId, final Integer userRole) {
        List dtos = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        dtos = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String queryName = Role.ROLE_MONITOR.equals(userRole) ? "staffLessonsByOrgAndUserWithCompletedFlag" : (Role.ROLE_LEARNER.equals(userRole) ? "learnerLessonsByOrgAndUserWithCompletedFlag" : "allLessonsByOrgAndUserWithCompletedFlag");
                Query query = session.getNamedQuery(queryName);
                query.setInteger("userId", userId.intValue());
                query.setInteger("orgId", orgId.intValue());
                List result = query.list();
                return result;
            }
        });
        return dtos;
    }

    @Override
    public List getLessonsByGroupAndUser(final Integer userId, final Integer orgId) {
        List dtos = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        dtos = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("lessonsByOrgAndUserWithChildOrgs");
                query.setInteger("userId", userId.intValue());
                query.setInteger("orgId", orgId.intValue());
                List result = query.list();
                return result;
            }
        });
        return dtos;
    }

    @Override
    public List getLessonsByGroup(Integer orgId) {
        return this.getHibernateTemplate().find(LESSONS_BY_GROUP, (Object)orgId);
    }

    @Override
    public List getLessonsByOriginalLearningDesign(Long ldId, Integer orgId) {
        Object[] args = new Object[]{(long)ldId, (int)orgId};
        List lessons = this.getHibernateTemplate().find(LESSONS_WITH_ORIGINAL_LEARNING_DESIGN, args);
        return lessons;
    }

    @Override
    public List<User> getMonitorsByToolSessionId(Long sessionId) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("monitorsByToolSessionId", "sessionId", (Object)sessionId);
    }

    @Override
    public Lesson getLessonFromSessionID(final Long toolSessionID) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(LessonDAO.LESSON_BY_SESSION_ID);
                query.setLong("toolSessionID", toolSessionID.longValue());
                return query.uniqueResult();
            }
        });
    }
}

