/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.planner.dto;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerActivityDTO;

public class PedagogicalPlannerTemplateDTO {
    private String sequenceTitle;
    private Boolean sendInPortions;
    private Integer activitiesPerPortion;
    private Integer submitDelay;
    private List<PedagogicalPlannerActivityDTO> activities;
    private Long learningDesignID;
    private Integer activitySupportingPlannerCount = 0;
    private Long nodeUid;
    private Boolean isEditor = false;
    private Boolean permitPreview = true;
    private Boolean permitViewInFullAuthor = true;
    private Boolean permitExport = true;
    private Boolean permitSave = true;
    private Boolean permitExitEditor = true;

    public void setPermissions(Integer nodePermissions, boolean isEditor) {
        this.isEditor = isEditor;
        this.permitPreview = isEditor || nodePermissions == null || (nodePermissions & 0x40) != 0;
        this.permitViewInFullAuthor = isEditor || nodePermissions == null || (nodePermissions & 0x80) != 0;
        this.permitExport = isEditor || nodePermissions == null || (nodePermissions & 0x100) != 0;
        this.permitSave = isEditor || nodePermissions == null || (nodePermissions & 0x200) != 0;
    }

    public void overridePermissions(String forbid) {
        if (!StringUtils.isBlank((String)forbid)) {
            this.permitPreview = this.permitPreview & !forbid.contains(PermissionToLetterMapping.PREVIEW.getLetter());
            this.permitViewInFullAuthor = this.permitViewInFullAuthor & !forbid.contains(PermissionToLetterMapping.VIEW_IN_FULL_AUTHOR.getLetter());
            this.permitExport = this.permitExport & !forbid.contains(PermissionToLetterMapping.EXPORT.getLetter());
            this.permitSave = this.permitSave & !forbid.contains(PermissionToLetterMapping.SAVE.getLetter());
            this.permitExitEditor = this.permitExitEditor & !forbid.contains(PermissionToLetterMapping.CLOSE_EDITOR.getLetter());
        }
    }

    public String getSequenceTitle() {
        return this.sequenceTitle;
    }

    public void setSequenceTitle(String sequenceTitle) {
        this.sequenceTitle = sequenceTitle;
    }

    public Boolean getSendInPortions() {
        return this.sendInPortions;
    }

    public void setSendInPortions(Boolean sendInPortions) {
        this.sendInPortions = sendInPortions;
    }

    public Integer getActivitiesPerPortion() {
        return this.activitiesPerPortion;
    }

    public void setActivitiesPerPortion(Integer activitiesInPortion) {
        this.activitiesPerPortion = activitiesInPortion;
    }

    public Integer getSubmitDelay() {
        return this.submitDelay;
    }

    public void setSubmitDelay(Integer submitDelay) {
        this.submitDelay = submitDelay;
    }

    public List<PedagogicalPlannerActivityDTO> getActivities() {
        return this.activities;
    }

    public void setActivities(List<PedagogicalPlannerActivityDTO> activities) {
        this.activities = activities;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public void setLearningDesignID(Long learningDesignID) {
        this.learningDesignID = learningDesignID;
    }

    public Integer getActivitySupportingPlannerCount() {
        return this.activitySupportingPlannerCount;
    }

    public void setActivitySupportingPlannerCount(Integer activitySupportingPlannerCount) {
        this.activitySupportingPlannerCount = activitySupportingPlannerCount;
    }

    public Long getNodeUid() {
        return this.nodeUid;
    }

    public void setNodeUid(Long nodeUid) {
        this.nodeUid = nodeUid;
    }

    public Boolean getIsEditor() {
        return this.isEditor;
    }

    public void setIsEditor(Boolean isEditor) {
        this.isEditor = isEditor;
    }

    public Boolean getPermitPreview() {
        return this.permitPreview;
    }

    public void setPermitPreview(Boolean permitTeacherPreview) {
        this.permitPreview = permitTeacherPreview;
    }

    public Boolean getPermitViewInFullAuthor() {
        return this.permitViewInFullAuthor;
    }

    public void setPermitViewInFullAuthor(Boolean permitTeacherViewCopyInFullAuthor) {
        this.permitViewInFullAuthor = permitTeacherViewCopyInFullAuthor;
    }

    public Boolean getPermitExport() {
        return this.permitExport;
    }

    public void setPermitExport(Boolean permitTeacherExportCopy) {
        this.permitExport = permitTeacherExportCopy;
    }

    public Boolean getPermitSave() {
        return this.permitSave;
    }

    public void setPermitSave(Boolean permitTeacherSaveCopy) {
        this.permitSave = permitTeacherSaveCopy;
    }

    public Boolean getPermitExitEditor() {
        return this.permitExitEditor;
    }

    public void setPermitExitEditor(Boolean permitExitEditor) {
        this.permitExitEditor = permitExitEditor;
    }

    private static enum PermissionToLetterMapping {
        PREVIEW("P"),
        VIEW_IN_FULL_AUTHOR("V"),
        EXPORT("E"),
        SAVE("S"),
        CLOSE_EDITOR("C");

        private String letter;

        private PermissionToLetterMapping(String letter) {
            this.letter = letter;
        }

        public String getLetter() {
            return this.letter;
        }
    }
}

