/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.security.ISecurityDAO;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.security.SecurityException;
import org.lamsfoundation.lams.util.audit.IAuditService;

public class SecurityService
implements ISecurityService {
    private static Logger log = Logger.getLogger(SecurityService.class);
    private static final String SECURITY_MODULE_NAME = "security";
    private ISecurityDAO securityDAO;
    private IAuditService auditService;

    @Override
    public boolean isLessonLearner(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is learner and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is learner in lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is learner and can \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Integer orgId = lesson.getOrganisation().getOrganisationId();
        boolean hasSysadminRole = this.securityDAO.isSysadmin(userId);
        boolean hasOrgRole = this.securityDAO.hasOrgRole(orgId, userId, "LEARNER");
        if (!(hasSysadminRole || hasOrgRole && this.securityDAO.isLessonLearner(lessonId, userId))) {
            String error = "User " + userId + " is not learner in lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isLessonMonitor(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        boolean hasMonitorRole;
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is monitor and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is monitor in lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is monitor and can \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Integer orgId = lesson.getOrganisation().getOrganisationId();
        boolean hasSysadminRole = this.securityDAO.isSysadmin(userId);
        boolean hasGroupManagerRole = hasSysadminRole || this.securityDAO.isGroupManager(orgId, userId);
        boolean bl = hasMonitorRole = hasGroupManagerRole || this.securityDAO.hasOrgRole(orgId, userId, "MONITOR");
        if (!(hasGroupManagerRole || hasMonitorRole && this.securityDAO.isLessonMonitor(lessonId, userId, true))) {
            String error = "User " + userId + " is not monitor in lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isLessonParticipant(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        boolean hasRole;
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is participant and can \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is participant in lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is participant and can \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Integer orgId = lesson.getOrganisation().getOrganisationId();
        boolean hasSysadminRole = this.securityDAO.isSysadmin(userId);
        boolean hasGroupManagerRole = hasSysadminRole || this.securityDAO.isGroupManager(orgId, userId);
        boolean bl = hasRole = hasGroupManagerRole || this.securityDAO.hasOrgRole(orgId, userId, "LEARNER", "MONITOR");
        if (!(hasGroupManagerRole || hasRole && (this.securityDAO.isLessonLearner(lessonId, userId) || this.securityDAO.isLessonMonitor(lessonId, userId, true)))) {
            String error = "User " + userId + " is not participant in lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSysadmin(Integer userId, String action, boolean escalate) {
        if (userId == null) {
            String error = "Missing user ID when checking if is sysadmin and can \"" + action + "\"";
            log.error((Object)error);
            throw new SecurityException(error);
        }
        if (!this.securityDAO.isSysadmin(userId)) {
            String error = "User " + userId + " is not sysadmin and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isGroupManager(Integer orgId, Integer userId, String action, boolean escalate) throws SecurityException {
        if (orgId == null) {
            String error = "Missing organisation ID when checking if user is a manager of organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if user is a manager of organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (!this.securityDAO.isSysadmin(userId) && !this.securityDAO.isGroupManager(orgId, userId)) {
            String error = "User " + userId + " is not a manager of organisation " + orgId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isGroupMonitor(Integer orgId, Integer userId, String action, boolean escalate) throws SecurityException {
        if (orgId == null) {
            String error = "Missing organisation ID when checking if user is a monitor in organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if user is a monitor in organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (!(this.securityDAO.isSysadmin(userId) || this.securityDAO.isGroupManager(orgId, userId) || this.securityDAO.hasOrgRole(orgId, userId, "MONITOR"))) {
            String error = "User " + userId + " is not a monitor in organisation " + orgId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOrgRole(Integer orgId, Integer userId, String[] roles, String action, boolean escalate) throws SecurityException {
        if (orgId == null) {
            String error = "Missing organisation ID when checking if user " + userId + " has any of " + Arrays.toString(roles) + " roles in organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if has any of " + Arrays.toString(roles) + " roles in organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (!this.securityDAO.isSysadmin(userId) && !this.securityDAO.hasOrgRole(orgId, userId, roles)) {
            String error = "User " + userId + " does not have any of " + Arrays.toString(roles) + " roles in organisation " + orgId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.auditService.log(SECURITY_MODULE_NAME, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    public void setSecurityDAO(ISecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }
}

