/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtil {
    public static final String WDDX_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String LAMS_FLASH_FORMAT = "dd/M/yyyy h:mm a";

    public static Date convertToUTC(Date time) {
        TimeZone gmt = TimeZone.getTimeZone("Etc/GMT");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
        sdf.setTimeZone(gmt);
        String str = sdf.format(time);
        Timestamp gmtLocal = Timestamp.valueOf(str);
        GregorianCalendar gmtCanlendar = new GregorianCalendar(gmt);
        gmtCanlendar.setTimeInMillis(gmtLocal.getTime());
        return gmtCanlendar.getTime();
    }

    public static Date convertFromUTCToLocal(TimeZone localTimeZone, Date UTCDate) {
        GregorianCalendar canlendar = new GregorianCalendar(localTimeZone);
        long offset = canlendar.get(15) + canlendar.get(16);
        return new Date(UTCDate.getTime() + offset);
    }

    public static Date convertToTimeZoneFromDefault(TimeZone targetTimeZone, Date date) {
        TimeZone defaultTz = TimeZone.getDefault();
        Integer rawOffset = new Integer(defaultTz.getOffset(date.getTime()) - targetTimeZone.getOffset(date.getTime()));
        return new Date(date.getTime() - (long)rawOffset.intValue());
    }

    public static Date convertFromTimeZoneToDefault(TimeZone targetTimeZone, Date date) {
        TimeZone defaultTz = TimeZone.getDefault();
        Integer rawOffset = new Integer(defaultTz.getOffset(date.getTime()) - targetTimeZone.getOffset(date.getTime()));
        return new Date(date.getTime() + (long)rawOffset.intValue());
    }

    public static Date convertFromString(String dateString) throws ParseException {
        if (dateString == null) {
            return null;
        }
        SimpleDateFormat parser = null;
        String[] parseFormats = new String[]{WDDX_FORMAT};
        for (int i = 0; i < parseFormats.length; ++i) {
            if (i == 0) {
                parser = new SimpleDateFormat(parseFormats[0]);
            } else {
                parser.applyPattern(parseFormats[i]);
            }
            try {
                Date date = parser.parse(dateString);
                if (date == null) continue;
                return date;
            }
            catch (ParseException p) {
                // empty catch block
            }
        }
        throw new ParseException("Unable to parse date " + dateString, 0);
    }

    public static Date convertFromString(String dateString, String dateFormat) throws ParseException {
        if (dateString == null) {
            return null;
        }
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat);
        return parser.parse(dateString);
    }

    public static Date convertFromLAMSFlashFormat(String dateString) throws ParseException {
        return DateUtil.convertFromString(dateString, LAMS_FLASH_FORMAT);
    }
}

