/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrNodeVersion;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.SimpleVersionDetail;

public class CrNode
implements Serializable {
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$CrNode == null ? (class$org$lamsfoundation$lams$contentrepository$CrNode = CrNode.class$("org.lamsfoundation.lams.contentrepository.CrNode")) : class$org$lamsfoundation$lams$contentrepository$CrNode));
    private Long nodeId;
    private String path;
    private String type;
    private Date createdDateTime;
    private Long nextVersionId;
    private CrWorkspace crWorkspace;
    private CrNodeVersion parentNodeVersion;
    private Set crNodeVersions;
    private SortedSet versionHistory = null;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$CrNode;

    public CrNode(String path, String type, Date createdDateTime, Long nextVersionId, CrWorkspace crWorkspace, CrNodeVersion parentNodeVersion, Set crNodeVersions) {
        this.path = path;
        this.type = type;
        this.createdDateTime = createdDateTime;
        this.nextVersionId = nextVersionId;
        this.crWorkspace = crWorkspace;
        this.parentNodeVersion = parentNodeVersion;
        this.crNodeVersions = crNodeVersions;
    }

    public CrNode() {
    }

    public CrNode(String type, Long nextVersionId, CrWorkspace crWorkspace, CrNodeVersion parentNodeVersion, Set crNodeVersions) {
        this.type = type;
        this.nextVersionId = nextVersionId;
        this.crWorkspace = crWorkspace;
        this.parentNodeVersion = parentNodeVersion;
        this.crNodeVersions = crNodeVersions;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Long getNextVersionId() {
        return this.nextVersionId;
    }

    public void setNextVersionId(Long nextVersionId) {
        this.nextVersionId = nextVersionId;
    }

    public CrWorkspace getCrWorkspace() {
        return this.crWorkspace;
    }

    public void setCrWorkspace(CrWorkspace crWorkspace) {
        this.crWorkspace = crWorkspace;
    }

    public CrNodeVersion getParentNodeVersion() {
        return this.parentNodeVersion;
    }

    public void setParentNodeVersion(CrNodeVersion parentNodeVersion) {
        this.parentNodeVersion = parentNodeVersion;
    }

    public Set getCrNodeVersions() {
        return this.crNodeVersions;
    }

    private void setCrNodeVersions(Set crNodeVersions) {
        this.crNodeVersions = crNodeVersions;
    }

    public void addCrNodeVersion(CrNodeVersion version) {
        if (this.getCrNodeVersions() == null) {
            HashSet<CrNodeVersion> set = new HashSet<CrNodeVersion>();
            set.add(version);
            this.setCrNodeVersions(set);
        } else {
            this.getCrNodeVersions().add(version);
        }
        version.setNode(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("nodeId", (Object)this.getNodeId()).append("path", (Object)this.getPath()).append("type", (Object)this.getType()).append("createdDateTime", (Object)this.getCreatedDateTime()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrNode)) {
            return false;
        }
        CrNode castOther = (CrNode)other;
        return new EqualsBuilder().append((Object)this.getNodeId(), (Object)castOther.getNodeId()).append((Object)this.getPath(), (Object)castOther.getPath()).append((Object)this.getType(), (Object)castOther.getType()).append((Object)this.getCreatedDateTime(), (Object)castOther.getCreatedDateTime()).append((Object)this.getCrWorkspace(), (Object)castOther.getCrWorkspace()).append((Object)this.getParentNodeVersion(), (Object)castOther.getParentNodeVersion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getNodeId()).append((Object)this.getPath()).append((Object)this.getType()).append((Object)this.getCreatedDateTime()).append((Object)this.getCrWorkspace()).append((Object)this.getParentNodeVersion()).toHashCode();
    }

    public synchronized Long incrementNextVersionId() {
        Long retValue = this.nextVersionId;
        this.nextVersionId = new Long(this.nextVersionId + 1L);
        return retValue;
    }

    public SortedSet getVersionHistory() {
        if (this.versionHistory == null) {
            TreeSet<SimpleVersionDetail> history = new TreeSet<SimpleVersionDetail>();
            Set versions = this.getCrNodeVersions();
            if (versions != null) {
                Iterator iter = versions.iterator();
                while (iter.hasNext()) {
                    CrNodeVersion element = (CrNodeVersion)iter.next();
                    String desc = element.getVersionDescription();
                    history.add(new SimpleVersionDetail(element.getVersionId(), element.getCreatedDateTime(), desc));
                }
            }
            this.versionHistory = history;
        }
        return this.versionHistory;
    }

    public boolean isNodeType(String nodeTypeName) {
        return nodeTypeName != null && nodeTypeName.equals(this.getType());
    }

    public CrNodeVersion getNodeVersion(Long versionId) {
        CrNodeVersion nodeVersion = null;
        Set nodeVersionSet = this.getCrNodeVersions();
        if (nodeVersionSet != null) {
            Iterator iter = nodeVersionSet.iterator();
            nodeVersion = versionId != null ? this.findParticularVersion(iter, versionId) : this.findLatestVersion(iter);
        }
        return nodeVersion;
    }

    private CrNodeVersion findParticularVersion(Iterator nodeVersionSetIterator, Long versionId) {
        CrNodeVersion found = null;
        while (nodeVersionSetIterator.hasNext()) {
            CrNodeVersion element = (CrNodeVersion)nodeVersionSetIterator.next();
            if (!versionId.equals(element.getVersionId())) continue;
            found = element;
            break;
        }
        return found;
    }

    private CrNodeVersion findLatestVersion(Iterator nodeVersionSetIterator) {
        CrNodeVersion found = null;
        while (nodeVersionSetIterator.hasNext()) {
            CrNodeVersion element = (CrNodeVersion)nodeVersionSetIterator.next();
            if (found != null && (found.getVersionId() == null || found.getVersionId().compareTo(element.getVersionId()) >= 0)) continue;
            found = element;
        }
        return found;
    }

    public Long[] getVersionIds() {
        Set allCrNodeVersions = this.getCrNodeVersions();
        Long[] versions = new Long[allCrNodeVersions != null ? allCrNodeVersions.size() : 0];
        Iterator iter = allCrNodeVersions.iterator();
        int i = 0;
        while (iter.hasNext()) {
            CrNodeVersion element = (CrNodeVersion)iter.next();
            versions[i] = element.getVersionId();
        }
        return versions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

