/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.contentrepository.CrNode;
import org.lamsfoundation.lams.contentrepository.CrNodeVersionProperty;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;

public class CrNodeVersion
implements Serializable {
    private Long nvId;
    private Long versionId;
    private Date createdDateTime;
    private CrNode node;
    private Set crNodeVersionProperties;

    public CrNodeVersion(Long versionId, Date createdDateTime, CrNode node, Set crNodeVersionProperties) {
        this.versionId = versionId;
        this.createdDateTime = createdDateTime;
        this.node = node;
        this.crNodeVersionProperties = crNodeVersionProperties;
    }

    public CrNodeVersion() {
    }

    public CrNodeVersion(Long versionId, CrNode node, Set crNodeVersionProperties) {
        this.versionId = versionId;
        this.node = node;
        this.crNodeVersionProperties = crNodeVersionProperties;
    }

    public Long getNvId() {
        return this.nvId;
    }

    public void setNvId(Long nvId) {
        this.nvId = nvId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public CrNode getNode() {
        return this.node;
    }

    public void setNode(CrNode node) {
        this.node = node;
    }

    public Set getCrNodeVersionProperties() {
        return this.crNodeVersionProperties;
    }

    public void setCrNodeVersionProperties(Set crNodeVersionProperties) {
        this.crNodeVersionProperties = crNodeVersionProperties;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("nvId", (Object)this.getNvId()).append("versionId", (Object)this.getVersionId()).append("createdDateTime", (Object)this.getCreatedDateTime()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrNodeVersion)) {
            return false;
        }
        CrNodeVersion castOther = (CrNodeVersion)other;
        return new EqualsBuilder().append((Object)this.getNvId(), (Object)castOther.getNvId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getNvId()).append((Object)this.getVersionId()).append((Object)this.getCreatedDateTime()).append((Object)this.getNode()).toHashCode();
    }

    public CrNodeVersionProperty getProperty(String name) {
        if (name == null) {
            return null;
        }
        Set properties = this.getCrNodeVersionProperties();
        if (properties != null) {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                CrNodeVersionProperty element = (CrNodeVersionProperty)iter.next();
                if (!name.equals(element.getName())) continue;
                return element;
            }
        }
        return null;
    }

    private void removeProperty(String name) {
        Set properties;
        if (name != null && (properties = this.getCrNodeVersionProperties()) != null) {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                CrNodeVersionProperty element = (CrNodeVersionProperty)iter.next();
                if (!name.equals(element.getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    private CrNodeVersionProperty createProperty(String name, Object value, int valueType) {
        CrNodeVersionProperty property = new CrNodeVersionProperty();
        property.setCrNodeVersion(this);
        property.setName(name);
        property.setValue(value.toString());
        property.setType(valueType);
        return property;
    }

    public CrNodeVersionProperty setProperty(String name, Object value, int valueType) throws RepositoryRuntimeException {
        if (name == null) {
            throw new RepositoryRuntimeException("A name must be supplied - a property cannot have a null name.");
        }
        if (value == null) {
            this.removeProperty(name);
            return null;
        }
        HashSet<CrNodeVersionProperty> properties = this.getCrNodeVersionProperties();
        CrNodeVersionProperty prop = null;
        if (properties != null) {
            Iterator iter = properties.iterator();
            while (iter.hasNext() && prop == null) {
                CrNodeVersionProperty element = (CrNodeVersionProperty)iter.next();
                if (!name.equals(element.getName())) continue;
                prop = element;
            }
            if (prop != null) {
                prop.setValue(value.toString());
                prop.setType(valueType);
            } else {
                prop = this.createProperty(name, value, valueType);
                properties.add(prop);
            }
        } else {
            properties = new HashSet<CrNodeVersionProperty>();
            prop = this.createProperty(name, value, valueType);
            properties.add(prop);
            this.setCrNodeVersionProperties(properties);
        }
        return prop;
    }

    public String getVersionDescription() {
        CrNodeVersionProperty prop = this.getProperty("VERSIONDESC");
        return prop != null ? prop.getString() : null;
    }

    public void setVersionDescription(String description) {
        this.setProperty("VERSIONDESC", description, 1);
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public boolean hasProperties() {
        Set properties = this.getCrNodeVersionProperties();
        return properties != null && properties.size() > 0;
    }
}

